/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.context;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import kd.bos.SessionIdUtils;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.lang.Lang;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionManager;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.url.UrlService;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;

public class RequestContextCreator {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static RequestContext createOnlySession(String sessionId) {
        RequestContext rc = RequestContext.create();
        rc.setGlobalSessionId(sessionId);
        return rc;
    }

    public static void createBatch(String tenantId, String userId) {
        RequestContextCreator.createBatch(tenantId, null, userId);
    }

    public static void createForTripSI(String tenantId, String accountId, String userId) {
        String traceId = TraceIdUtil.getCurrentTraceIdString();
        String userAgent = "TripSI";
        String client = "TRIPSI";
        RequestContext rc = RequestContext.create(true);
        rc.setUserAgent(userAgent);
        rc.setClient(client);
        rc.setTraceId(traceId);
        rc.setTenantId(tenantId);
        rc.setAccountId(accountId);
        rc.setUserId(userId);
        rc.setGlobalSessionId(SessionIdUtils.newSessionId());
        RequestContextThreadBinder.bind(rc);
    }

    public static void createForPreheat(String tenantId, String accountId) {
        String traceId = TraceIdUtil.getCurrentTraceIdString();
        String userAgent = "Preheat";
        String client = "batch";
        RequestContext rc = RequestContext.create(true);
        rc.setUserAgent(userAgent);
        rc.setClient(client);
        rc.setTraceId(traceId);
        rc.setTenantId(tenantId);
        rc.setTenantCode(tenantId);
        rc.setAccountId(accountId);
        rc.setGlobalSessionId(SessionIdUtils.newSessionId());
        RequestContextThreadBinder.bind(rc);
    }

    public static void createFor3RDMQ(String tenantId, String accountId, String userId, Lang lang) {
        String traceId = TraceIdUtil.createTraceIdString();
        String client = "MQ";
        RequestContext rc = RequestContext.create(true);
        rc.setUserAgent("MQ");
        rc.setClient(client);
        rc.setTraceId(traceId);
        rc.setTenantId(tenantId);
        rc.setAccountId(accountId);
        rc.setUserId(userId);
        rc.setLang(lang);
        rc.setGlobalSessionId(SessionIdUtils.newSessionId());
        RequestContextThreadBinder.bind(rc);
    }

    public static void createBatch(String tenantId, String accountId, String userId) {
        RequestContextCreator.createBatch(tenantId, accountId, userId, 0L, null);
    }

    public static void createBatch(String tenantId, String accountId, String userId, long orgId, Lang lang) {
        RequestContextCreator.createBatch(tenantId, accountId, userId, orgId, lang, false);
    }

    public static void createBatch(String tenantId, String accountId, String userId, long orgId, Lang lang, boolean cacheGlSessionId) {
        String traceId = TraceIdUtil.getCurrentTraceIdString();
        String userAgent = "Schedule";
        String client = "batch";
        RequestContext rc = RequestContext.create(true);
        rc.setUserAgent(userAgent);
        rc.setClient(client);
        rc.setTraceId(traceId);
        rc.setTenantId(tenantId);
        rc.setTenantCode(tenantId);
        rc.setAccountId(accountId);
        rc.setUserId(userId);
        rc.setOrgId(orgId);
        rc.setLang(lang);
        if (cacheGlSessionId) {
            HashMap<String, String> sessionInfo = new HashMap<String, String>(16);
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            sessionInfo.put("accountId", accountId);
            sessionInfo.put("tenantId", tenantId);
            sessionInfo.put("userId", userId);
            sessionInfo.put("loginTime", df.format(new Date()));
            sessionInfo.put("client", client);
            rc.setGlobalSessionId(SessionManager.newSession(sessionInfo, Integer.getInteger("schedule.session.timeout", 1800)));
        } else {
            rc.setGlobalSessionId(SessionIdUtils.newSessionId());
        }
        RequestContextThreadBinder.bind(rc);
    }

    public static RequestContext createForMQ() {
        RequestContext current = RequestContext.get();
        RequestContext rc = RequestContext.create(false);
        if (current != null) {
            rc.setClient("MQ");
            rc.setUserAgent("MQ");
            rc.setTenantId(current.getTenantId());
            rc.setAccountId(current.getAccountId());
            rc.setUserId(current.getUserId());
            rc.setOrgId(current.getOrgId());
            rc.setGlobalSessionId(current.getGlobalSessionId());
            rc.setTenantCode(current.getTenantCode());
            rc.setLang(current.getLang());
            rc.setTenantInfo(current.getTenantInfo());
            rc.setUserName(current.getUserName());
            rc.setUserOpenId(current.getUserOpenId());
            rc.setUserType(current.getUserType());
            rc.setYzjAppId(current.getYzjAppId());
            rc.setYzjAppTicket(current.getYzjAppTicket());
            rc.setUid(current.getUid());
        }
        return rc;
    }

    public static RequestContext createForThreadPool() {
        RequestContext current = RequestContext.get();
        RequestContext rc = RequestContext.create(false);
        if (current != null) {
            rc.setClient("ThreadPool");
            rc.setUserAgent(null);
            rc.setTenantId(current.getTenantId());
            rc.setAccountId(current.getAccountId());
            rc.setUserId(current.getUserId());
            rc.setOrgId(current.getOrgId());
            rc.setGlobalSessionId(current.getGlobalSessionId());
            rc.setTenantCode(current.getTenantCode());
            rc.setLang(current.getLang());
            rc.setTenantInfo(current.getTenantInfo());
            rc.setUserName(current.getUserName());
            rc.setUserOpenId(current.getUserOpenId());
            rc.setUserType(current.getUserType());
            rc.setYzjAppId(current.getYzjAppId());
            rc.setYzjAppTicket(current.getYzjAppTicket());
            rc.setUid(current.getUid());
        }
        return rc;
    }

    public static void restoreForMQ(RequestContext rc) {
        RequestContextCreator.restore(rc);
    }

    public static void restoreForThreadPool(RequestContext rc) {
        RequestContextCreator.restore(rc);
    }

    private static void restore(RequestContext rc) {
        RequestContext.copyAndSet(rc);
        RequestContextThreadBinder.bind(rc);
    }

    public static void create(HttpServletRequest request, String globalSessionId, SessionInfo sessionInfo) {
        String traceId = TraceIdUtil.getCurrentTraceIdString();
        String userAgent = request.getHeader("User-Agent");
        String client = "web";
        RequestContext rc = RequestContext.create();
        String contextPath = request.getContextPath();
        String tenantAlias = UrlService.getTenantCode(request);
        if (!StringUtils.isEmpty((String)tenantAlias)) {
            contextPath = String.format("/%s", tenantAlias);
        }
        rc.setClientContextPath(contextPath);
        rc.setTenantCode(tenantAlias);
        rc.setClientFullContextPath(RevProxyUtil.getURLContextPath((HttpServletRequest)request));
        String requetstUrl = request.getRequestURL().toString();
        if (!StringUtils.isEmpty((String)requetstUrl) && "1".equalsIgnoreCase(request.getHeader("https")) && requetstUrl.startsWith("http://")) {
            requetstUrl = requetstUrl.replaceFirst("http:", "https:");
        }
        rc.setClientUrl(requetstUrl);
        rc.setQueryString(request.getQueryString());
        rc.setGlobalSessionId(globalSessionId);
        rc.setTenantId(sessionInfo.getTenantId());
        rc.setSandboxId(sessionInfo.getSandboxId());
        rc.setAccountId(sessionInfo.getAccountId());
        if (StringUtils.isNotEmpty((String)sessionInfo.getClient())) {
            client = sessionInfo.getClient();
        }
        rc.setClient(client);
        rc.setUserAgent(userAgent);
        rc.setUserId(sessionInfo.getUserId());
        rc.setUserName(sessionInfo.getUserName());
        rc.setUserOpenId(sessionInfo.getUserOpenId());
        rc.setUserType(sessionInfo.getUserType());
        rc.setOrgId(StringUtils.isEmpty((String)sessionInfo.getOrgId()) ? 0L : Long.parseLong(sessionInfo.getOrgId()));
        rc.setTraceId(traceId);
        rc.setRequestId(traceId);
        rc.setLoginIP(NetAddressUtils.getRemoteHost((HttpServletRequest)request));
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        rc.setLoginTime(df.format(new Date()));
        rc.setYzjAppId(sessionInfo.getYzjAppId());
        rc.setYzjAppTicket(sessionInfo.getYzjAppTicket());
        rc.setUid(sessionInfo.getUid());
        rc.setLoginOrg(sessionInfo.getLoginOrg());
        String sessionLang = sessionInfo.getLanguage();
        Lang lang = RequestContextCreator.getLang(sessionLang);
        rc.setLang(lang);
        rc.setAccCompanyId(sessionInfo.getAccCompany());
        if ("api".equalsIgnoreCase(rc.getClient())) {
            rc.setApi3rdAppId(String.valueOf(sessionInfo.getApi3rdAppId()));
        }
        rc.setClientImageServer(request.getHeader("clientImageServer"));
        RequestContextThreadBinder.bind(rc);
        SessionManager.touchSession(globalSessionId);
    }

    private static Lang getLang(String sessionLang) {
        Lang lang = Lang.from((String)sessionLang);
        if (lang == null) {
            lang = Lang.defaultLang();
        }
        return lang;
    }

    public static void createForOnlySesssion(String globalSessionId, SessionInfo sessionInfo, String client) {
        String traceId = TraceIdUtil.getCurrentTraceIdString();
        if (StringUtils.isEmpty((String)traceId)) {
            traceId = TraceIdUtil.createTraceIdString();
        }
        RequestContext rc = RequestContext.create();
        String tenantAlias = sessionInfo.getTenantId();
        rc.setTenantCode(tenantAlias);
        rc.setGlobalSessionId(globalSessionId);
        rc.setTenantId(sessionInfo.getTenantId());
        rc.setSandboxId(sessionInfo.getSandboxId());
        rc.setAccountId(sessionInfo.getAccountId());
        if (StringUtils.isNotEmpty((String)sessionInfo.getClient())) {
            client = sessionInfo.getClient();
        }
        rc.setClient(client);
        rc.setUserId(sessionInfo.getUserId());
        rc.setUserName(sessionInfo.getUserName());
        rc.setUserOpenId(sessionInfo.getUserOpenId());
        rc.setUserType(sessionInfo.getUserType());
        rc.setOrgId(StringUtils.isEmpty((String)sessionInfo.getOrgId()) ? 0L : Long.parseLong(sessionInfo.getOrgId()));
        rc.setTraceId(traceId);
        rc.setRequestId(traceId);
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
        rc.setLoginTime(df.format(new Date()));
        rc.setYzjAppId(sessionInfo.getYzjAppId());
        rc.setYzjAppTicket(sessionInfo.getYzjAppTicket());
        rc.setUid(sessionInfo.getUid());
        rc.setLoginOrg(sessionInfo.getLoginOrg());
        String sessionLang = sessionInfo.getLanguage();
        Lang lang = RequestContextCreator.getLang(sessionLang);
        rc.setLang(lang);
        RequestContextThreadBinder.bind(rc);
    }
}

