/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.context;

import java.io.Serializable;
import java.util.HashMap;

public class TrackContext
implements Serializable {
    private static final long serialVersionUID = 4671903017486499266L;
    public static final String STEP_NODE = "node";
    public static final String STEP_METHOD = "method";
    private HashMap<String, TrackStep> map = new HashMap(2);
    private static final String rootId = "0";
    private TrackStep currentStep = null;

    private String makeId() {
        return "" + this.map.size();
    }

    public void end() {
        if (this.currentStep != null) {
            this.currentStep.setEndtime(System.currentTimeMillis());
            this.currentStep = this.map.get(this.currentStep.getParentId());
        }
    }

    public boolean isInitiator() {
        return this.currentStep == null || this.currentStep.getId().equals(rootId);
    }

    public TrackStep getCurrentStep() {
        return this.currentStep;
    }

    public TrackStep getRootStep() {
        return this.map.get(rootId);
    }

    public void addTrackStep(String type, String machine, String desc) {
        TrackStep parent = this.currentStep;
        String parentId = parent == null ? rootId : parent.getId();
        int seqno = parent == null ? 0 : parent.childrenNum;
        long starttime = System.currentTimeMillis();
        TrackStep step = new TrackStep(this.makeId(), parentId, seqno, type, machine, desc, starttime, -1L);
        if (parent != null) {
            parent.incChildrenNum();
        }
        this.map.put(step.id, step);
        this.currentStep = step;
    }

    public static class TrackStep
    implements Serializable {
        private static final long serialVersionUID = 4315256310314858344L;
        private String id;
        private String parentId;
        private int seqno;
        private String type;
        private String machine;
        private String desc;
        private long starttime;
        private long endtime;
        private int childrenNum;

        private TrackStep(String id, String parentId, int seqno, String type, String machine, String desc, long starttime, long endtime) {
            this.id = id;
            this.parentId = parentId;
            this.seqno = seqno;
            this.type = type;
            this.machine = machine;
            this.desc = desc;
            this.starttime = starttime;
            this.endtime = endtime;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getMachine() {
            return this.machine;
        }

        public void setMachine(String machine) {
            this.machine = machine;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public long getStarttime() {
            return this.starttime;
        }

        public void setStarttime(long starttime) {
            this.starttime = starttime;
        }

        public long getEndtime() {
            return this.endtime;
        }

        public void setEndtime(long endtime) {
            this.endtime = endtime;
        }

        public void incChildrenNum() {
            ++this.childrenNum;
        }

        public int getSeqno() {
            return this.seqno;
        }

        public int getChildrenNum() {
            return this.childrenNum;
        }
    }
}

