/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle.appstart;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.lifecycle.appstart.AppStarter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AppStarterInstanceManager {
    private static Log log = LogFactory.getLog(AppStarterInstanceManager.class);

    private static Map<String, String> parseAppstarterConfig() {
        String[] starters;
        String appstarterConfig = System.getProperty("appstarter.config");
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (appstarterConfig == null) {
            return map;
        }
        for (String starter : starters = appstarterConfig.split(",|;")) {
            String[] result = starter.split("=");
            map.put(result[0], result[1]);
        }
        return map;
    }

    private static Properties get() {
        Properties p = new Properties();
        p.putAll(AppStarterInstanceManager.parseAppstarterConfig());
        try (InputStream in = AppStarterInstanceManager.class.getResourceAsStream("/kd/bos/framework/lifecycle/appstart/appstarter.properties");){
            p.load(in);
        }
        catch (IOException e) {
            log.error("Can't load /kd/bos/framework/lifecycle/appstart/appstarter.properties", (Throwable)e);
        }
        return p;
    }

    private static AppStarter createByClass(String className) {
        try {
            return (AppStarter)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new KDException(BosErrorCode.cannotLoadBeanClass, "Can't create AppStarter by " + className, (Throwable)e);
        }
    }

    public static List<AppStarter> getAppStarter(String[] appids) {
        Properties p = AppStarterInstanceManager.get();
        ArrayList<AppStarter> ls = new ArrayList<AppStarter>();
        for (String appid : appids) {
            String className = p.getProperty(appid);
            if (className == null) continue;
            try {
                ls.add(AppStarterInstanceManager.createByClass(className));
            }
            catch (Exception e) {
                log.warn("Can't create AppStarter by class: " + className, (Throwable)e);
            }
        }
        return ls;
    }

    public static List<AppStarter> getAppStarter() {
        Properties p = AppStarterInstanceManager.get();
        ArrayList<AppStarter> ls = new ArrayList<AppStarter>();
        for (String appid : p.stringPropertyNames()) {
            String className = p.getProperty(appid);
            if (className == null) continue;
            try {
                ls.add(AppStarterInstanceManager.createByClass(className));
            }
            catch (Exception e) {
                log.warn("Can't create AppStarter by className: " + className, (Throwable)e);
            }
        }
        return ls;
    }
}

