/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.preheat;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContextCreator;
import kd.bos.db.DBRoute;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.temptable.pk.PKTempTable;
import kd.bos.db.temptable.pk.config.PKTempTableConfig;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.framework.lifecycle.Service;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PKTempTablePreheatService
implements Service {
    private static Log log = LogFactory.getLog(PKTempTablePreheatService.class);

    @Override
    public String getName() {
        return PKTempTablePreheatService.class.getSimpleName();
    }

    @Override
    public void start() {
        if (!PKTempTableConfig.isNoPool()) {
            log.info("Preheating PKTempTable...");
            String[] appIds = Instance.getAppIds();
            if (appIds == null || appIds.length == 0) {
                appIds = new String[]{DBRoute.basedata.getRouteKey(), DBRoute.permission.getRouteKey(), DBRoute.log.getRouteKey(), DBRoute.workflow.getRouteKey()};
            }
            for (Account account : this.getAllAccountsOfCurrentEnv()) {
                String tenantId = account.getTenantId();
                String accountId = account.getAccountId();
                RequestContextCreator.createForPreheat(tenantId, accountId);
                HashSet<DBConfig> preheatedSet = new HashSet<DBConfig>(appIds.length);
                for (String appId : appIds) {
                    try (DelegateConnection con = (DelegateConnection)TX.__getConnection((String)appId, (boolean)false);){
                        DBConfig config = con.getDBConfig();
                        boolean heated = false;
                        for (DBConfig h : preheatedSet) {
                            if (!config.canSharing(h)) continue;
                            heated = true;
                            break;
                        }
                        if (heated) continue;
                        preheatedSet.add(config);
                        this.preheatPKTempTable(appId);
                    }
                    catch (Exception e) {
                        log.warn("PreHeat PKTempTable failed: tenantId=" + tenantId + ", appId=" + appId + ", accountId=" + accountId + ", cause by " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    private void preheatPKTempTable(String routeKey) throws Exception {
        DBRoute dbRoute = DBRoute.of((String)routeKey);
        PKTempTable t = PKTempTable.createPKLong((DBRoute)dbRoute);
        Throwable throwable = null;
        if (t != null) {
            if (throwable != null) {
                try {
                    t.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                t.close();
            }
        }
        t = PKTempTable.createPKString((DBRoute)dbRoute);
        throwable = null;
        if (t != null) {
            if (throwable != null) {
                try {
                    t.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
            } else {
                t.close();
            }
        }
        t = PKTempTable.createPKBigString((DBRoute)dbRoute);
        throwable = null;
        if (t != null) {
            if (throwable != null) {
                try {
                    t.close();
                }
                catch (Throwable throwable4) {
                    throwable.addSuppressed(throwable4);
                }
            } else {
                t.close();
            }
        }
    }

    private List<Account> getAllAccountsOfCurrentEnv() {
        try {
            return AccountUtils.getAllAccountsOfCurrentEnv();
        }
        catch (Exception ignored) {
            log.warn("Current env don't have tenant");
            return Collections.emptyList();
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isStarted() {
        return true;
    }
}

