/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.resource;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ResourceRecycleImpl {
    private static final Log logger = LogFactory.getLog(ResourceRecycleImpl.class);
    private String runnerClassName;
    private String theadnames;
    private int intvl;
    private ScheduledExecutorService es;

    public ResourceRecycleImpl(String runnerClassName, String theadname, int intvl) {
        this.runnerClassName = runnerClassName;
        this.theadnames = theadname;
        this.intvl = intvl;
        this.es = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, ResourceRecycleImpl.this.theadnames + this.atomicInteger.incrementAndGet());
            }
        });
    }

    public void start() {
        Runnable instance = null;
        try {
            Class<?> c = Class.forName(this.runnerClassName);
            instance = (Runnable)c.newInstance();
            this.es.scheduleAtFixedRate(instance, 30L, this.intvl, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.systemError, new Object[0]);
        }
    }

    public void stop() {
        try {
            this.es.shutdown();
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }
}

