/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.SessionIdUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.CacheLoginData;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.session.SessionInfo;
import kd.bos.session.SessionKeys;
import kd.bos.session.SessionQuery;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;

public class SessionManager {
    private static final int TIMEOUT_TIMES = 2;
    private static final String USER_ID = "user_id";
    private static final Log log = LogFactory.getLog(SessionManager.class);
    private static final String HTTPS = "https";
    private static String LastId = "";
    private static final String SESSION_ACCOUNT_SPLITSTR = "@@@";
    private static final String CP_CAO_PSA_OUR = "CP=CAO PSA OUR";

    public static String newSession(HttpServletRequest request, HttpServletResponse response, Map<String, String> sessionInfo) {
        return SessionManager.newSession(request, response, sessionInfo, true);
    }

    public static String newSession(HttpServletRequest request, HttpServletResponse response, Map<String, String> sessionInfo, boolean needCopyToClient) {
        String globalSessionId = SessionManager.newSession(sessionInfo);
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        boolean isSecure = SessionManager.isSecure(tenantAlias);
        if (needCopyToClient) {
            boolean httpOnly = SessionManager.getHttpOnly(tenantAlias);
            Cookie cookie = new Cookie(SessionKeys.getGlobalCookieSessionkey(tenantAlias), globalSessionId);
            cookie.setSecure(isSecure);
            if (httpOnly) {
                cookie.setHttpOnly(true);
            }
            cookie.setPath("/");
            response.setHeader("P3P", CP_CAO_PSA_OUR);
            response.addCookie(cookie);
            Cookie newCookie = new Cookie(SessionKeys.getOldGlobalCookieSessionkey(), globalSessionId);
            newCookie.setSecure(isSecure);
            if (httpOnly) {
                cookie.setHttpOnly(true);
            }
            newCookie.setPath("/");
            response.setHeader("P3P", CP_CAO_PSA_OUR);
            response.addCookie(newCookie);
        }
        return globalSessionId;
    }

    private static boolean getHttpOnly(String tenantAlias) {
        boolean httpOnly = true;
        String config_httponly = "config_httponly";
        String httpString = System.getProperty(tenantAlias + config_httponly);
        if (httpString == null || httpString.trim().length() == 0) {
            httpString = System.getProperty(config_httponly);
        }
        if ("false".equalsIgnoreCase(httpString)) {
            httpOnly = false;
        }
        return httpOnly;
    }

    private static boolean isSecure(String tenantAlias) {
        boolean isSecure = false;
        String domain = UrlService.getDomainContextUrlByTenantCode(tenantAlias);
        try {
            URI url = new URI(domain);
            if (HTTPS.equalsIgnoreCase(url.getScheme())) {
                isSecure = true;
            }
        }
        catch (URISyntaxException e) {
            log.warn((Throwable)e);
        }
        return isSecure;
    }

    public static String newSession(Map<String, String> sessionInfo) {
        return SessionManager.newSession(sessionInfo, SessionDAO.getSessionTimeout(sessionInfo.get("tenantId")));
    }

    public static String newSession(Map<String, String> sessionInfo, int timeout) {
        sessionInfo.put("kdCsrfToken", StringUtils.randomWord((int)32));
        String globalSessionId = SessionManager.getSessionIDString(sessionInfo);
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(globalSessionId);
        sessionDAO.initSessionId(sessionInfo.get("tenantId") + SESSION_ACCOUNT_SPLITSTR + sessionInfo.get("accountId"));
        sessionDAO.setAttributes(sessionInfo);
        sessionDAO.expireAfter(timeout);
        SessionManager.setCacheValue(SessionManager.getSaveString(sessionInfo), globalSessionId, sessionInfo.get("tenantId"));
        return globalSessionId;
    }

    private static String getSessionIDString(Map<String, String> sessionInfo) {
        return sessionInfo.get("accountId") + "_" + StringUtils.randomWord((int)100);
    }

    private static String getSaveString(Map<String, String> sessionInfo) {
        String returnString = "";
        if (sessionInfo != null) {
            StringBuilder sb = new StringBuilder(sessionInfo.get("userId"));
            sb.append(",").append(sessionInfo.get("orgId"));
            sb.append(",").append(sessionInfo.get("client"));
            sb.append(",").append(sessionInfo.get("accountId"));
            sb.append(",").append(sessionInfo.get("tenantId"));
            if (StringUtils.isNotEmpty((String)sessionInfo.get("loginIP"))) {
                sb.append(",").append(sessionInfo.get("loginIP").split(",")[0]);
            }
            returnString = sb.toString();
        }
        return returnString;
    }

    public static String newSession(HttpServletRequest request, HttpServletResponse response, SessionInfo sessionInfo, boolean needCopyToClient) {
        return SessionManager.newSession(request, response, sessionInfo.toMap(), needCopyToClient);
    }

    public static String newSession(SessionInfo sessionInfo) {
        return SessionManager.newSession(sessionInfo.toMap());
    }

    public static String newSession(String orgId, String tenantId, String userId, String userName, String userOpenID, String IP) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> sessionInfo = new HashMap<String, String>();
        sessionInfo.put("orgId", orgId);
        sessionInfo.put("tenantId", tenantId);
        sessionInfo.put("userId", userId);
        sessionInfo.put("userName", userName);
        sessionInfo.put("userOpenId", userOpenID);
        sessionInfo.put("loginTime", df.format(new Date()));
        sessionInfo.put("loginIP", IP);
        String globalSessionId = SessionIdUtils.newSessionId();
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(globalSessionId);
        sessionDAO.initSessionId(tenantId);
        sessionDAO.setAttributes(sessionInfo);
        sessionDAO.expireAfter(SessionDAO.getSessionTimeout(tenantId));
        SessionManager.setCacheValue(SessionManager.getSaveString(sessionInfo), globalSessionId, tenantId);
        return globalSessionId;
    }

    public static String getUserIdFromCach(String globalSessionId) {
        String userId = null;
        if (StringUtils.isNotEmpty((String)globalSessionId)) {
            userId = CacheLoginData.getAttribute(USER_ID, globalSessionId);
        }
        return userId;
    }

    private static void setCacheValue(String value, String globalSessionId, String tenantId) {
        CacheLoginData.setAttribute(USER_ID, globalSessionId, value, SessionDAO.getSessionTimeout(tenantId) * 2);
    }

    public static void expireCacheValue(String globalSessionId, int timeout) {
        CacheLoginData.expire(USER_ID, globalSessionId, timeout);
    }

    public static void removeCacheValue(String globalSessionId) {
        CacheLoginData.remove(USER_ID, globalSessionId);
    }

    public static String removeSession(HttpServletRequest request, HttpServletResponse response, String globalSessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(globalSessionId);
        sessionDAO.remove();
        SessionManager.removeCacheValue(globalSessionId);
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        boolean isSecure = SessionManager.isSecure(tenantAlias);
        Cookie cookie = new Cookie(SessionKeys.getGlobalCookieSessionkey(tenantAlias), null);
        cookie.setSecure(isSecure);
        cookie.setPath("/");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
        Cookie newCookie = new Cookie(SessionKeys.getOldGlobalCookieSessionkey(), null);
        newCookie.setSecure(isSecure);
        newCookie.setPath("/");
        newCookie.setMaxAge(0);
        response.addCookie(newCookie);
        return globalSessionId;
    }

    public static void removeSession(String globalSessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(globalSessionId);
        sessionDAO.remove();
        SessionManager.removeCacheValue(globalSessionId);
    }

    public static String newSession(String tenantId, String accountId, String userId, int timeout) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, String> sessionInfo = new HashMap<String, String>();
        sessionInfo.put("accountId", accountId);
        sessionInfo.put("tenantId", tenantId);
        sessionInfo.put("userId", userId);
        sessionInfo.put("loginTime", df.format(new Date()));
        return SessionManager.newSession(sessionInfo, timeout);
    }

    public static void editOrgSessionByUserId(String accountId, String userId, String orgId) {
        List<String> sessionList = SessionQuery.getUserSessions(accountId, userId);
        if (sessionList != null && sessionList.size() > 0) {
            for (String sessionId : sessionList) {
                SessionManager.editSessionValue(sessionId, "orgId", orgId);
            }
        }
    }

    public static void editOrgSession(String orgId) {
        HashMap<String, String> sessionInfo = new HashMap<String, String>();
        sessionInfo.put("orgId", orgId);
        SessionDAO sessionDAO = SessionDAOFactory.get();
        if (sessionDAO != null) {
            sessionDAO.setAttributes(sessionInfo);
        }
    }

    public static void editLoginOrgSession(String orgCode) {
        HashMap<String, String> sessionInfo = new HashMap<String, String>();
        sessionInfo.put("loginOrg", orgCode);
        SessionDAO sessionDAO = SessionDAOFactory.get();
        if (sessionDAO != null) {
            sessionDAO.setAttributes(sessionInfo);
        }
    }

    public static void copySession(HttpServletRequest request, HttpServletResponse response, String globalSessionId) {
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        boolean isSecure = SessionManager.isSecure(tenantAlias);
        Cookie cookie = new Cookie(SessionKeys.getGlobalCookieSessionkey(tenantAlias), globalSessionId);
        cookie.setSecure(isSecure);
        cookie.setPath("/");
        response.setHeader("P3P", CP_CAO_PSA_OUR);
        response.addCookie(cookie);
        Cookie newCookie = new Cookie(SessionKeys.getOldGlobalCookieSessionkey(), globalSessionId);
        newCookie.setSecure(isSecure);
        newCookie.setPath("/");
        response.setHeader("P3P", CP_CAO_PSA_OUR);
        response.addCookie(newCookie);
    }

    public static String copySession(SessionInfo sessionInfo, int timeout) {
        String globalSessionId = SessionIdUtils.newSessionId();
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(globalSessionId);
        sessionDAO.initSessionId(sessionInfo.getTenantId() + SESSION_ACCOUNT_SPLITSTR + sessionInfo.getAccountId());
        sessionDAO.setAttributes(sessionInfo.toMap());
        sessionDAO.expireAfter(timeout);
        SessionManager.setCacheValue(SessionManager.getSaveString(sessionInfo.toMap()), globalSessionId, sessionInfo.getTenantId());
        return globalSessionId;
    }

    public static void editSessionValue(String sessionId, String key, String value) {
        HashMap<String, String> sessionInfo = new HashMap<String, String>();
        sessionInfo.put(key, value);
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(sessionId);
        if (sessionDAO != null) {
            sessionDAO.setAttributes(sessionInfo);
        }
    }

    public static String getCSRFTokenValue(String sessionId) {
        String returnValue = SessionManager.getAttributeFromSession(sessionId, "kdCsrfToken");
        return returnValue;
    }

    private static String getAttributeFromSession(String sessionId, String key) {
        SessionDAO sessionDAO;
        Map<String, String> sessionInfo;
        String returnValue = "";
        if (StringUtils.isNotEmpty((String)sessionId) && (sessionInfo = (sessionDAO = SessionDAOFactory.getSessionDAO(sessionId)).getAttributesAsMap(new String[]{key})) != null && sessionInfo.size() > 0) {
            returnValue = sessionInfo.get(key);
        }
        return returnValue;
    }

    public static Map<String, String> getSessionOrgByUserId(String accountId, String userId) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        List<String> sessionList = SessionQuery.getUserSessions(accountId, userId);
        if (sessionList != null && sessionList.size() > 0) {
            for (String sessionId : sessionList) {
                String org = SessionManager.getAttributeFromSession(sessionId, "orgId");
                returnMap.put(sessionId, org);
            }
        }
        return returnMap;
    }

    public static void writeCookieData(HttpServletRequest request, HttpServletResponse response, String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        response.setHeader("P3P", CP_CAO_PSA_OUR);
        response.addCookie(cookie);
    }

    public static String getCookieDataByName(HttpServletRequest request, String name) {
        String value = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                value = cookie.getValue();
            }
        }
        return value;
    }

    public static void touchSession(String sessionId) {
        SessionDAO sessionDAO = SessionDAOFactory.getSessionDAO(sessionId);
        if (sessionDAO != null) {
            sessionDAO.touchSession();
        }
    }
}

