/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.session.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.SessionIdUtils;
import kd.bos.cache.redis.RedisSessionableCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.Gauge;
import kd.bos.metric.MetricSystem;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionManager;
import kd.bos.session.impl.ExpireDeamon;

public class DistributeCacheSessionDAO
implements SessionDAO {
    private static final Log log = LogFactory.getLog(DistributeCacheSessionDAO.class);
    private static final String config_prefix_key = "metric.session.prefix";
    private static String prefix = "kd.metrics.session.";
    private static Gauge<Integer> sessionGauge = null;
    private static RedisSessionableCache cache;
    private static ExpireDeamon expireDeamon;
    private static int expireDeamonPeriod;
    private static ConcurrentHashMap<String, Long> touchTimestampMap;
    private String sessionId;

    public DistributeCacheSessionDAO(String sessionId) {
        this.sessionId = sessionId;
    }

    protected static Integer getCurrentSessionCount() {
        return cache.getSessionCount();
    }

    @Override
    public void touchSession() {
        touchTimestampMap.putIfAbsent(this.sessionId, System.currentTimeMillis());
    }

    private static void touch(String sessionId) {
    }

    private static void initTimeoutDaemon() {
        TimeoutCleaner cleaner = new TimeoutCleaner("Session-Timeout-Daemon", 60, 60000);
        cleaner.start();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getAttribute(String key) {
        DistributeCacheSessionDAO.touch(this.sessionId);
        return cache.get(this.sessionId, key);
    }

    @Override
    public String[] getAttributes(String[] keys) {
        DistributeCacheSessionDAO.touch(this.sessionId);
        List atts = cache.get(this.sessionId, keys);
        if (atts == null) {
            return null;
        }
        return atts.toArray(new String[atts.size()]);
    }

    @Override
    public Map<String, String> getAttributesAsMap(String[] keys) {
        DistributeCacheSessionDAO.touch(this.sessionId);
        List atts = cache.get(this.sessionId, keys);
        if (atts == null || atts.size() == 0) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(atts.size());
        for (int i = 0; i < keys.length; ++i) {
            result.put(keys[i], (String)atts.get(i));
        }
        return result;
    }

    @Override
    public void setAttribute(String key, String value) {
        DistributeCacheSessionDAO.touch(this.sessionId);
        cache.put(this.sessionId, key, value);
    }

    @Override
    public void setAttributes(Map<String, String> map) {
        DistributeCacheSessionDAO.touch(this.sessionId);
        cache.put(this.sessionId, map);
    }

    @Override
    public void remove() {
        cache.remove(this.sessionId);
    }

    @Override
    public void expireAfter(int second) {
        cache.expireAfter(this.sessionId, second);
    }

    @Override
    public void removeByKeyPrefix(String keyPrefix) {
        List keys = cache.getKeysWithPrefix(this.sessionId, keyPrefix);
        if (keys != null && !keys.isEmpty()) {
            cache.remove(this.sessionId, keys.toArray(new String[keys.size()]));
        }
        DistributeCacheSessionDAO.touch(this.sessionId);
    }

    @Override
    public void initSessionId(String accountId) {
        cache.addSessionId(this.sessionId, accountId);
    }

    @Override
    public void updateExpireTimeout() {
    }

    static {
        expireDeamonPeriod = 5000;
        touchTimestampMap = new ConcurrentHashMap();
        cache = new RedisSessionableCache();
        expireDeamon = new ExpireDeamon(cache, expireDeamonPeriod);
        String enable = System.getProperty("metrics.enable.sessionCount");
        if ("true".equals(enable)) {
            String p = System.getProperty(config_prefix_key, prefix);
            String name = p + "activeCount";
            sessionGauge = new Gauge<Integer>(){

                public Integer getValue() {
                    return DistributeCacheSessionDAO.getCurrentSessionCount();
                }
            };
            MetricSystem.registerGauge((String)name, sessionGauge);
        }
        DistributeCacheSessionDAO.initTimeoutDaemon();
    }

    static class TimeoutCleaner
    extends Thread {
        private int timeout;
        private int loopInterval;

        TimeoutCleaner(String name, int timeout, int loopInterval) {
            super(name);
            this.timeout = timeout;
            this.loopInterval = loopInterval;
        }

        private int toSecond(long ms) {
            return (int)(ms / 1000L);
        }

        @Override
        public void run() {
            while (true) {
                ArrayList keys = null;
                for (Map.Entry entry : touchTimestampMap.entrySet()) {
                    long time = (Long)entry.getValue();
                    if (this.toSecond(System.currentTimeMillis() - time) <= this.timeout) continue;
                    if (keys == null) {
                        keys = new ArrayList();
                    }
                    keys.add(entry.getKey());
                }
                if (keys != null) {
                    for (String key : keys) {
                        try {
                            int timeout = SessionIdUtils.getTimeout(key);
                            int ttl = timeout - this.toSecond(System.currentTimeMillis() - (Long)touchTimestampMap.get(key));
                            cache.expireAfter(key, ttl);
                            SessionManager.expireCacheValue(key, ttl * 2);
                            touchTimestampMap.remove(key);
                        }
                        catch (Exception t) {
                            log.warn((Throwable)t);
                        }
                    }
                }
                try {
                    Thread.sleep(this.loopInterval);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    log.warn((Throwable)interruptedException);
                    continue;
                }
                break;
            }
        }
    }
}

