/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(ResourceManager.class);

    private static URL getResourceURL(Class cls, String resName) {
        return cls.getResource(resName);
    }

    private static URL getResourceURL(String packName, String resName) {
        String pkg;
        if (StringUtil.isEmptyString((String)packName)) {
            pkg = "";
        } else {
            pkg = packName.indexOf(46) != -1 ? packName.replaceAll("\\.", "/") : packName;
            pkg = pkg + "/";
        }
        return ResourceManager.class.getClassLoader().getResource(pkg + resName);
    }

    public static Image getImage(Class cls, String resName) {
        return ResourceManager.getIcon(cls, resName).getImage();
    }

    public static Image getImage(String packName, String resName) {
        return ResourceManager.getIcon(packName, resName).getImage();
    }

    public static ImageIcon getIcon(Class cls, String resName) {
        URL url = ResourceManager.getResourceURL(cls, resName);
        return ResourceManager.getIcon(url);
    }

    public static ImageIcon getIcon(String packName, String resName) {
        URL url = ResourceManager.getResourceURL(packName, resName);
        return ResourceManager.getIcon(url);
    }

    private static ImageIcon getIcon(URL url) {
        ImageIcon image = null;
        try {
            image = new ImageIcon(url);
        }
        catch (Exception ex1) {
            try {
                image = new ImageIcon(ResourceManager.getResourceURL("com.kingdee.cosmic.ctrl.common.ui.resource", "notfound.gif"));
            }
            catch (Exception ex2) {
                image = new ImageIcon();
                logger.warn("\u627e\u4e0d\u5230\u9ed8\u8ba4\u56fe\u6807", (Throwable)ex2);
            }
        }
        return image;
    }
}

