/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.currency;

import com.kingdee.cosmic.ctrl.common.currency.ICurrencyUpperFunction;
import com.kingdee.cosmic.ctrl.common.digitalstyle.Format;
import com.kingdee.cosmic.ctrl.common.digitalstyle.Formats;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.variant.Variant;
import java.util.Locale;

public class FormatMYR
implements ICurrencyUpperFunction {
    @Override
    public String format(Locale locale, Variant variant, boolean isAddPrefix) {
        Format format;
        String result = null;
        if (locale == Locale.ENGLISH) {
            format = Formats.getFormat("[ENG-MYR]0.00");
        } else if (locale == Locale.SIMPLIFIED_CHINESE) {
            format = Formats.getFormat("[CHS-MYR]0.00;[CHS-MYR]0.00");
        } else if (locale == Locale.TRADITIONAL_CHINESE) {
            format = Formats.getFormat("[CHT-MYR]0.00;[CHT-MYR]0.00");
        } else {
            throw new RuntimeException("Not support language: " + locale);
        }
        result = format.format4Print(variant).toString();
        if (isAddPrefix && locale != Locale.ENGLISH) {
            if (locale == Locale.SIMPLIFIED_CHINESE) {
                result = CtrlCommonUIMessages.getMLS("rmb", "\u4ee4\u5409") + result;
            } else if (locale == Locale.TRADITIONAL_CHINESE) {
                result = CtrlCommonUIMessages.getMLS("rmb", "\u4ee4\u5409") + result;
            } else {
                throw new RuntimeException("Not support language: " + locale);
            }
        }
        return result;
    }
}

