/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.digitalstyle;

import com.kingdee.cosmic.ctrl.common.digitalstyle.FormatResult;
import com.kingdee.cosmic.ctrl.common.digitalstyle.Formats;
import com.kingdee.cosmic.ctrl.common.digitalstyle.Node;
import com.kingdee.cosmic.ctrl.common.digitalstyle.SimpleFormat;
import com.kingdee.cosmic.ctrl.common.variant.Util;
import com.kingdee.cosmic.ctrl.common.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.CtrlFormatUtilities;
import java.math.BigDecimal;
import java.util.ArrayList;

class GeneralFormat
extends SimpleFormat {
    static final GeneralFormat defaultInstance = new GeneralFormat();

    GeneralFormat() {
    }

    @Override
    public FormatResult format(Variant var, boolean parse) {
        if (var == null) {
            return FormatResult.NullResult;
        }
        String likelyValue = this.getLikelyValue(var);
        StringBuilder sb = new StringBuilder();
        int repeatIndex = -1;
        int size = this._nodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = (Node)this._nodes.get(i);
            if (node.getType() == 26) {
                sb.append(likelyValue);
            } else {
                sb.append(node.getText());
            }
            if (node.getType() != 24) continue;
            repeatIndex = i;
        }
        String result = sb.toString();
        return new FormatResult(result, repeatIndex);
    }

    String getLikelyValue(Variant var) {
        String ret = null;
        int vt = var.getVt();
        if (vt == 10) {
            BigDecimal bd = (BigDecimal)var.getValue();
            if (bd.scale() > 15) {
                Variant varTmp = new Variant((Object)bd.setScale(15, 4), 10);
                Util.reduceScale((Variant)varTmp);
                ret = varTmp.toString();
            } else {
                ret = Util.bigDecimalToPlainString((BigDecimal)bd);
            }
            ret = ret.replace('.', CtrlFormatUtilities.getDecimalFormatSymbols().getDecimalSeparator());
        } else {
            ret = var.isDate() ? Formats.getFormat("yyyy-mm-dd").format(var).toString() : var.toString();
        }
        return ret;
    }

    @Override
    public FormatResult format4Print(Variant obj, boolean parse) {
        return FormatResult.EmptyResult;
    }

    static {
        GeneralFormat.defaultInstance._nodes = new ArrayList();
        GeneralFormat.defaultInstance._nodes.add(Node.General);
    }
}

