/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.digitalstyle;

import com.kingdee.cosmic.ctrl.common.digitalstyle.i18n.IMultiLanguageSay;
import com.kingdee.cosmic.ctrl.common.digitalstyle.i18n.chs.SimplifiedChineseSay;
import com.kingdee.cosmic.ctrl.common.digitalstyle.i18n.cht.TraditionalChineseSay;
import com.kingdee.cosmic.ctrl.common.digitalstyle.i18n.eng.EnglishSay;
import com.kingdee.cosmic.ctrl.common.variant.Variant;
import java.util.HashMap;
import java.util.Map;

class NumMultiLanFormat {
    private static Map LAN_STRATEGY;

    NumMultiLanFormat() {
    }

    private static Map getStrategy() {
        if (LAN_STRATEGY == null) {
            LAN_STRATEGY = new HashMap();
            LAN_STRATEGY.put("ENG", new EnglishSay());
            LAN_STRATEGY.put("CHS", new SimplifiedChineseSay());
            LAN_STRATEGY.put("CHT", new TraditionalChineseSay());
        }
        return LAN_STRATEGY;
    }

    public String formatNumber(Variant value, String lan) {
        IMultiLanguageSay strategy = (IMultiLanguageSay)NumMultiLanFormat.getStrategy().get(lan.toUpperCase());
        if (strategy != null) {
            return strategy.sayNumber(value);
        }
        return value.toString();
    }

    public String formatCurrency(Variant value, String lan, String currencyIsoCode) {
        IMultiLanguageSay strategy = (IMultiLanguageSay)NumMultiLanFormat.getStrategy().get(lan.toUpperCase());
        if (strategy != null) {
            return strategy.sayCurrency(value, currencyIsoCode);
        }
        return value.toString();
    }
}

