/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.ui.resource.ResourceManager;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.KDTreeView;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class TreeView
extends KDTreeView {
    private static final long serialVersionUID = 3322737563147573611L;
    private SizeStack undoStack;
    private SizeStack redoStack;
    private KDWorkButton btnUndo;
    private KDWorkButton btnRedo;
    private KDWorkButton btnUpper;
    private boolean disableUndoRedoButtons = false;
    private boolean isNeedToStore = true;

    public TreeView(KDTree tree) {
        super(tree, false);
        this.initComponent();
        this.installListener();
    }

    private void initComponent() {
        this.btnUndo = new KDWorkButton();
        this.btnUndo.setIcon((Icon)ResourceManager.getIcon("tbtn_previous.gif"));
        this.btnUndo.setToolTipText(CtrlCommonUIMessages.getMLS("backward", "\u5411\u540e"));
        this.btnUndo.setEnabled(false);
        this.btnUndo.setFocusable(false);
        this.btnRedo = new KDWorkButton();
        this.btnRedo.setIcon((Icon)ResourceManager.getIcon("tbtn_next.gif"));
        this.btnRedo.setToolTipText(CtrlCommonUIMessages.getMLS("forward", "\u5411\u524d"));
        this.btnRedo.setEnabled(false);
        this.btnRedo.setFocusable(false);
        this.btnUpper = new KDWorkButton();
        this.btnUpper.setIcon((Icon)ResourceManager.getIcon("tbtn_superior.gif"));
        this.btnUpper.setToolTipText(CtrlCommonUIMessages.getMLS("upward", "\u4e0a\u4e00\u7ea7"));
        this.btnUpper.setEnabled(false);
        this.btnUpper.setFocusable(false);
        this.undoStack = new SizeStack(10);
        this.redoStack = new SizeStack(11);
        this.getControlPane().add((Component)this.btnUndo);
        this.getControlPane().add((Component)this.btnRedo);
        this.getControlPane().add((Component)this.btnUpper);
    }

    private void installListener() {
        this.btnUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeView.this.undo();
            }
        });
        this.btnRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeView.this.redo();
            }
        });
        this.btnUpper.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeView.this.upper();
            }
        });
        this.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (TreeView.this.isNeedToStore && e.getNewLeadSelectionPath() != null) {
                    TreeView.this.storeUndo(e.getOldLeadSelectionPath(), e.getNewLeadSelectionPath());
                }
            }
        });
    }

    private void storeUndo(TreePath oldPath, TreePath newPath) {
        if (oldPath != null) {
            this.undoStack.push(oldPath);
            this.redoStack.removeAllElements();
            this.redoStack.push(newPath);
        }
        this.syncTreeViewButton();
    }

    private void selectTreePath(TreePath path) {
        this.getTree().setSelectionPath(path);
        this.getTree().scrollPathToVisible(path);
    }

    private void undo() {
        TreePath path = (TreePath)this.undoStack.pop();
        this.redoStack.push(path);
        this.isNeedToStore = false;
        this.selectTreePath(path);
        this.isNeedToStore = true;
        this.syncTreeViewButton();
    }

    private void redo() {
        TreePath path = (TreePath)this.redoStack.pop();
        this.undoStack.push(path);
        path = (TreePath)this.redoStack.peek();
        this.isNeedToStore = false;
        this.selectTreePath(path);
        this.isNeedToStore = true;
        this.syncTreeViewButton();
    }

    private void upper() {
        TreePath path = this.getTree().getSelectionPath();
        if (path == null) {
            return;
        }
        path = path.getParentPath();
        this.getTree().setSelectionPath(path);
        this.getTree().scrollPathToVisible(path);
    }

    private void syncTreeViewButton() {
        if (this.undoStack.size() == 0) {
            this.btnUndo.setEnabled(false);
        } else {
            this.btnUndo.setEnabled(true);
        }
        if (this.redoStack.size() <= 1) {
            this.btnRedo.setEnabled(false);
        } else {
            this.btnRedo.setEnabled(true);
        }
        if (this.getTree().isRootVisible() && this.getTree().getSelectionPath().getPathCount() == 1 || !this.getTree().isRootVisible() && this.getTree().getSelectionPath().getPathCount() == 2) {
            this.btnUpper.setEnabled(false);
        } else {
            this.btnUpper.setEnabled(true);
        }
    }

    public Dimension minimumLayoutSize(Container Container2) {
        return new Dimension(32, 50);
    }

    public void disableUndoRedoButtons() {
        this.getControlPane().remove((Component)this.btnUndo);
        this.getControlPane().remove((Component)this.btnRedo);
        this.disableUndoRedoButtons = true;
    }

    private static class SizeStack
    extends Stack {
        private static final long serialVersionUID = 4799645055524421752L;
        private int maxSize;

        public SizeStack(int size) {
            this.maxSize = size;
        }

        public Object push(Object item) {
            if (this.size() >= this.maxSize) {
                this.removeElementAt(0);
            }
            return super.push(item);
        }
    }
}

