/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.layout.table.Cell;
import com.kingdee.cosmic.ctrl.common.layout.table.Table;
import com.kingdee.cosmic.ctrl.common.layout.table.TableLayout;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public abstract class TypicalDialog
extends KDDialog {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int CENTER = 4;
    public static final int TOP = 256;
    public static final int BOTTOM = 512;
    public static final int MIDDLE = 1024;
    protected boolean isOk;
    protected KDButton btnOk;
    protected KDButton btnCancel;
    protected boolean isAddControls = false;
    private KDPanel panExt;
    protected Action keyAction = new AbstractAction(){
        private static final long serialVersionUID = 344156941987734759L;

        @Override
        public void actionPerformed(ActionEvent e) {
            char keyCode = e.getActionCommand().charAt(0);
            switch (keyCode) {
                case '\n': {
                    TypicalDialog.this.onOk();
                    break;
                }
                case '\u001b': {
                    TypicalDialog.this.onCancel();
                    break;
                }
                default: {
                    TypicalDialog.this.todoKeyAction(keyCode);
                }
            }
        }
    };
    protected ActionListener actionListner = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source.equals(TypicalDialog.this.btnOk)) {
                TypicalDialog.this.onOk();
            } else if (source.equals(TypicalDialog.this.btnCancel)) {
                TypicalDialog.this.onCancel();
            } else {
                TypicalDialog.this.todoActionPerformed(e);
            }
        }
    };
    protected boolean hasOwner;
    protected int windowAlign = 1028;
    protected int buttonAlign = 512;

    public TypicalDialog() {
        this.hasOwner = false;
        this.init();
    }

    public TypicalDialog(Frame owner) {
        super(owner);
        this.hasOwner = true;
        this.init();
    }

    public TypicalDialog(Dialog owner) {
        super(owner);
        this.hasOwner = true;
        this.init();
    }

    protected void init() {
        this.setModal(true);
        this.setSize(770, 480);
        this.setDefaultCloseOperation(2);
        this.isOk = false;
        this.btnOk = new KDButton(CtrlCommonUIMessages.getMLS("confirm", "\u786e\u5b9a"));
        this.btnCancel = new KDButton(CtrlCommonUIMessages.getMLS("cancel", "\u53d6\u6d88"));
        this.btnOk.addActionListener(this.actionListner);
        this.btnCancel.addActionListener(this.actionListner);
        this.panExt = new KDPanel();
        this.todoInit();
    }

    protected void addControls() {
        Table tab;
        TableLayout layout;
        if (this.buttonAlign == 512) {
            layout = TableLayout.splitRow((int)3);
            layout.rowStyle(0).setPriY(1);
            layout.rowStyle(1).setHeight(2);
            layout.rowStyle(1).setAlignmentY((short)4);
            tab = layout.cell(2).splitCol(3);
            tab.colStyle(0).setPriX(1);
            tab.colStyle(2).setMarginLeft(3);
            layout.rowStyle(0).setMargin(10);
            layout.rowStyle(2).setMargin(10);
        } else {
            layout = TableLayout.splitCol((int)3);
            layout.colStyle(0).setPriX(1);
            layout.colStyle(1).setWidth(2);
            layout.colStyle(1).setAlignmentX((short)4);
            tab = layout.cell(2).splitRow(3);
            tab.rowStyle(2).setPriY(1);
            tab.rowStyle(0).setMarginBottom(3);
            layout.colStyle(0).setMargin(10);
            layout.colStyle(2).setMargin(10);
        }
        Container cp = super.getContentPane();
        cp.setLayout((LayoutManager)layout);
        cp.add((Component)new KDSeparator(this.buttonAlign == 512 ? 0 : 1), layout.cell(1));
        cp.add((Component)this.btnOk, tab.cell(1));
        if (this.btnCancel.isVisible()) {
            cp.add((Component)this.btnCancel, tab.cell(2));
        }
        cp.add((Component)this.panExt, tab.cell(0));
        this.registKeyAction(10, 0);
        this.registKeyAction(27, 0);
        this.todoAddControls(cp, layout.cell(0));
        this.isAddControls = true;
    }

    protected void registKeyAction(int keyCode, int modifiers) {
        JRootPane rootPane = this.getRootPane();
        rootPane.getActionMap().put(this.keyAction, this.keyAction);
        rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(keyCode, modifiers), this.keyAction);
    }

    protected abstract void todoInit();

    protected abstract void todoAddControls(Container var1, Cell var2);

    protected void todoActionPerformed(ActionEvent e) {
    }

    protected void todoKeyAction(int keyCode) {
    }

    protected boolean verify() {
        return true;
    }

    protected void onOk() {
        if (this.verify()) {
            this.isOk = true;
            this.dispose();
        }
    }

    protected void onCancel() {
        this.isOk = false;
        this.dispose();
    }

    public int getButtonAlign() {
        return this.buttonAlign;
    }

    public void setButtonAlign(int barAlign) {
        this.buttonAlign = barAlign;
    }

    public int getWindowAlign() {
        return this.windowAlign;
    }

    public void setWindowAlign(int windowAlign) {
        this.windowAlign = windowAlign;
    }

    private void makeAlignBounds() {
        int height;
        int width;
        int y;
        int x;
        Rectangle rc = new Rectangle(this.getBounds());
        if (this.hasOwner) {
            Rectangle rcOwner = this.getOwner().getBounds();
            x = rcOwner.x;
            y = rcOwner.y;
            width = rcOwner.width;
            height = rcOwner.height;
        } else {
            Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
            x = 0;
            y = 0;
            width = sz.width;
            height = sz.height;
        }
        if ((this.windowAlign & 4) == 4) {
            rc.x = x + (width - rc.width) / 2;
            if (rc.x < 0) {
                rc.x = 0;
            }
        }
        if ((this.windowAlign & 0x400) == 1024) {
            rc.y = y + (height - rc.height) / 2;
            if (rc.y < 0) {
                rc.y = 0;
            }
        }
        this.setBounds(rc);
    }

    public boolean showDialog() {
        if (!this.isAddControls) {
            this.addControls();
            this.isAddControls = true;
        }
        this.makeAlignBounds();
        super.show();
        return this.isOk;
    }

    protected KDPanel getExtPanel() {
        return this.panExt;
    }

    public static void main(String[] args) {
        KDFrame frm = new KDFrame();
        frm.setBounds(200, 200, 500, 400);
        frm.show();
        TypicalDialog dlg = new TypicalDialog((Frame)frm){
            private static final long serialVersionUID = -7233826544443125163L;

            @Override
            protected void todoInit() {
            }

            @Override
            protected void todoAddControls(Container parent, Cell thisCell) {
            }

            @Override
            protected void todoActionPerformed(ActionEvent e) {
            }

            @Override
            protected void todoKeyAction(int keyCode) {
            }
        };
        dlg.setSize(500, 200);
        dlg.showDialog();
        frm.dispose();
    }
}

