/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.layout.table.Cell;
import com.kingdee.cosmic.ctrl.common.layout.table.Table;
import com.kingdee.cosmic.ctrl.common.layout.table.TableLayout;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public abstract class TypicalDialogWithApply
extends KDDialog {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int CENTER = 4;
    public static final int TOP = 256;
    public static final int BOTTOM = 512;
    public static final int MIDDLE = 1024;
    protected boolean isOk;
    protected KDButton btnApply;
    protected KDButton btnOk;
    protected KDButton btnCancel;
    protected boolean isAddControls = false;
    protected Action keyAction = new AbstractAction(){
        private static final long serialVersionUID = 6793951450893032866L;

        @Override
        public void actionPerformed(ActionEvent e) {
            char keyCode = e.getActionCommand().charAt(0);
            switch (keyCode) {
                case '\n': {
                    TypicalDialogWithApply.this.onOk();
                    break;
                }
                case '\u001b': {
                    TypicalDialogWithApply.this.onCancel();
                    break;
                }
                default: {
                    TypicalDialogWithApply.this.todoKeyAction(keyCode);
                }
            }
        }
    };
    protected ActionListener actionListner = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source.equals(TypicalDialogWithApply.this.btnOk)) {
                TypicalDialogWithApply.this.onOk();
            } else if (source.equals(TypicalDialogWithApply.this.btnCancel)) {
                TypicalDialogWithApply.this.onCancel();
            } else if (source.equals(TypicalDialogWithApply.this.btnApply)) {
                TypicalDialogWithApply.this.onApply();
            } else {
                TypicalDialogWithApply.this.todoActionPerformed(e);
            }
        }
    };
    protected boolean hasOwner;
    private int windowAlign = 1028;
    private int buttonAlign = 512;

    public TypicalDialogWithApply() {
        this.hasOwner = false;
        this.init();
    }

    public TypicalDialogWithApply(Frame owner) {
        super(owner);
        this.hasOwner = true;
        this.init();
    }

    public TypicalDialogWithApply(Dialog owner) {
        super(owner);
        this.hasOwner = true;
        this.init();
    }

    protected void init() {
        this.setModal(true);
        this.setSize(640, 480);
        this.setDefaultCloseOperation(2);
        this.isOk = false;
        this.btnApply = new KDButton(CtrlCommonUIMessages.getMLS("apply", "\u5e94\u7528"));
        this.btnOk = new KDButton(CtrlCommonUIMessages.getMLS("confirm", "\u786e\u5b9a"));
        this.btnCancel = new KDButton(CtrlCommonUIMessages.getMLS("cancel", "\u53d6\u6d88"));
        this.btnApply.addActionListener(this.actionListner);
        this.btnOk.addActionListener(this.actionListner);
        this.btnCancel.addActionListener(this.actionListner);
        this.todoInit();
    }

    public void addControls() {
        TableLayout layout = TableLayout.splitRow((int)3);
        layout.rowStyle(0).setPriY(1);
        layout.rowStyle(1).setHeight(2);
        layout.rowStyle(1).setAlignmentY((short)4);
        Table tab = layout.cell(2).splitCol(4);
        tab.colStyle(0).setPriX(1);
        tab.colStyle(2).setMarginLeft(3);
        tab.colStyle(3).setMarginLeft(3);
        layout.rowStyle(0).setMargin(10);
        layout.rowStyle(2).setMargin(10);
        Container cp = super.getContentPane();
        cp.setLayout((LayoutManager)layout);
        cp.add((Component)new KDSeparator(this.buttonAlign == 512 ? 0 : 1), layout.cell(1));
        cp.add((Component)this.btnApply, tab.cell(1));
        cp.add((Component)this.btnOk, tab.cell(2));
        cp.add((Component)this.btnCancel, tab.cell(3));
        this.registKeyAction(10, 0);
        this.registKeyAction(27, 0);
        this.todoAddControls(cp, layout.cell(0));
        this.isAddControls = true;
    }

    protected void registKeyAction(int keyCode, int modifiers) {
        JRootPane rootPane = this.getRootPane();
        rootPane.getActionMap().put(this.keyAction, this.keyAction);
        rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(keyCode, modifiers), this.keyAction);
    }

    protected abstract void onApply();

    protected abstract void todoInit();

    protected abstract void todoAddControls(Container var1, Cell var2);

    protected void todoActionPerformed(ActionEvent e) {
    }

    protected void todoKeyAction(int keyCode) {
    }

    protected boolean verify() {
        return true;
    }

    protected void onOk() {
        if (this.verify()) {
            this.isOk = true;
            this.dispose();
        }
    }

    protected void onCancel() {
        this.isOk = false;
        this.dispose();
    }

    public int getButtonAlign() {
        return this.buttonAlign;
    }

    public void setButtonAlign(int barAlign) {
        this.buttonAlign = barAlign;
    }

    public int getWindowAlign() {
        return this.windowAlign;
    }

    public void setWindowAlign(int windowAlign) {
        this.windowAlign = windowAlign;
    }

    private void makeAlignBounds() {
        int height;
        int width;
        int y;
        int x;
        Rectangle rc = new Rectangle(this.getBounds());
        if (this.hasOwner) {
            Rectangle rcOwner = this.getOwner().getBounds();
            x = rcOwner.x;
            y = rcOwner.y;
            width = rcOwner.width;
            height = rcOwner.height;
        } else {
            Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
            x = 0;
            y = 0;
            width = sz.width;
            height = sz.height;
        }
        if ((this.windowAlign & 4) == 4) {
            rc.x = x + (width - rc.width) / 2;
            if (rc.x < 0) {
                rc.x = 0;
            }
        }
        if ((this.windowAlign & 0x400) == 1024) {
            rc.y = y + (height - rc.height) / 2;
            if (rc.y < 0) {
                rc.y = 0;
            }
        }
        this.setBounds(rc);
    }

    public boolean showDialog() {
        if (!this.isAddControls) {
            this.addControls();
            this.isAddControls = true;
        }
        this.makeAlignBounds();
        super.show();
        return this.isOk;
    }

    public static void main(String[] args) {
        KDFrame frm = new KDFrame();
        frm.setBounds(200, 200, 500, 400);
        frm.show();
        TypicalDialogWithApply dlg = new TypicalDialogWithApply((Frame)frm){
            private static final long serialVersionUID = 6514547390006398442L;

            @Override
            protected void todoInit() {
            }

            @Override
            protected void todoAddControls(Container parent, Cell thisCell) {
            }

            @Override
            protected void todoActionPerformed(ActionEvent e) {
            }

            @Override
            protected void todoKeyAction(int keyCode) {
            }

            @Override
            protected void onApply() {
            }

            public void addToolBar(JToolBar toolBar, int orientation) {
            }

            public void addToolBar(JToolBar toolBar, int orientation, Object identify) {
            }

            public void addToolBar(JToolBar toolBar) {
            }

            public void addToolBar(JToolBar toolBar, Object identify) {
            }

            public void removeToolBar(JToolBar toolbar) {
            }

            public void setJMenuBar(JMenuBar menuBar) {
            }

            public void removeJMenuBar(JMenuBar menuBar) {
            }

            public void setToolBarIdentify(JToolBar toolBar, Object identify) {
            }
        };
        dlg.setSize(500, 200);
        dlg.showDialog();
        frm.dispose();
    }
}

