/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.bosmetaselector;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefViewFilter;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.Enumeration;
import javax.swing.tree.MutableTreeNode;

class SubSystemUtil {
    private static final String ENTITYSYSNAME = "com_kingdee_eas_base_subsystemEntity";
    private static final String QUERYSYSNAME = "com_kingdee_eas_base_query";

    SubSystemUtil() {
    }

    public static DefaultKingdeeTreeNode getEntityTreeRootNode() {
        MetaDataBriefViewFilter filter = new MetaDataBriefViewFilter();
        filter.setViewName(ENTITYSYSNAME);
        filter.addMetaDataTypeFilter(MetaDataTypeList.ENTITY);
        IBriefViewTreeNode bvtn = SubSystemUtil.getSubSystem(filter);
        return SubSystemUtil.getMetaTreeRootNode(bvtn);
    }

    public static DefaultKingdeeTreeNode getQueryTreeRootNode() {
        MetaDataBriefViewFilter filter = new MetaDataBriefViewFilter();
        filter.setViewName(QUERYSYSNAME);
        filter.addMetaDataTypeFilter(MetaDataTypeList.JOINQUERY);
        filter.addMetaDataTypeFilter(MetaDataTypeList.UNIONQUERY);
        IBriefViewTreeNode bvtn = SubSystemUtil.getSubSystem(filter);
        return SubSystemUtil.getMetaTreeRootNode(bvtn);
    }

    private static DefaultKingdeeTreeNode getMetaTreeRootNode(IBriefViewTreeNode bvtn) {
        SubSystemUtil.removeEmptyPackageNode(bvtn);
        DefaultKingdeeTreeNode root = SubSystemUtil.getKDTreeNode(bvtn);
        root.setText("EAS");
        SubSystemUtil.doEasSpecial(root);
        return root;
    }

    private static DefaultKingdeeTreeNode getKDTreeNode(IBriefViewTreeNode root) {
        if (root.getChildCount() == 0) {
            return SubSystemUtil.createKDTreeNode(root);
        }
        DefaultKingdeeTreeNode newRoot = SubSystemUtil.createKDTreeNode(root);
        IBriefViewTreeNode node = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            node = (IBriefViewTreeNode)root.getChildAt(i);
            newRoot.add((MutableTreeNode)SubSystemUtil.getKDTreeNode(node));
        }
        return newRoot;
    }

    private static DefaultKingdeeTreeNode createKDTreeNode(IBriefViewTreeNode node) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode();
        if (StringUtil.isEmptyString((String)node.getAlias())) {
            newNode.setText(node.getName());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(node.getAlias());
            sb.append(" (");
            sb.append(node.getName());
            sb.append(')');
            newNode.setText(sb.toString());
        }
        newNode.setUserObject((Object)node.getMetaDataObjectBriefInfo());
        return newNode;
    }

    private static void removeEmptyPackageNode(IBriefViewTreeNode root) {
        IBriefViewTreeNode node = null;
        if (root.getChildCount() > 0) {
            for (int i = root.getChildCount() - 1; i >= 0; --i) {
                node = (IBriefViewTreeNode)root.getChildAt(i);
                SubSystemUtil.removeEmptyPackageNode(node);
                if (node.getChildCount() != 0 || !node.getMetaDataType().equals((Object)MetaDataTypeList.PACKAGE)) continue;
                root.remove((MutableTreeNode)node);
            }
        }
    }

    private static IBriefViewTreeNode getSubSystem(MetaDataBriefViewFilter filter) {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)filter.getViewName());
        BusinessObjectBriefView bobv = MetaDataLoaderFactory.getRemoteMetaDataLoader().getBusinessObjectBriefView(pk);
        IBriefViewTreeNode root = bobv.getViewRootByType(filter.getMetaDataTypeFilters());
        return root;
    }

    private static void doEasSpecial(DefaultKingdeeTreeNode root) {
        String calName = "com.kingdee.eas.scm.cal";
        String fiName = "com.kingdee.eas.fi";
        DefaultKingdeeTreeNode calNode = null;
        DefaultKingdeeTreeNode fiNode = null;
        boolean hasFiNode = false;
        boolean hasCalNode = false;
        Enumeration enu = root.breadthFirstEnumeration();
        while (enu.hasMoreElements()) {
            DefaultKingdeeTreeNode aNode = (DefaultKingdeeTreeNode)enu.nextElement();
            MetaDataBriefInfo mdbi = (MetaDataBriefInfo)aNode.getUserObject();
            if (!mdbi.isPackage()) continue;
            String pkgName = mdbi.getPackgeName().trim();
            if (pkgName.equals("com.kingdee.eas.fi")) {
                fiNode = aNode;
                hasFiNode = true;
                if (!hasCalNode) continue;
                break;
            }
            if (!pkgName.equals("com.kingdee.eas.scm.cal")) continue;
            calNode = aNode;
            hasCalNode = true;
            if (!hasFiNode) continue;
            break;
        }
        if (hasFiNode && hasCalNode) {
            calNode.removeFromParent();
            fiNode.add(calNode);
        }
    }
}

