/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.console;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.ResourceManager;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.ui.console.AbstractConsoleAction;
import com.kingdee.cosmic.ctrl.common.ui.console.ConsolePane;
import com.kingdee.cosmic.ctrl.common.ui.console.IActionBuildExtEvent;
import com.kingdee.cosmic.ctrl.common.ui.console.content.IBranchContent;
import com.kingdee.cosmic.ctrl.common.ui.console.content.IConsoleContent;
import com.kingdee.cosmic.ctrl.common.ui.console.content.ILeafContent;
import com.kingdee.cosmic.ctrl.common.ui.console.menuelement.CMenu;
import com.kingdee.cosmic.ctrl.common.ui.console.menuelement.CMenuItem;
import com.kingdee.cosmic.ctrl.common.ui.console.menuelement.CSeparator;
import com.kingdee.cosmic.ctrl.common.ui.console.menuelement.CWorkButton;
import com.kingdee.cosmic.ctrl.common.ui.console.menuelement.IMenuElement;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ConsoleConfigReader {
    private static final Logger log = LogUtil.getLogger(ConsoleConfigReader.class);
    private ConsolePane console = new ConsolePane();
    private String iconPackage;
    private HashMap mapAssNodes;
    private HashMap mapMenuNode;
    private IActionBuildExtEvent actionBuildExtEvent;

    public void biuld(IXmlElement docRoot) {
        IXmlElement treeRoot = docRoot.getChild("TreeRoot");
        this.mapAssNodes = this.cacheNodes(docRoot.getChild("Associate"), "Node");
        this.bindAssociate(this.console.getSystemContent(), docRoot.getChild("Associate").getChild("Common"));
        this.iconPackage = treeRoot.getAttribute("iconpackage");
        boolean isShow = "true".equalsIgnoreCase(treeRoot.getAttribute("isshow"));
        this.console.setRootNodeShow(isShow);
        this.addBranch(null, treeRoot);
        this.console.validateConsoleTree();
    }

    private HashMap cacheNodes(IXmlElement parentNode, String childTag) {
        HashMap<String, IXmlElement> map = new HashMap<String, IXmlElement>();
        if (parentNode != null) {
            List ass = parentNode.searchChildren(childTag);
            for (IXmlElement node : ass) {
                map.put(node.getAttribute("id"), node);
            }
        }
        return map;
    }

    private void addBranch(DefaultKingdeeTreeNode parent, IXmlElement branchNode) {
        String text = branchNode.getAttribute("text");
        String icon = branchNode.getAttribute("icon");
        String assId = branchNode.getAttribute("associate");
        IBranchContent bc = this.console.createBranchContentInstance();
        this.bindAssociate(bc, (IXmlElement)this.mapAssNodes.get(assId));
        DefaultKingdeeTreeNode treeNode = parent == null ? this.console.setRootNode(bc, text, this.getIcon(icon)) : this.console.addBranch(parent, bc, text, this.getIcon(icon));
        List lstChild = branchNode.getChildren();
        for (IXmlElement node : lstChild) {
            if ("Branch".equalsIgnoreCase(node.getName())) {
                this.addBranch(treeNode, node);
                continue;
            }
            if (!"Leaf".equalsIgnoreCase(node.getName())) continue;
            this.addFunction(treeNode, node);
        }
    }

    private void addFunction(DefaultKingdeeTreeNode parent, IXmlElement functionNode) {
        String text = functionNode.getAttribute("text");
        String icon = functionNode.getAttribute("icon");
        String assId = functionNode.getAttribute("associate");
        String funcClass = functionNode.getAttribute("classname");
        ILeafContent func = (ILeafContent)this.createClassByName(funcClass);
        DefaultKingdeeTreeNode treeNode = this.console.addLeaf(parent, func, text, this.getIcon(icon));
        this.bindAssociate((ILeafContent)treeNode.getUserObject(), (IXmlElement)this.mapAssNodes.get(assId));
    }

    private void bindAssociate(IConsoleContent obj, IXmlElement assNode) {
        if (assNode == null) {
            return;
        }
        HashMap mapAction = this.cacheNodes(assNode.getChild("Actions"), "Action");
        obj.setMenuBarList(this.createMenuList(assNode.getChild("Menus"), mapAction, obj));
        obj.setToolBarList(this.createToolbarList(assNode.getChild("Toolbar"), mapAction, obj));
        obj.setPopMenuList(this.createPopMenuList(assNode.getChild("PopMenu"), mapAction, obj));
    }

    private List createMenuList(IXmlElement menusNode, HashMap mapAction, IConsoleContent content) {
        ArrayList<CMenu> list = new ArrayList<CMenu>();
        if (menusNode != null) {
            this.mapMenuNode = this.cacheNodes(menusNode, "Menu");
            List lstMenuNodes = menusNode.searchChildren("Menu");
            Iterator it = lstMenuNodes.iterator();
            while (it.hasNext()) {
                list.add(this.createMenu((IXmlElement)it.next(), mapAction, content));
            }
        }
        return list;
    }

    private List createToolbarList(IXmlElement toolbarNode, HashMap mapAction, IConsoleContent content) {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (toolbarNode != null) {
            List lstChild = toolbarNode.getChildren();
            Iterator it = lstChild.iterator();
            while (it.hasNext()) {
                JComponent item = this.createItem((IXmlElement)it.next(), toolbarNode, mapAction, content);
                if (item == null) continue;
                list.add(item);
            }
        }
        return list;
    }

    private List createPopMenuList(IXmlElement popNode, HashMap mapAction, IConsoleContent content) {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (popNode != null) {
            IXmlElement node = null;
            String sync = popNode.getAttribute("syncmenu");
            if (!StringUtil.isEmptyString((String)sync)) {
                node = (IXmlElement)this.mapMenuNode.get(sync);
            }
            if (node == null) {
                node = popNode;
            }
            List lstChild = node.getChildren();
            Iterator it = lstChild.iterator();
            while (it.hasNext()) {
                JComponent item = this.createItem((IXmlElement)it.next(), node, mapAction, content);
                if (item == null) continue;
                list.add(item);
            }
        }
        return list;
    }

    private CMenu createMenu(IXmlElement menuNode, HashMap mapAction, IConsoleContent content) {
        CMenu menu = new CMenu();
        menu.setText(menuNode.getAttribute("text"));
        menu.setMnemonic(this.getMnemonicChar(menuNode.getAttribute("mnemonic")));
        menu.setInsertIndex(this.getInt(menuNode.getAttribute("index")));
        List lstChild = menuNode.getChildren();
        Iterator it = lstChild.iterator();
        while (it.hasNext()) {
            JComponent item = this.createItem((IXmlElement)it.next(), menuNode, mapAction, content);
            if (item == null) continue;
            menu.add(item);
        }
        return menu;
    }

    private JComponent createItem(IXmlElement itemNode, IXmlElement parentNode, HashMap mapAction, IConsoleContent content) {
        IMenuElement item = null;
        int idx = this.getInt(itemNode.getAttribute("index"));
        if ("Separator".equalsIgnoreCase(itemNode.getName())) {
            item = "Toolbar".equalsIgnoreCase(parentNode.getName()) ? new CSeparator(1) : new CSeparator(0);
            item.setInsertIndex(idx);
            return item;
        }
        String actionId = itemNode.getAttribute("action");
        String text = null;
        AbstractAction action = null;
        String mnStr = null;
        IXmlElement actionNode = (IXmlElement)mapAction.get(actionId);
        if (actionNode != null) {
            text = actionNode.getAttribute("text");
            mnStr = actionNode.getAttribute("mnemonic");
            String classname = actionNode.getAttribute("classname");
            Object actionObj = this.createClassByName(classname);
            if (actionObj instanceof AbstractConsoleAction) {
                action = (AbstractConsoleAction)actionObj;
                action.setUI(content);
                if (this.actionBuildExtEvent != null) {
                    this.actionBuildExtEvent.doExt((AbstractConsoleAction)action);
                }
            } else if (actionObj instanceof AbstractAction) {
                action = (AbstractAction)actionObj;
            }
        }
        if (action == null) {
            String parentText;
            StringBuilder sb = new StringBuilder(CtrlCommonUIMessages.getMLS("actionNotDefined", "\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ca1\u6709\u5b9a\u4e49Action: #1\uff0c\u6216\u521b\u5efa\u4e0d\u5230\u5b9e\u4f8b\u3002\u6765\u81ea\u8282\u70b9:#2").replace("#1", actionId).replace("#2", parentNode.getName()));
            String parentId = parentNode.getAttribute("id");
            if (parentId != null) {
                sb.append(" id=");
                sb.append(parentId);
            }
            if ((parentText = parentNode.getAttribute("text")) != null) {
                sb.append(" text=");
                sb.append(parentText);
            }
            log.error((Object)sb.toString());
            return null;
        }
        if ("MenuItem".equalsIgnoreCase(itemNode.getName())) {
            item = new CMenuItem(action);
            if (!StringUtil.isEmptyString((String)text)) {
                ((CMenuItem)item).setText(text);
            }
            ((CMenuItem)item).setMnemonic(this.getMnemonicChar(mnStr));
            ((CMenuItem)item).setInsertIndex(idx);
        } else if ("Button".equalsIgnoreCase(itemNode.getName())) {
            item = new CWorkButton(action);
            ((CWorkButton)item).setToolTipText(text);
            ((CWorkButton)item).setInsertIndex(idx);
        } else if ("Menu".equalsIgnoreCase(itemNode.getName())) {
            item = this.createMenu(itemNode, mapAction, content);
        }
        return item;
    }

    private int getInt(String str) {
        if (!StringUtil.isEmptyString((String)str)) {
            return Integer.parseInt(str);
        }
        return 0;
    }

    private char getMnemonicChar(String mnStr) {
        if (mnStr != null) {
            return mnStr.length() > 0 ? mnStr.charAt(0) : (char)' ';
        }
        return ' ';
    }

    private Object createClassByName(String className) {
        if (StringUtil.isEmptyString((String)className)) {
            return null;
        }
        try {
            return Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)"err", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"err", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"err", (Throwable)e);
        }
        return null;
    }

    private ImageIcon getIcon(String name) {
        if (StringUtil.isEmptyString((String)name)) {
            return null;
        }
        return ResourceManager.getIcon(this.iconPackage, name);
    }

    public ConsolePane getConsole() {
        return this.console;
    }

    public void setActionBuildExtEvent(IActionBuildExtEvent ext) {
        this.actionBuildExtEvent = ext;
    }
}

