/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.console.content;

import com.kingdee.cosmic.ctrl.common.ui.console.content.AbstractConsoleContent;
import com.kingdee.cosmic.ctrl.common.ui.console.content.IBranchContent;
import com.kingdee.cosmic.ctrl.common.ui.console.event.BranchEvent;
import com.kingdee.cosmic.ctrl.common.ui.console.event.BranchListener;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeCellRenderer;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class DefaultBranchContent
extends AbstractConsoleContent
implements IBranchContent {
    private DefaultKingdeeTreeNode branchNode;
    private KDList list;
    private KDScrollPane scrollPane;
    private DefaultKingdeeTreeCellRenderer treeCellRengerer;
    private EventListenerList listenerList = new EventListenerList();

    public DefaultBranchContent() {
        this.initComponent();
    }

    private void initComponent() {
        this.list = new KDList();
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int idx;
                if (e.getClickCount() >= 2 && (idx = DefaultBranchContent.this.list.locationToIndex(e.getPoint())) >= 0) {
                    DefaultBranchContent.this.fireBranchEvent((DefaultKingdeeTreeNode)DefaultBranchContent.this.branchNode.getChildAt(idx));
                }
            }
        });
    }

    @Override
    public void setBranchNode(DefaultKingdeeTreeNode branchNode) {
        this.branchNode = branchNode;
    }

    @Override
    public void installCtrl(JPanel panel) {
        this.prepareList();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.getScrollPane(), "Center");
    }

    @Override
    public void addBranchListener(BranchListener l) {
        this.listenerList.add(BranchListener.class, l);
    }

    @Override
    public void removeBranchListener(BranchListener l) {
        this.listenerList.remove(BranchListener.class, l);
    }

    protected void fireBranchEvent(DefaultKingdeeTreeNode doubleClickedNode) {
        Object[] listeners = this.listenerList.getListenerList();
        BranchEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != BranchListener.class) continue;
            if (null == event) {
                event = new BranchEvent(this, doubleClickedNode);
            }
            ((BranchListener)listeners[i + 1]).doubleClickedItem(event);
        }
    }

    private KDScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new KDScrollPane((Component)this.list);
        }
        return this.scrollPane;
    }

    private void prepareList() {
        this.list.removeAllElements();
        for (int i = 0; i < this.branchNode.getChildCount(); ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.branchNode.getChildAt(i);
            this.list.addElement((Object)childNode.getText());
            this.list.setElementIcon(this.getNodeIcon(childNode), i);
        }
    }

    private Icon getNodeIcon(DefaultKingdeeTreeNode node) {
        if (node.getCustomIcon() != null) {
            return node.getCustomIcon();
        }
        if (node.getAllowsChildren()) {
            return this.getTreeCellRengerer().getDefaultClosedIcon();
        }
        return this.getTreeCellRengerer().getDefaultLeafIcon();
    }

    private DefaultKingdeeTreeCellRenderer getTreeCellRengerer() {
        if (this.treeCellRengerer == null) {
            this.treeCellRengerer = new DefaultKingdeeTreeCellRenderer();
        }
        return this.treeCellRengerer;
    }
}

