/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.editor;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import java.awt.Color;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.apache.log4j.Logger;

public class EditorRowHeader
extends JEditorPane {
    private static final Logger logger = LogUtil.getPackageLogger(EditorRowHeader.class);
    private int row = 0;

    public EditorRowHeader() {
        this.setEditable(false);
        this.setAutoscrolls(false);
        this.setFocusable(false);
        this.setForeground(Color.GRAY);
        this.showMaxRowNumber(1);
    }

    public void showMaxRowNumber(int maxrow) {
        char[] chs = String.valueOf(maxrow).toCharArray();
        float f = maxrow < 10 ? 2.2f : (maxrow < 100 ? 1.5f : (maxrow < 1000 ? 1.4f : 1.3f));
        int w = (int)((float)this.getFontMetrics(this.getFont()).charsWidth(chs, 0, chs.length) * f);
        this.setSize(w, 100);
        if (maxrow < this.row) {
            Document doc = this.getDocument();
            int len = this.getRowStringLength(maxrow + 1, this.row);
            try {
                doc.remove(doc.getLength() - len, len);
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        } else {
            try {
                StringBuffer s = new StringBuffer((maxrow - this.row) * (String.valueOf(maxrow).length() + 1));
                for (int i = this.row + 1; i <= maxrow; ++i) {
                    s.append(i).append('\n');
                }
                Document doc = this.getDocument();
                doc.insertString(doc.getLength(), s.toString(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.row = maxrow;
    }

    private int getRowStringLength(int from, int to) {
        int len1 = String.valueOf(from).length();
        int len2 = String.valueOf(to).length();
        int c = 0;
        if (len1 == len2) {
            c = (to - from + 1) * (len1 + 1);
        } else {
            int step1 = from;
            while (true) {
                int step2 = (int)Math.pow(10.0, len1);
                c += (step2 - step1) * (len1 + 1);
                if (++len1 == len2) {
                    c += (to - step2 + 1) * (len1 + 1);
                    break;
                }
                step1 = step2;
            }
        }
        return c;
    }

    public void showMaxRowNumber(String s) {
        int r = 1;
        char[] chs = s.toCharArray();
        int n = chs.length;
        for (int i = 0; i < n; ++i) {
            if (chs[i] != '\n') continue;
            ++r;
        }
        this.showMaxRowNumber(r);
    }
}

