/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.formulawizard;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.ui.formulawizard.Formula;
import com.kingdee.cosmic.ctrl.common.ui.formulawizard.FormulaWizard;
import com.kingdee.cosmic.ctrl.common.ui.formulawizard.Group;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class FormulaWizardFactory {
    private static final Logger log = LogUtil.getPackageLogger(FormulaWizardFactory.class);
    private static boolean flag = true;
    private IXmlParseListener _xmlParseListener;

    private FormulaWizardFactory() {
    }

    public FormulaWizardFactory(IXmlParseListener l) {
        this._xmlParseListener = l;
    }

    public static FormulaWizard createDefaultWizard() {
        return FormulaWizardFactory.createWizard("/com/kingdee/cosmic/ctrl/common/ui/formulawizard/DefaultFormulaWizard.xml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FormulaWizard createWizard(String clientCfg) {
        try (InputStream is = FormulaWizard.class.getResourceAsStream(clientCfg);){
            FormulaWizard formulaWizard = FormulaWizardFactory.createWizard(is);
            return formulaWizard;
        }
        catch (Exception ex) {
            log.error((Object)"Load wizard config failed!", (Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FormulaWizard createWizard(String clientCfg, boolean f) {
        flag = f;
        try (InputStream inputStream = FormulaWizardFactory.class.getResourceAsStream(clientCfg);){
            FormulaWizard formulaWizard = FormulaWizardFactory.createWizard(inputStream);
            return formulaWizard;
        }
        catch (Exception ex) {
            log.error((Object)"Load wizard config failed!", (Throwable)ex);
            return null;
        }
    }

    public static FormulaWizard createWizard(InputStream cfg) {
        try {
            return FormulaWizardFactory.createWizard(XmlUtil.loadXmlStream((InputStream)cfg));
        }
        catch (Exception ex) {
            log.error((Object)"Load wizard config failed!", (Throwable)ex);
            return null;
        }
    }

    public static FormulaWizard createWizard(IXmlElement xmlCfg) {
        FormulaWizard wizard = !flag ? new FormulaWizard(false) : new FormulaWizard();
        FormulaWizardFactory factory = new FormulaWizardFactory();
        Group[] groups = factory.createGroups(xmlCfg);
        for (int i = 0; i < groups.length; ++i) {
            wizard.addSupplyGroup(groups[i]);
        }
        wizard.validateChildren();
        String title = xmlCfg.getAttribute("text");
        if (title != null) {
            wizard.setTitle(title);
        }
        return wizard;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Group[] createGroups(String clientCfg) {
        try (InputStream inputStream = FormulaWizard.class.getResourceAsStream(clientCfg);){
            Group[] groupArray = FormulaWizardFactory.createGroups(inputStream);
            return groupArray;
        }
        catch (Exception ex) {
            log.error((Object)"Load wizard config failed!", (Throwable)ex);
            return null;
        }
    }

    public static Group[] createGroups(InputStream cfg) {
        FormulaWizardFactory factory = new FormulaWizardFactory();
        return factory.createGroupsByStream(cfg);
    }

    public Group[] createGroupsByStream(InputStream cfg) {
        try {
            return this.createGroups(XmlUtil.loadXmlStream((InputStream)cfg));
        }
        catch (Exception ex) {
            log.error((Object)"Load wizard config failed!", (Throwable)ex);
            return null;
        }
    }

    private Group[] createGroups(IXmlElement root) {
        return this.parseGroupNodes(root.searchChildren("Group"));
    }

    private Group[] parseGroupNodes(List groupsList) {
        Group[] groups = new Group[groupsList.size()];
        for (int i = 0; i < groupsList.size(); ++i) {
            IXmlElement nodeGroup = (IXmlElement)groupsList.get(i);
            groups[i] = new Group();
            groups[i].setTitle(nodeGroup.getAttribute("text"));
            if (this._xmlParseListener != null) {
                this._xmlParseListener.parseGroup(nodeGroup, groups[i]);
            }
            Iterator itNodes = nodeGroup.getChildren().iterator();
            while (itNodes.hasNext()) {
                this.parseNode(groups[i], (IXmlElement)itNodes.next(), null);
            }
        }
        return groups;
    }

    private void parseNode(Group group, IXmlElement node, DefaultKingdeeTreeNode parentTreeNode) {
        if (node.getName().equals("Node")) {
            IXmlElement nodeData = node.getChild("data");
            String data = nodeData == null ? node.getAttribute("data") : nodeData.getText().trim();
            Formula formula = new Formula(data);
            formula.setTip(node.getAttribute("tip"));
            formula.setExample(FormulaWizardFactory.getExample(node));
            formula.setMethodWithParam("true".equals(node.getAttribute("withParam")));
            DefaultKingdeeTreeNode treeNode = group.addNode(parentTreeNode, node.getAttribute("text"), formula);
            if (this._xmlParseListener != null) {
                this._xmlParseListener.parseNode(node, treeNode);
            }
        } else if (node.getName().equals("Nodes")) {
            DefaultKingdeeTreeNode newTreeNode = group.addNode(parentTreeNode, node.getAttribute("text"), null);
            if (this._xmlParseListener != null) {
                this._xmlParseListener.parseNodes(node, newTreeNode);
            }
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                this.parseNode(group, (IXmlElement)it.next(), newTreeNode);
            }
        }
    }

    private static String getExample(IXmlElement node) {
        IXmlElement nodeExam = node.getChild("example");
        String example = nodeExam != null ? nodeExam.getText().trim() : "";
        return example;
    }

    public static interface IXmlParseListener {
        public void parseGroup(IXmlElement var1, Group var2);

        public void parseNodes(IXmlElement var1, DefaultKingdeeTreeNode var2);

        public void parseNode(IXmlElement var1, DefaultKingdeeTreeNode var2);
    }
}

