/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.mdi;

import com.kingdee.cosmic.ctrl.common.ui.mdi.MdiDesktopPane;
import com.kingdee.cosmic.ctrl.common.ui.mdi.MdiMenuBar;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.KDInternalFrame;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.apache.log4j.Logger;

public class MdiFrame
extends KDInternalFrame {
    private static final Logger logger = LogUtil.getPackageLogger(MdiFrame.class);
    private static final long serialVersionUID = -784198025799441335L;
    private MdiMenuBar _menuBar = null;
    private Border _borderNormal = null;
    private boolean _isBorderNone = false;
    private Dimension _normalSize;

    public MdiFrame() {
        this.initComponents();
        this.installListener();
    }

    private void initComponents() {
        this._borderNormal = this.getBorder();
        this._normalSize = this.getPreferredSize();
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setPreferredSize(new Dimension(400, 300));
        this.pack();
    }

    private void installListener() {
        this.addInternalFrameListener(new InternalFrameListener(){
            private MdiDesktopPane desktopPane;

            @Override
            public void internalFrameOpened(InternalFrameEvent evt) {
                this.desktopPane = (MdiDesktopPane)MdiFrame.this.getDesktopPane();
                this.desktopPane.fireInternalFrameListener(evt, 25549);
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent evt) {
                this.desktopPane.fireInternalFrameListener(evt, 25550);
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                this.desktopPane.fireInternalFrameListener(evt, 25551);
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent evt) {
                this.desktopPane.fireInternalFrameListener(evt, 25554);
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent evt) {
                this.desktopPane.fireInternalFrameListener(evt, 25555);
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent evt) {
                this.desktopPane.fireInternalFrameListener(evt, 25552);
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent evt) {
                this.desktopPane.fireInternalFrameListener(evt, 25553);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MdiFrame.this.doPropertyChange(evt);
            }
        });
    }

    private void doPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("maximum")) {
            try {
                this.onMaximizeMinimize();
            }
            catch (PropertyVetoException e) {
                logger.error((Object)"err", (Throwable)e);
            }
        } else if (evt.getPropertyName().equals("selected")) {
            this.onSelect();
        }
    }

    private void onMaximizeMinimize() throws PropertyVetoException {
        if (this.isMaximum() && !this._isBorderNone) {
            JInternalFrame[] jfs = this.getDesktopPane().getAllFrames();
            for (int i = 0; i < jfs.length; ++i) {
                if (jfs[i] == this) continue;
                jfs[i].setMaximum(true);
            }
            this.setSelected(true);
            this.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
            this._isBorderNone = true;
            ((BasicInternalFrameUI)this.getUI()).getNorthPane().setPreferredSize(new Dimension(0, 0));
            if (this._menuBar != null) {
                this._menuBar.setMaximizedFrame(this);
            }
        } else if (!this.isMaximum() && this._isBorderNone) {
            this._normalSize = this.getSize();
            JInternalFrame[] jfs = this.getDesktopPane().getAllFrames();
            for (int i = 0; i < jfs.length; ++i) {
                if (jfs[i] == this) continue;
                jfs[i].setMaximum(false);
            }
            ((BasicInternalFrameUI)this.getUI()).getNorthPane().setPreferredSize(new Dimension(this._normalSize.width, 23));
            this.setPreferredSize(this._normalSize);
            this.setSize(this._normalSize);
            this.setBorder(this._borderNormal);
            this._isBorderNone = false;
            if (this._menuBar != null) {
                this._menuBar.setMaximizedFrame(null);
            }
            this.setSelected(true);
        }
    }

    private void onSelect() {
        if (this.isMaximum() && this._menuBar != null) {
            this._menuBar.setMaximizedFrame(this);
        }
    }

    public void setMenu(MdiMenuBar menuBar) {
        this._menuBar = menuBar;
    }
}

