/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.mdi;

import com.kingdee.cosmic.ctrl.common.ui.mdi.MdiFrame;
import com.kingdee.cosmic.ctrl.common.ui.resource.ResourceManager;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.KDMenuBar;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import org.apache.log4j.Logger;

public class MdiMenuBar
extends KDMenuBar {
    private static final Logger logger = LogUtil.getPackageLogger(MdiMenuBar.class);
    private static final long serialVersionUID = -3734765204449694729L;
    private static final ImageIcon ICN_WINDOWMIN1 = ResourceManager.getIcon("dialog/label_minimize_1.gif");
    private static final ImageIcon ICN_WINDOWMIN2 = ResourceManager.getIcon("dialog/label_minimize_2.gif");
    private static final ImageIcon ICN_WINDOWRESIZE1 = ResourceManager.getIcon("dialog/label_instead_1.gif");
    private static final ImageIcon ICN_WINDOWRESIZE2 = ResourceManager.getIcon("dialog/label_instead_2.gif");
    private static final ImageIcon ICN_WINDOWCLOSE1 = ResourceManager.getIcon("dialog/label_close_1.gif");
    private static final ImageIcon ICN_WINDOWCLOSE2 = ResourceManager.getIcon("dialog/label_close_2.gif");
    private JButton btnClose = null;
    private JButton btnResize = null;
    private JButton btnMin = null;
    private MdiFrame activeFrame = null;
    private boolean isMaximized = false;
    private ComponentListener componentHandler = new ComponentHandler();

    public MdiMenuBar() {
        ActionHandler actionHandler = new ActionHandler();
        this.btnClose = new JButton(ICN_WINDOWCLOSE1);
        this.btnClose.setPressedIcon(ICN_WINDOWCLOSE2);
        this.btnClose.setBorderPainted(false);
        this.btnClose.addActionListener(actionHandler);
        this.btnResize = new JButton(ICN_WINDOWRESIZE1);
        this.btnResize.setPressedIcon(ICN_WINDOWRESIZE2);
        this.btnResize.setBorderPainted(false);
        this.btnResize.addActionListener(actionHandler);
        this.btnMin = new JButton(ICN_WINDOWMIN1);
        this.btnMin.setPressedIcon(ICN_WINDOWMIN2);
        this.btnMin.setBorderPainted(false);
        this.btnMin.addActionListener(actionHandler);
        this.addComponentListener(this.componentHandler);
    }

    public void setLogo(Icon icon) {
    }

    public void removeFrameButtons() {
        this.isMaximized = false;
        this.activeFrame = null;
        this.remove(this.btnClose);
        this.remove(this.btnResize);
        this.remove(this.btnMin);
        this.validate();
        this.repaint();
    }

    public void setMaximizedFrame(MdiFrame jf) {
        if (jf == null) {
            this.removeFrameButtons();
        } else {
            if (!this.isMaximized) {
                this.addRightComponent(this.btnMin, 1);
                this.addRightComponent(this.btnResize, 1);
                this.addRightComponent(this.btnClose, 1);
                this.validate();
                this.repaint();
            }
            this.activeFrame = jf;
            this.isMaximized = true;
        }
    }

    public void paint(Graphics g) {
        this.componentHandler.componentResized(null);
        super.paint(g);
    }

    protected void todoResized(MdiFrame mdiFrame) {
    }

    protected void todoMinimized(MdiFrame mdiFrame) {
    }

    protected boolean todoClosing(MdiFrame mdiFrame) {
        return true;
    }

    protected void todoClosed(MdiFrame mdiFrame) {
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MdiMenuBar.this.activeFrame == null) {
                return;
            }
            if (e.getSource() == MdiMenuBar.this.btnResize) {
                try {
                    MdiMenuBar.this.activeFrame.setMaximum(false);
                }
                catch (PropertyVetoException e1) {
                    logger.error((Object)"err", (Throwable)e1);
                }
                MdiMenuBar.this.todoResized(MdiMenuBar.this.activeFrame);
            } else if (e.getSource() == MdiMenuBar.this.btnMin) {
                try {
                    MdiMenuBar.this.activeFrame.setIcon(true);
                }
                catch (PropertyVetoException e1) {
                    logger.error((Object)"err", (Throwable)e1);
                }
                MdiMenuBar.this.todoMinimized(MdiMenuBar.this.activeFrame);
            } else if (e.getSource() == MdiMenuBar.this.btnClose && MdiMenuBar.this.todoClosing(MdiMenuBar.this.activeFrame)) {
                JDesktopPane desktopPane = MdiMenuBar.this.activeFrame.getDesktopPane();
                int frames = desktopPane.getAllFrames().length;
                MdiMenuBar.this.activeFrame.doDefaultCloseAction();
                if (MdiMenuBar.this.activeFrame.isClosed()) {
                    desktopPane.remove((Component)((Object)MdiMenuBar.this.activeFrame));
                    if (frames <= 1) {
                        MdiMenuBar.this.removeFrameButtons();
                    }
                }
                MdiMenuBar.this.todoClosed(MdiMenuBar.this.activeFrame);
            }
        }
    }

    private class ComponentHandler
    implements ComponentListener {
        private ComponentHandler() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            int iconW = MdiMenuBar.this.btnClose.getIcon().getIconWidth();
            int iconH = MdiMenuBar.this.btnClose.getIcon().getIconHeight();
            if (MdiMenuBar.this.getParent() != null) {
                int parentW = MdiMenuBar.this.getParent().getWidth();
                MdiMenuBar.this.btnClose.setBounds(parentW - iconW - 2, (MdiMenuBar.this.getHeight() - iconH) / 2, iconW, iconH);
                MdiMenuBar.this.btnResize.setBounds(parentW - iconW * 2 - 4, (MdiMenuBar.this.getHeight() - iconH) / 2, iconW, iconH);
                MdiMenuBar.this.btnMin.setBounds(parentW - iconW * 3 - 5, (MdiMenuBar.this.getHeight() - iconH) / 2, iconW, iconH);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }
}

