/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.common.ui.tree;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.ui.SimpleDialog;
import com.kingdee.cosmic.ctrl.common.ui.TreeView;
import com.kingdee.cosmic.ctrl.common.ui.WindowUtil;
import com.kingdee.cosmic.ctrl.common.ui.tree.ATreeController;
import com.kingdee.cosmic.ctrl.common.ui.tree.IAfterNodeInitialized;
import com.kingdee.cosmic.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.cosmic.ctrl.common.ui.tree.TreeUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.PathUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.res.Resource;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.event.TreePopupMenuEvent;
import com.kingdee.cosmic.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class TreeUI
extends KDPanel {
    private static final long serialVersionUID = 8958381903716013817L;
    private static final Logger log = LogUtil.getPackageLogger(TreeUI.class);
    private KDTree tree;
    private TreeView treeview;
    private KDWorkButton wbFilter;
    private EventLisnter treeEventListner = new EventLisnter();
    private ActionListener filterAction;
    private boolean checkboxMode = false;
    private boolean realtimeSelect = false;
    private String visibleTextPattern;
    private IAfterNodeInitialized nodeInitializedListener;

    public TreeUI() {
        this(false);
    }

    public TreeUI(boolean hasFilter) {
        this.setTree(new KDTree(), hasFilter);
    }

    public final String getVisibleTextPattern() {
        return this.visibleTextPattern;
    }

    public final void setVisibleTextPattern(String textPattern) {
        this.visibleTextPattern = textPattern;
    }

    public void setRootNode(TreeUINode node) {
        ((KingdeeTreeModel)this.tree.getModel()).setRoot((TreeNode)((Object)node));
        this.tree.collapsePath(new TreePath((Object)node));
    }

    public void setRealtimeSelect(boolean isVal) {
        this.realtimeSelect = isVal;
    }

    public boolean isRealtimeSelect() {
        return this.realtimeSelect;
    }

    public void setCheckboxMode(boolean isVal) {
        this.checkboxMode = isVal;
        KDTree tree = this.getTree();
        tree.setShowCheckBox(this.checkboxMode);
        tree.setSyncChecked(this.checkboxMode);
    }

    public boolean isCheckboxMode() {
        return this.checkboxMode;
    }

    public void setRootVisible(boolean isVisible) {
        if (!isVisible) {
            this.tree.expandRow(0);
            this.tree.setShowsRootHandles(true);
        }
        this.tree.setRootVisible(isVisible);
    }

    public KDTree getTree() {
        return this.tree;
    }

    public void applyVisibleTextPattern(String pattern) {
        this.visibleTextPattern = StringUtil.isEmptyString((String)pattern) ? null : pattern;
        KingdeeTreeModel tm = (KingdeeTreeModel)this.tree.getModel();
        TreeUINode root = (TreeUINode)((Object)tm.getRoot());
        TreeUtil.applyTextPattern(tm, root, this.visibleTextPattern);
    }

    public void setCustomFilterActionListener(ActionListener l) {
        if (this.wbFilter == null || this.filterAction == null) {
            throw new IllegalStateException();
        }
        this.wbFilter.removeActionListener(this.filterAction);
        this.filterAction = l;
        this.wbFilter.addActionListener(this.filterAction);
    }

    private void setTree(KDTree tree, boolean hasFilter) {
        if (hasFilter) {
            this.wbFilter = new KDWorkButton((Icon)Resource.ICON_FILTER);
            this.wbFilter.setToolTipText(CtrlCommonUIMessages.getMLS("filter", "\u8fc7\u6ee4"));
            this.filterAction = new FilterActionListener();
            this.wbFilter.addActionListener(this.filterAction);
        }
        this.tree = tree;
        this.treeview = new TreeView(tree);
        if (hasFilter) {
            this.treeview.getControlPane().add((Component)this.wbFilter);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.treeview), "Center");
        KingdeeTreeModel ktm = (KingdeeTreeModel)this.tree.getModel();
        ktm.setAsksAllowsChildren(true);
        this.tree.addTreeExpansionListener((TreeExpansionListener)this.treeEventListner);
        this.tree.addTreeSelectionListener((TreeSelectionListener)this.treeEventListner);
        this.tree.addTreePopupMenu((TreePopupMenuListener)this.treeEventListner);
        this.tree.addMouseListener((MouseListener)this.treeEventListner);
    }

    private static final TreeUINode getNode(TreePath tp) {
        if (tp == null) {
            return null;
        }
        return (TreeUINode)((Object)tp.getLastPathComponent());
    }

    public void setSelectionPathText(String pathText) {
        TreePath tp = this.makeTreePath(this.getRootNode(), pathText);
        if (tp != null) {
            this.tree.setSelectionPath(tp);
            this.tree.scrollPathToVisible(tp);
        }
    }

    public void setCheckedPathText(String pathText, boolean isChecked) {
        TreePath tp = this.makeTreePath(this.getRootNode(), pathText);
        if (tp != null) {
            TreeUINode node = (TreeUINode)((Object)tp.getLastPathComponent());
            node.setChecked(true);
            node.syncChecked();
        }
    }

    final TreePath makeTreePath(TreeUINode tcn, String pathText) {
        String[] names = PathUtil.splitPath((String)pathText);
        int z = names.length;
        TreeUINode[] tcns = new TreeUINode[z == 0 ? 1 : z];
        tcns[0] = tcn;
        for (int i = 1; i < z; ++i) {
            if (this.realtimeSelect) {
                this.fireHookInitNode(new TreePath(tcns[i - 1].getPath()));
            }
            tcns[i] = tcns[i - 1].getChildNode(names[i]);
            if (tcns[i] != null) continue;
            return null;
        }
        return new TreePath((Object[])tcns);
    }

    public void setSelectionPathTexts(String[] pathTexts) {
        TreePath[] tps = new TreePath[pathTexts.length];
        for (int i = 0; i < pathTexts.length; ++i) {
            tps[i] = TreeUtil.makeTreePath(this.getRootNode(), pathTexts[i]);
            this.tree.setSelectionPaths(tps);
        }
    }

    public String getSelectionPathText() {
        return TreeUtil.makePathText(this.tree.getSelectionPath());
    }

    public TreeUINode getSelectionNode() {
        return TreeUI.getNode(this.getTree().getSelectionPath());
    }

    public void setSelectionNode(TreeUINode node) {
        this.tree.setSelectionNode((DefaultKingdeeTreeNode)node);
    }

    public TreePath getSelectionPath() {
        return this.getTree().getSelectionPath();
    }

    public void setSelectionPath(TreePath path) {
        this.tree.setSelectionPath(path);
    }

    public TreeUINode getRootNode() {
        return (TreeUINode)((Object)this.tree.getModel().getRoot());
    }

    public static ATreeController findHook(TreeUINode node) {
        while (null != node) {
            ATreeController rv = node.getHook();
            if (null != rv) {
                return rv;
            }
            node = (TreeUINode)((Object)node.getParent());
        }
        return null;
    }

    public void refreshSelectionNode() {
        TreeUINode node = this.getSelectionNode();
        this.refreshNode(node);
    }

    private void afterInitNode(TreeUINode node) {
        if (this.visibleTextPattern != null) {
            TreeUtil.applyTextPattern((KingdeeTreeModel)this.tree.getModel(), node, this.visibleTextPattern);
        }
        if (this.nodeInitializedListener != null) {
            this.nodeInitializedListener.afterInitNode(node);
        }
    }

    private void initNode(TreeUINode node) {
        ATreeController hook = TreeUI.findHook(node);
        if (hook != null) {
            TreePath tp = new TreePath(node.getPath());
            try {
                if (hook.initNode(tp)) {
                    this.afterInitNode(node);
                    ATreeController newHook = node.getHook();
                    if (newHook != null && newHook != hook) {
                        newHook.initNode(tp);
                        this.afterInitNode(node);
                    }
                }
            }
            catch (Exception ex) {
                log.error((Object)("\u65e0\u6cd5\u5c55\u5f00\u8282\u70b9\uff1a" + (Object)((Object)node)), (Throwable)ex);
                WindowUtil.showException(ex.getMessage(), ex, CtrlCommonUIMessages.getMLS("cantOpernNode", "\u65e0\u6cd5\u5c55\u5f00\u8282\u70b9"), (Component)((Object)this));
            }
        }
        node.setChildrenLoaded(true);
    }

    public void refreshNode(TreeUINode targetNode) {
        TreeUINode node = targetNode.getAllowsChildren() ? targetNode : (TreeUINode)((Object)targetNode.getParent());
        if (node != null && node.isChildrenLoaded()) {
            this.getTree().removeAllChildrenFromParent((MutableTreeNode)((Object)node));
            node.setChildrenLoaded(false);
            this.initNode(node);
        }
    }

    public void addChildNode(TreeUINode child, TreeUINode parent) {
        if (this.isCheckboxMode() && parent.isChecked()) {
            child.setChecked(true);
        }
        ((DefaultTreeModel)this.tree.getModel()).insertNodeInto((MutableTreeNode)((Object)child), (MutableTreeNode)((Object)parent), parent.getChildCount());
    }

    public void removeNode(TreeUINode node) {
        this.tree.removeNodeFromParent((MutableTreeNode)((Object)node));
    }

    public void removeAllChildrenNodes(TreeUINode parentNode) {
        this.tree.removeAllChildrenFromParent((MutableTreeNode)((Object)parentNode));
    }

    private void fireHookInitNode(TreePath tp) {
        TreeUINode node = TreeUI.getNode(tp);
        if (node == null) {
            return;
        }
        if (node.isChildrenLoaded()) {
            return;
        }
        this.initNode(node);
    }

    public void setTitle(String title) {
        this.treeview.setTitle(title);
    }

    public String getTitle() {
        return this.treeview.getTitle();
    }

    public void nodeChanged(TreeUINode node) {
        ((DefaultTreeModel)this.tree.getModel()).nodeChanged((TreeNode)((Object)node));
    }

    public void expand(TreePath path) {
        this.tree.expandPath(path);
    }

    public void expandRoot() {
        this.tree.expandPath(new TreePath(this.tree.getModel().getRoot()));
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.listenerList.add(TreeSelectionListener.class, l);
    }

    public void removeTreeSelectionListener(TreeSelectionListener l) {
        this.listenerList.remove(TreeSelectionListener.class, l);
    }

    protected void fireTreeSelectionListener(TreeSelectionEvent evt) {
        Object[] list = this.listenerList.getListenerList();
        for (int i = list.length - 2; i >= 0; --i) {
            if (list[i] != TreeSelectionListener.class) continue;
            ((TreeSelectionListener)list[i + 1]).valueChanged(evt);
        }
    }

    public final IAfterNodeInitialized getNodeInitializedListener() {
        return this.nodeInitializedListener;
    }

    public final void setNodeInitializedListener(IAfterNodeInitialized nodeInitializedListener) {
        this.nodeInitializedListener = nodeInitializedListener;
    }

    public void disableUndoRedoButtons() {
        this.treeview.disableUndoRedoButtons();
    }

    public class EventLisnter
    extends MouseAdapter
    implements TreeExpansionListener,
    TreeSelectionListener,
    TreePopupMenuListener {
        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            if (log.isDebugEnabled()) {
                log.debug((Object)event);
            }
            TreePath tp = event.getPath();
            TreeUI.this.fireHookInitNode(tp);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ATreeController hook;
            TreePath tp;
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            if ((tp = e.getNewLeadSelectionPath()) == null) {
                return;
            }
            if (TreeUI.this.realtimeSelect && TreeUI.getNode(tp).getAllowsChildren()) {
                TreeUI.this.fireHookInitNode(tp);
            }
            if ((hook = TreeUI.findHook((TreeUINode)((Object)tp.getLastPathComponent()))) != null && hook.onSelectNode(tp, e.getOldLeadSelectionPath())) {
                TreeUI.this.fireTreeSelectionListener(e);
            }
        }

        public boolean popMenu(TreePopupMenuEvent event) {
            TreePath[] paths = event.getSelectionPaths();
            if (paths == null) {
                return false;
            }
            ATreeController hook = null;
            for (int i = 0; i < paths.length; ++i) {
                ATreeController tempHook = TreeUI.findHook(TreeUI.getNode(paths[i]));
                if (hook == null) {
                    hook = tempHook;
                    continue;
                }
                if (hook == tempHook) continue;
                return false;
            }
            if (hook != null) {
                JPopupMenu popupMenu = TreeUI.this.tree.getPopupMenu();
                popupMenu.removeAll();
                while (hook != null) {
                    hook.onPopMenu(paths, popupMenu);
                    hook = hook.getNext();
                }
                return popupMenu.getComponentCount() > 0;
            }
            return false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                TreePath treePath = TreeUI.this.tree.getClosestPath(e.getX(), e.getY());
                if (treePath == null) {
                    return;
                }
                ATreeController hook = TreeUI.findHook((TreeUINode)((Object)treePath.getLastPathComponent()));
                if (hook != null) {
                    hook.onDoubleClick(e, treePath);
                }
            }
        }
    }

    private class FilterActionListener
    implements ActionListener {
        private SimpleDialog dlg;
        private KDComboBox cbxPatterns;

        private FilterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dlg == null) {
                this.dlg = (SimpleDialog)((Object)WindowUtil.createWindow(SimpleDialog.class, (Component)((Object)TreeUI.this.treeview)));
                this.cbxPatterns = new KDComboBox();
                this.cbxPatterns.setEditable(true);
                this.dlg.setComponent((Component)this.cbxPatterns);
                this.dlg.setTitle(CtrlCommonUIMessages.getMLS("filter", "\u8fc7\u6ee4"));
                this.dlg.setSize(280, 110);
            }
            JTextComponent txtEditor = (JTextComponent)this.cbxPatterns.getEditor().getEditorComponent();
            txtEditor.selectAll();
            if (this.dlg.showDialog()) {
                String pattern = txtEditor.getText();
                this.cbxPatterns.insertItemAt((Object)pattern, 0);
                if (this.cbxPatterns.getItemCount() > 5) {
                    this.cbxPatterns.removeItemAt(5);
                }
                TreeUI.this.applyVisibleTextPattern(pattern);
            }
        }
    }
}

