/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.ImageRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CellImageRender
extends Component
implements IBasicRender {
    private static final Logger logger = LogUtil.getPackageLogger(CellImageRender.class);
    private static final long serialVersionUID = -6867230885394553415L;
    public static final short MODE_HOLD_SINGLE = 0;
    public static final short MODE_FIT = 1;
    public static final short MODE_HOLD_MULTI = 2;
    public static final short MODE_FIT_FIX = 3;
    protected ImageRender render = new ImageRender();
    protected short mode = 0;

    public CellImageRender() {
    }

    public CellImageRender(Graphics2D g2d) {
        this.setGraphics2D(g2d);
    }

    public CellImageRender(Graphics2D g2d, short mode) {
        this(g2d);
        this.mode = mode;
    }

    public Graphics2D getGraphics2D() {
        return this.render.getGraphics2D();
    }

    public void setGraphics2D(Graphics2D g2d) {
        this.render.setGraphics2D(g2d);
    }

    @Override
    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        if (object == null) {
            return;
        }
        Rectangle rect = clip.getBounds();
        Image image = (Image)object;
        this.setGraphics2D((Graphics2D)graphics);
        image = this.scaleImage(image, rect, cellStyle);
        Rectangle saveClip = this.getGraphics2D().getClipBounds();
        if (clip instanceof Rectangle && saveClip != null) {
            Rectangle theClip = (Rectangle)clip;
            Rectangle resultClip = SwingUtilities.computeIntersection(saveClip.x, saveClip.y, saveClip.width, saveClip.height, theClip);
            this.getGraphics2D().setClip(resultClip);
        } else {
            this.getGraphics2D().setClip(clip);
        }
        this.drawCommon(image, rect, cellStyle);
        this.getGraphics2D().setClip(saveClip);
    }

    private Image scaleImage(Image image, Rectangle cellRect, Style cellStyle) {
        if (this.mode == 1 || cellStyle.isShrinkText()) {
            image = image.getScaledInstance((int)cellRect.getWidth(), (int)cellRect.getHeight(), 1);
            this.waitForImage(this, image);
        }
        if (this.mode == 3) {
            int imageHeight;
            double yRate;
            double rate;
            int imageWidth = image.getWidth(this.getImgObserver());
            double xRate = (double)imageWidth / (double)cellRect.width;
            double d = rate = xRate > (yRate = (double)(imageHeight = image.getHeight(this.getImgObserver())) / (double)cellRect.height) ? xRate : yRate;
            if (ArrayUtil.isEqual((Double)rate, (Double)xRate)) {
                imageWidth = cellRect.width;
                imageHeight = (int)((double)imageHeight / rate);
            } else {
                imageWidth = (int)((double)imageWidth / rate);
                imageHeight = cellRect.height;
            }
            image = image.getScaledInstance(imageWidth, imageHeight, 1);
            this.waitForImage(this, image);
        }
        return image;
    }

    private void waitForImage(Component comp, Image image) {
        try {
            MediaTracker tracker = new MediaTracker(comp);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException err) {
            logger.error((Object)"err", (Throwable)err);
        }
    }

    private void drawCommon(Image image, Rectangle cellRect, Style cellStyle) {
        Point pos = this.caculatePos(image, cellRect, cellStyle);
        this.render.draw(pos, image);
    }

    private Point caculatePos(Image image, Rectangle cellRect, Style cellStyle) {
        Point pos = cellRect.getLocation();
        if (image != null) {
            int imageWidth = image.getWidth(this.getImgObserver());
            int imageHeight = image.getHeight(this.getImgObserver());
            if (cellStyle.getHorizontalAlign().equals(Styles.HorizontalAlignment.CENTER)) {
                pos.x += (cellRect.width - imageWidth) / 2;
            } else if (cellStyle.getHorizontalAlign().equals(Styles.HorizontalAlignment.RIGHT)) {
                pos.x += cellRect.width - imageWidth;
            }
            if (cellStyle.getVerticalAlign().equals(Styles.VerticalAlignment.MIDDLE)) {
                pos.y += (cellRect.height - imageHeight) / 2;
            } else if (cellStyle.getVerticalAlign().equals(Styles.VerticalAlignment.BOTTOM)) {
                pos.y += cellRect.height - imageHeight;
            }
        }
        return pos;
    }

    protected Point caculateRotateCenter(Image image, Point pos) {
        Point center = new Point();
        center.x = pos.x + (image == null ? 0 : image.getWidth(this.getImgObserver()) / 2);
        center.y = pos.y + (image == null ? 0 : image.getHeight(this.getImgObserver()) / 2);
        return center;
    }

    public void setImgOvserver(ImageObserver imgOvserver) {
        this.render.setImgOvserver(imgOvserver);
    }

    public ImageObserver getImgObserver() {
        return this.render.getImgObserver();
    }

    public short getMode() {
        return this.mode;
    }

    public void setMode(short mode) {
        if (mode < 0 || mode > 3) {
            throw new IllegalArgumentException(CtrlCommonUIMessages.getMLS("invalidCellDrawingModeParam", "\u9519\u8bef\u7684\u5355\u5143\u683c\u7ed8\u56fe\u6a21\u5f0f\u53c2\u6570\uff1a") + mode);
        }
        this.mode = mode;
    }
}

