/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render;

import com.kingdee.cosmic.ctrl.kdf.util.style.Border;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;

public class CellRenderHelper {
    public static void drawCellBackground(Graphics2D g, Rectangle rect, Style style) {
        if (style == null) {
            return;
        }
        Paint paint = style.getFillPaint();
        if (paint != Styles.getNullColor()) {
            g.setPaint(paint);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        } else {
            Color clr = style.getBackground();
            if (clr.getAlpha() == 0) {
                clr = Color.WHITE;
            }
            g.setColor(clr);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public static void drawCellBorder(Graphics2D g, Rectangle rect, Style style) {
        CellRenderHelper.drawTopBorder(g, rect, style);
        CellRenderHelper.drawLeftBorder(g, rect, style);
        CellRenderHelper.drawBottomBorder(g, rect, style);
        CellRenderHelper.drawRightBorder(g, rect, style);
    }

    protected static void drawTopBorder(Graphics2D g, Rectangle rect, Style style) {
        Border border = null;
        if (style != null) {
            border = style.getBorder(Styles.Position.TOP);
        }
        if (border == null || border.isNull()) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        int left = rect.x;
        int top = rect.y;
        int right = rect.x + rect.width - 1;
        g.setColor(border.getColor());
        g.setStroke(border.getStroke());
        g.drawLine(left, top, right, top);
        g.setStroke(oldStroke);
    }

    protected static void drawLeftBorder(Graphics2D g, Rectangle rect, Style style) {
        Border border = null;
        if (style != null) {
            border = style.getBorder(Styles.Position.LEFT);
        }
        if (border == null || border.isNull()) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        int top = rect.y;
        int bottom = rect.y + rect.height - 1;
        int left = rect.x;
        g.setColor(border.getColor());
        g.setStroke(border.getStroke());
        g.drawLine(left, top, left, bottom);
        g.setStroke(oldStroke);
    }

    protected static void drawBottomBorder(Graphics2D g, Rectangle rect, Style style) {
        Border border = null;
        if (style != null) {
            border = style.getBorder(Styles.Position.BOTTOM);
        }
        if (border == null || border.isNull()) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        int weight = border.getLineStyle().getWidth();
        if (weight > 1) {
            --weight;
        }
        int left = rect.x;
        int top = rect.y + rect.height - weight;
        int right = rect.x + rect.width - 1;
        g.setColor(border.getColor());
        g.setStroke(border.getStroke());
        g.drawLine(left, top, right, top);
        g.setStroke(oldStroke);
    }

    protected static void drawRightBorder(Graphics2D g, Rectangle rect, Style style) {
        Border border = null;
        if (style != null) {
            border = style.getBorder(Styles.Position.RIGHT);
        }
        if (border == null || border.isNull()) {
            return;
        }
        Stroke oldStroke = g.getStroke();
        int weight = border.getLineStyle().getWidth();
        if (weight > 1) {
            --weight;
        }
        int top = rect.y;
        int bottom = rect.y + rect.height - 1;
        int left = rect.x + rect.width - weight;
        g.setColor(border.getColor());
        g.setStroke(border.getStroke());
        g.drawLine(left, top, left, bottom);
        g.setStroke(oldStroke);
    }
}

