/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render;

import com.kingdee.cosmic.ctrl.common.util.FontUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.view.KDPlainParagraph;
import com.kingdee.cosmic.ctrl.kdf.util.render.view.TextAreaViewUI;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.View;
import sun.font.FontDesignMetrics;

public class TextAreaRender {
    private JTextArea area = new JTextArea();
    protected boolean isBlackWhite = false;

    public TextAreaRender() {
        this.area.setUI(new TextAreaViewUI());
        this.area.setLineWrap(true);
        this.area.setWrapStyleWord(true);
    }

    private Rectangle getPaintBounds(Rectangle rect, Style style, View view) {
        Styles.VerticalAlignment va = style.getVerticalAlign();
        if (va == Styles.VerticalAlignment.TOP) {
            return rect;
        }
        float yspan = view.getPreferredSpan(1);
        if (va == Styles.VerticalAlignment.MIDDLE) {
            rect.y = (int)((float)rect.y + ((float)rect.height - yspan) / 2.0f);
        } else if (va == Styles.VerticalAlignment.BOTTOM) {
            rect.y = (int)((float)rect.y + ((float)rect.height - yspan));
        }
        if (Styles.HorizontalAlignment.LEFT.equals(style.getHorizontalAlign()) && style.getIndentation() > 0) {
            int fontStyle = 0;
            if (style.isBold()) {
                ++fontStyle;
            }
            if (style.isItalic()) {
                fontStyle += 2;
            }
            Font f = new Font(style.getFontName(), fontStyle, style.getFontSize());
            FontDesignMetrics fm = FontDesignMetrics.getMetrics(f);
            rect.x += ((FontMetrics)fm).charWidth('A') * style.getIndentation();
        }
        return rect;
    }

    private View getView(Rectangle rect, String text, Style style) {
        View view = ((BasicTextAreaUI)this.area.getUI()).getRootView(this.area);
        this.area.setFont(FontUtil.validateFont((String)text, (Font)style.getKDFont().getFont()));
        Color fontColor = style.getFontColor();
        if (!this.isBlackWhite() || fontColor.getBlue() == fontColor.getRed() && fontColor.getBlue() == fontColor.getGreen()) {
            this.area.setForeground(fontColor);
        } else {
            this.area.setForeground(Color.BLACK);
        }
        this.area.setText(text);
        Styles.HorizontalAlignment ha = style.getHorizontalAlign();
        int align = ha == Styles.HorizontalAlignment.CENTER ? 1 : (ha == Styles.HorizontalAlignment.RIGHT ? 2 : 0);
        View boxView = view.getView(0);
        int size = boxView.getViewCount();
        for (int i = 0; i < size; ++i) {
            ((KDPlainParagraph)boxView.getView(i)).setHorizontalAlign(align);
        }
        if (style.hasIndentationAttributes()) {
            int fontStyle = 0;
            if (style.isBold()) {
                ++fontStyle;
            }
            if (style.isItalic()) {
                fontStyle += 2;
            }
            Font f = new Font(style.getFontName(), fontStyle, style.getFontSize());
            FontDesignMetrics fm = FontDesignMetrics.getMetrics(f);
            rect.width -= ((FontMetrics)fm).charWidth('A') * style.getIndentation();
        }
        view.setSize(rect.width, rect.height);
        return view;
    }

    public void draw(Graphics g, Shape clip, String text, Style style) {
        Shape old = g.getClip();
        if (clip != null) {
            Rectangle cr = clip.getBounds();
            g.clipRect(cr.x, cr.y, cr.width, cr.height);
            View view = this.getView(cr, text, style);
            cr = this.getPaintBounds(cr, style, view);
            view.paint(g, cr);
        }
        g.setClip(old);
    }

    public float getPreferredHeight(Graphics g, Shape clip, String text, Style style) {
        return this.getView(clip.getBounds(), text, style).getPreferredSpan(1);
    }

    public void setBlackWhite(boolean isBlackWhite) {
        this.isBlackWhite = isBlackWhite;
    }

    public boolean isBlackWhite() {
        return this.isBlackWhite;
    }

    public static void main(String[] args) {
        final JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        final JTextArea area = new JTextArea();
        area.setUI(new TextAreaViewUI());
        area.setComponentOrientation(ComponentOrientation.UNKNOWN);
        JButton btn = new JButton("dsfasdfasf");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(area.getPreferredSize());
                frame.pack();
            }
        });
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)btn, "North");
        frame.getContentPane().add((Component)area, "Center");
        area.setText("erqewr\ndsfsafsafsdfasffdgdssds");
        frame.pack();
        frame.setVisible(true);
    }
}

