/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render.icon;

import com.kingdee.cosmic.ctrl.kdf.util.render.icon.Icon;
import java.awt.Graphics;

public class TreeIcon
implements Icon {
    private int iconSize;
    private int margin;

    public TreeIcon() {
        this(12);
    }

    public TreeIcon(int iconSize) {
        this.iconSize = iconSize;
        this.margin = 2;
    }

    @Override
    public int getWidth() {
        return this.iconSize;
    }

    @Override
    public int getHeight() {
        return this.iconSize;
    }

    @Override
    public void paint(Object value, Graphics g, int x, int y) {
        int type;
        if (value instanceof Integer && (type = ((Integer)value).intValue()) != 0) {
            if (type == 1) {
                this.drawCollapsed(g, x, y);
            } else {
                this.drawExpanded(g, x, y);
            }
        }
    }

    protected void drawLeaf(Graphics g, int x, int y) {
        g.fillRect(x, y, this.iconSize, this.iconSize);
    }

    protected void drawExpanded(Graphics g, int x, int y) {
        g.drawRect(x, y, this.iconSize, this.iconSize);
        int lineSize = this.iconSize - 2 * this.margin;
        g.drawLine(x + this.margin, y + this.iconSize / 2, x + this.margin + lineSize, y + this.iconSize / 2);
    }

    protected void drawCollapsed(Graphics g, int x, int y) {
        g.drawRect(x, y, this.iconSize, this.iconSize);
        int lineSize = this.iconSize - 2 * this.margin;
        int ly = y + this.iconSize / 2;
        int lx = x + this.iconSize / 2;
        g.drawLine(x + this.margin, ly, x + this.margin + lineSize, ly);
        g.drawLine(lx, y + this.margin, lx, y + this.margin + lineSize);
    }
}

