/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render.layout;

import com.kingdee.cosmic.ctrl.kdf.util.render.exception.LayoutException;
import com.kingdee.cosmic.ctrl.kdf.util.render.layout.IRowBreaker;
import com.kingdee.cosmic.ctrl.kdf.util.render.layout.StandardUnderline;
import com.kingdee.cosmic.ctrl.kdf.util.render.layout.SureRow;
import com.kingdee.cosmic.ctrl.kdf.util.render.layout.SureTextLayout;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Line2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashSet;
import javax.swing.SwingUtilities;

public class TextLayoutBreaker2
implements IRowBreaker {
    private Graphics2D g2d;
    private AttributedString text;
    private String source;
    private char[] chars;
    private int pos;
    private float lineLength;

    public TextLayoutBreaker2(AttributedString text, Graphics2D g2d) {
        this(text, g2d, 100);
    }

    public TextLayoutBreaker2(AttributedString text, Graphics2D g2d, int lineLength) {
        this.g2d = g2d;
        this.text = text;
        this.setPos(0);
        this.setLineLength(lineLength);
        StringBuilder sb = new StringBuilder();
        AttributedCharacterIterator aci = this.text.getIterator();
        for (int i = 0; i < aci.getEndIndex(); ++i) {
            sb.append(aci.current());
            aci.next();
        }
        this.source = sb.toString();
        this.chars = this.source.toCharArray();
    }

    public AttributedString getText() {
        return this.text;
    }

    @Override
    public long getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        if (pos < 0 || pos > this.text.getIterator().getEndIndex()) {
            throw new IllegalArgumentException("Position is out of range.");
        }
        this.pos = pos;
    }

    public float getLineLength() {
        return this.lineLength;
    }

    @Override
    public void setLineLength(float length) {
        this.lineLength = length;
    }

    @Override
    public SureRow nextRow(float length) {
        String lineText;
        AttributedString as;
        Font originalFont = this.g2d.getFont();
        AttributedCharacterIterator aci = this.text.getIterator();
        Font ft = (Font)aci.getAttribute(TextAttribute.FONT);
        this.g2d.setFont(ft);
        try {
            char c;
            int charWidth;
            int endIndex;
            FontMetrics fontMetrics = this.g2d.getFontMetrics();
            int rowWidth = 0;
            for (endIndex = this.pos; endIndex < this.chars.length && !((float)(rowWidth += (charWidth = fontMetrics.charWidth(c = this.chars[endIndex]))) > length); ++endIndex) {
            }
            if (endIndex <= this.pos) {
                endIndex = this.pos + 1;
            }
            int wrapIndex = this.checkForWrap(endIndex);
            Character endC = Character.valueOf(this.chars[wrapIndex - 1]);
            Character nextC = null;
            Character prevC = null;
            if (wrapIndex < this.chars.length) {
                nextC = Character.valueOf(this.chars[wrapIndex]);
            }
            if (wrapIndex > 1) {
                prevC = Character.valueOf(this.chars[wrapIndex - 2]);
            }
            int endPos = wrapIndex;
            if (endC.charValue() == ' ' && (nextC == null || nextC.charValue() != ' ') && prevC != null && prevC.charValue() != ' ') {
                endPos = wrapIndex - 1;
            }
            as = new AttributedString(this.text.getIterator(), this.pos, endPos);
            lineText = this.source.substring(this.pos, endPos);
            this.pos = wrapIndex;
            if (wrapIndex == endIndex) {
                if (this.pos <= this.chars.length - 2) {
                    if (this.chars[this.pos] == ' ' && this.chars[this.pos + 1] != ' ') {
                        ++this.pos;
                    }
                } else if (this.pos == this.chars.length - 1 && this.chars[this.pos] == ' ') {
                    ++this.pos;
                }
            }
        }
        catch (Exception err) {
            throw new LayoutException("Line wrap error:baseline is too short", err);
        }
        finally {
            this.g2d.setFont(originalFont);
        }
        return new SureTextLayout(as, null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public double getAdvance() {
                Font originalFont = TextLayoutBreaker2.this.g2d.getFont();
                AttributedCharacterIterator aci = as.getIterator();
                Font ft = (Font)aci.getAttribute(TextAttribute.FONT);
                TextLayoutBreaker2.this.g2d.setFont(ft);
                try {
                    int stringWidth = TextLayoutBreaker2.this.g2d.getFontMetrics().stringWidth(lineText);
                    int totalWidth = 0;
                    for (int i = 0; i < lineText.length(); ++i) {
                        totalWidth += TextLayoutBreaker2.this.g2d.getFontMetrics().charWidth(lineText.charAt(i));
                    }
                    double d = TextLayoutBreaker2.this.g2d.getFontMetrics().stringWidth(lineText);
                    return d;
                }
                finally {
                    TextLayoutBreaker2.this.g2d.setFont(originalFont);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public double getDescent() {
                Font originalFont = TextLayoutBreaker2.this.g2d.getFont();
                AttributedCharacterIterator aci = as.getIterator();
                Font ft = (Font)aci.getAttribute(TextAttribute.FONT);
                TextLayoutBreaker2.this.g2d.setFont(ft);
                try {
                    double d = TextLayoutBreaker2.this.g2d.getFontMetrics().getDescent();
                    return d;
                }
                finally {
                    TextLayoutBreaker2.this.g2d.setFont(originalFont);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public double getAscent() {
                Font originalFont = TextLayoutBreaker2.this.g2d.getFont();
                AttributedCharacterIterator aci = as.getIterator();
                Font ft = (Font)aci.getAttribute(TextAttribute.FONT);
                TextLayoutBreaker2.this.g2d.setFont(ft);
                try {
                    double d = TextLayoutBreaker2.this.g2d.getFontMetrics().getAscent();
                    return d;
                }
                finally {
                    TextLayoutBreaker2.this.g2d.setFont(originalFont);
                }
            }

            @Override
            public void draw(Graphics2D g2d) {
                StringBuilder sb = new StringBuilder();
                AttributedCharacterIterator aci = as.getIterator();
                Font ft = (Font)aci.getAttribute(TextAttribute.FONT);
                Color pt = (Color)aci.getAttribute(TextAttribute.FOREGROUND);
                boolean strikethrough = aci.getAttribute(TextAttribute.STRIKETHROUGH) == TextAttribute.STRIKETHROUGH_ON;
                boolean underLine = aci.getAttribute(TextAttribute.UNDERLINE) == TextAttribute.UNDERLINE_ON;
                for (int i = 0; i < aci.getEndIndex(); ++i) {
                    sb.append(aci.current());
                    aci.next();
                }
                String str = sb.toString();
                Font ftOld = g2d.getFont();
                Paint ptOld = g2d.getPaint();
                if (ft != null) {
                    g2d.setFont(ft);
                }
                if (pt != null) {
                    g2d.setColor(pt);
                }
                float x = (float)this.getPoint().x;
                float y = (float)this.getPoint().y;
                g2d.drawString(str, x, y);
                if (strikethrough || underLine) {
                    int tWidth = SwingUtilities.computeStringWidth(g2d.getFontMetrics(), str);
                    float x1 = x;
                    float x2 = x1 + (float)tWidth;
                    if (ft == null) {
                        ft = ftOld;
                    }
                    LineMetrics lineMetrics = ft.getLineMetrics(str, g2d.getFontRenderContext());
                    if (strikethrough) {
                        Stroke saveStroke = g2d.getStroke();
                        float strikeY = y + lineMetrics.getStrikethroughOffset();
                        g2d.setStroke(new BasicStroke(lineMetrics.getStrikethroughThickness()));
                        g2d.draw(new Line2D.Float(x1, strikeY, x2, strikeY));
                        g2d.setStroke(saveStroke);
                    }
                    if (underLine) {
                        float ulOffset = lineMetrics.getUnderlineOffset();
                        float ulThickness = lineMetrics.getUnderlineThickness();
                        StandardUnderline.DefaultUnderline.drawUnderline(g2d, ulThickness, x1, x2, y + ulOffset);
                    }
                }
                g2d.setFont(ftOld);
                g2d.setPaint(ptOld);
            }
        };
    }

    private int checkForWrap(int endIndex) {
        for (int i = this.pos; i < endIndex; ++i) {
            if (this.chars[i] != '\n') continue;
            return i + 1;
        }
        return endIndex;
    }

    private int getPreWordBreak(int fromIndex) {
        int i = fromIndex - 1;
        while ((long)i > this.getPos()) {
            if (!this.isInWord(i)) {
                return i;
            }
            --i;
        }
        return fromIndex;
    }

    private boolean isInWord(int index) {
        if (index <= 0 || index >= this.source.length()) {
            return false;
        }
        char c = this.chars[index];
        char pc = this.chars[index - 1];
        if (this.isCJKCharacter(pc)) {
            return this.isPunctuation(c);
        }
        if (this.isCJKCharacter(c)) {
            return false;
        }
        return !Character.isWhitespace(c) && !Character.isWhitespace(pc);
    }

    private boolean isPunctuation(char c) {
        int type = Character.getType(c);
        HashSet<Integer> punctuationTypes = new HashSet<Integer>();
        punctuationTypes.add(23);
        punctuationTypes.add(20);
        punctuationTypes.add(22);
        punctuationTypes.add(30);
        punctuationTypes.add(29);
        punctuationTypes.add(24);
        punctuationTypes.add(21);
        boolean isPunctuation = punctuationTypes.contains(type);
        return isPunctuation;
    }

    private boolean isCJKCharacter(char c) {
        Character.UnicodeBlock[] cjkBlocks;
        int[][] cjkUnicodeRanges;
        for (int[] range : cjkUnicodeRanges = new int[][]{{12288, 40959}, {11904, 12031}, {12032, 12245}, {11904, 12019}, {63744, 64217}, {59413, 59503}, {58368, 58856}, {58880, 59087}, {12272, 12287}, {65040, 65055}, {44032, 55215}, {4352, 4607}}) {
            if (range[0] > c || c > range[1]) continue;
            return true;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        for (Character.UnicodeBlock cjkBlock : cjkBlocks = new Character.UnicodeBlock[]{Character.UnicodeBlock.CJK_COMPATIBILITY, Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT, Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B}) {
            if (!cjkBlock.equals(unicodeBlock)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SureRow nextRow() {
        return this.nextRow(this.lineLength);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.text.getIterator().getEndIndex();
    }
}

