/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render.r1print;

import com.kingdee.cosmic.ctrl.common.util.FontUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.NoteTextRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ComplexTextRenderer {
    private static final Logger log = LogUtil.getLogger(ComplexTextRenderer.class);
    private NoteTextRender _noteTextRender;

    public ComplexTextRenderer() {
    }

    public ComplexTextRenderer(NoteTextRender noteTextRender) {
        this._noteTextRender = noteTextRender;
    }

    private NoteTextRender getNoteTextRender() {
        if (this._noteTextRender == null) {
            this._noteTextRender = NoteTextRender.shareInstance();
        }
        return this._noteTextRender;
    }

    private static boolean isShrinkWrap(Style style) {
        return style.isWrapText() && style.isShrinkText();
    }

    public void draw(Graphics g, Shape clip, Object object, Style style) {
        String text = this.object2String(object);
        if (StringUtil.isEmptyString((String)text)) {
            return;
        }
        if (ComplexTextRenderer.isShrinkWrap(style)) {
            Rectangle rect = clip.getBounds();
            if (rect.width <= 0 || rect.height <= 0) {
                return;
            }
            log.debug((Object)("\u6298\u884c+\u7f29\u653e\uff0c\u5f00\u59cb\u3002\u76ee\u6807\u5b57\u7b26\u4e32\uff1a" + text));
            log.debug((Object)("\u539f(\u7ed8\u5236)\u5b57\u53f7\uff1a" + ComplexTextRenderer.getOriSize(style)));
            DrawingInfo info = this.thickAdjust((Graphics2D)g, text, rect.width, rect.height, style);
            int yOffset = this.thinAdjust((Graphics2D)g, rect, info, style);
            this.drawing((Graphics2D)g, rect, info, style, yOffset);
            log.debug((Object)("\u6298\u884c+\u7f29\u653e\uff0c\u7ed3\u675f\u3002\u76ee\u6807\u5b57\u7b26\u4e32\uff1a" + text));
        } else {
            this.getNoteTextRender().draw(g, clip, object, style);
        }
    }

    private String object2String(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    private static float estimateAvgCharWidth(String text, Font font, float wordSpacing, Graphics2D g2d) {
        FontMetrics fm = g2d.getFontMetrics(font);
        float width = fm.stringWidth(text);
        return width / (float)text.length() + wordSpacing;
    }

    private static float calculateLineHeight(String text, Font font, float lineSpacing, Graphics2D g2d) {
        LineMetrics lm = font.getLineMetrics(text, 0, 1, g2d.getFontRenderContext());
        return lm.getHeight() + lineSpacing;
    }

    private static Font createFont(Style style, int fontSize) {
        int boldAndItalic = 0;
        boldAndItalic += style.isBold() ? 1 : 0;
        return new Font(style.getFontName(), boldAndItalic += style.isItalic() ? 2 : 0, fontSize);
    }

    private static int getOriSize(Style style) {
        return style.getKDFont().getDrawingSize();
    }

    private DrawingInfo thickAdjust(Graphics2D g2d, String text, int width, int height, Style style) {
        float lineHeight;
        float wordSpacing = style.getWordspacing();
        float lineSpacing = style.getLinespacing();
        int fontSize = ComplexTextRenderer.getOriSize(style);
        while (true) {
            float rate;
            if (fontSize <= 0) {
                return DrawingInfo.create(text, 0, 0.0f, 0.0f, 0.0f);
            }
            Font font = ComplexTextRenderer.createFont(style, fontSize);
            float avgCharWidth = ComplexTextRenderer.estimateAvgCharWidth(text, font, wordSpacing, g2d);
            if ((float)width < avgCharWidth) {
                rate = (float)width / avgCharWidth;
                fontSize = (int)((float)fontSize * rate);
                log.debug((Object)("\u5bbd\u5ea6\u592a\u5c0f\uff0c\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + fontSize));
                continue;
            }
            lineHeight = ComplexTextRenderer.calculateLineHeight(text, font, lineSpacing, g2d);
            if ((float)height < lineHeight) {
                rate = (float)height / lineHeight;
                fontSize = (int)((float)fontSize * rate);
                log.debug((Object)("\u9ad8\u5ea6\u592a\u5c0f\uff0c\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + fontSize));
                continue;
            }
            float lineCount = (float)height / lineHeight;
            int acceptedCharCount = (int)((float)width / avgCharWidth * lineCount);
            if (acceptedCharCount >= text.length()) break;
            fontSize = (int)((double)fontSize * Math.sqrt((float)acceptedCharCount / (float)text.length()));
            log.debug((Object)("\u5feb\u901f\u8c03\u6574\u5b57\u53f7\u4e3a\uff1a" + fontSize));
        }
        return DrawingInfo.create(text, fontSize, lineHeight, wordSpacing, lineSpacing);
    }

    private int thinAdjust(Graphics2D g2d, Rectangle rect, DrawingInfo info, Style style) {
        String text = info.getText();
        CalculateExtend ce = new CalculateExtend(g2d);
        int testTimes = 0;
        boolean toTry = true;
        while (toTry && testTimes <= 10) {
            log.debug((Object)("\u8bd5\u63a2\u7b2c" + ++testTimes + "\u6b21\uff0c\u5b57\u53f7\uff1a" + info.getFontSize()));
            Font font = ComplexTextRenderer.createFont(style, info.getFontSize());
            FontMetrics fm = g2d.getFontMetrics(font);
            LineMetrics lm = font.getLineMetrics(text, g2d.getFontRenderContext());
            ce.setOnceMore(false);
            ComplexTextRenderer.throughStringAtRect(text, info, style, rect.width, rect.height, fm, lm, ce);
            toTry = ce.isOnceMore();
        }
        info.updateFontSize(ce.getFitSize(), style, (int)rect.getHeight(), g2d);
        int offsetY = style.getVerticalAlign() == Styles.VerticalAlignment.TOP ? 0 : (style.getVerticalAlign() == Styles.VerticalAlignment.MIDDLE ? (rect.height - ce.getUsedHeight()) / 2 - 1 : rect.height - ce.getUsedHeight() - 2);
        return offsetY;
    }

    private void drawing(Graphics2D g2d, Rectangle rect, DrawingInfo info, Style style, int yOffset) {
        String text = info.getText();
        Graphics2D newGraphics = (Graphics2D)g2d.create(rect.x, rect.y + yOffset, rect.width, rect.height - yOffset);
        Font font = ComplexTextRenderer.createFont(style, info.getFontSize());
        Font validateFont = FontUtil.validateFont((String)text, (Font)font);
        g2d.setFont(validateFont);
        newGraphics.setFont(validateFont);
        newGraphics.setColor(style.getFontColor());
        DrawingExtend ext = new DrawingExtend(newGraphics);
        FontMetrics fm = g2d.getFontMetrics(validateFont);
        LineMetrics lm = font.getLineMetrics(text, 0, 1, g2d.getFontRenderContext());
        ComplexTextRenderer.throughStringAtRect(text, info, style, rect.width, rect.height, fm, lm, ext);
    }

    private static void throughStringAtRect(String text, DrawingInfo info, Style style, int width, int height, FontMetrics fontMetrics, LineMetrics lineMetrics, IThroughStringAtRect ext) {
        int offsetX = ComplexTextRenderer.calculateOffsetX(text, 0, info, fontMetrics, width, style.getHorizontalAlign());
        float x = 0.0f;
        float y = lineMetrics.getAscent();
        StringBuilder lineSb = new StringBuilder();
        int lineWidth = 0;
        int pos = 0;
        do {
            String line;
            char c = text.charAt(pos);
            if (lineSb.length() > 0) {
                lineWidth = (int)((float)lineWidth + info.getWordSpacing());
            }
            lineSb.append(c);
            lineWidth += fontMetrics.charWidth(c);
            if (c == '\n') {
                line = lineSb.toString();
                if ((line = line.substring(0, line.length() - 1)).length() > 1) {
                    char endC = line.charAt(line.length() - 1);
                    char prevC = line.charAt(line.length() - 2);
                    if (endC == ' ' && prevC != ' ') {
                        line = line.substring(0, line.length() - 1);
                    }
                }
                lineWidth = ComplexTextRenderer.calculateLineWidth(line, info, fontMetrics);
                x = ComplexTextRenderer.calculateOffsetX(lineWidth, width, style.getHorizontalAlign());
                ComplexTextRenderer.drawLine(ext, line, info, fontMetrics, x, y);
                lineSb = new StringBuilder();
                lineWidth = 0;
                y += info.getLineHeight();
                continue;
            }
            if (lineWidth > width && lineSb.length() <= 1) {
                lineSb = new StringBuilder();
                lineWidth = 0;
                continue;
            }
            if (lineWidth <= width || lineSb.length() <= 1) continue;
            line = lineSb.toString();
            int breakIndex = line.length() - 1;
            if (ComplexTextRenderer.isInWord(line, line.length() - 1)) {
                breakIndex = ComplexTextRenderer.getPreWordBreak(line, line.length() - 1);
            }
            String lineToDraw = line.substring(0, breakIndex);
            Character curC = Character.valueOf(text.charAt(pos -= line.length() - breakIndex));
            Character nextC = null;
            Character prevC = null;
            if (lineToDraw.length() > 1) {
                prevC = Character.valueOf(text.charAt(pos - 1));
            }
            if (pos < text.length() - 1) {
                nextC = Character.valueOf(text.charAt(pos + 1));
            }
            if (curC.charValue() == ' ' && (nextC == null || nextC.charValue() != ' ') && prevC != null && prevC.charValue() != ' ') {
                lineToDraw = lineToDraw.substring(0, lineToDraw.length() - 1);
            }
            int nextCharPos = pos + 1;
            Character curC2 = Character.valueOf(text.charAt(nextCharPos));
            Character nextC2 = null;
            Character prevC2 = null;
            if (text.length() > 1) {
                prevC2 = Character.valueOf(text.charAt(nextCharPos - 1));
            }
            if (nextCharPos < text.length() - 1) {
                nextC2 = Character.valueOf(text.charAt(nextCharPos + 1));
            }
            if (curC2.charValue() == ' ' && (nextC2 == null || nextC2.charValue() != ' ') && prevC2 != null && prevC2.charValue() != ' ') {
                ++pos;
            }
            lineWidth = ComplexTextRenderer.calculateLineWidth(lineToDraw, info, fontMetrics);
            x = ComplexTextRenderer.calculateOffsetX(lineWidth, width, style.getHorizontalAlign());
            ComplexTextRenderer.drawLine(ext, lineToDraw, info, fontMetrics, x, y);
            lineSb = new StringBuilder();
            lineWidth = 0;
            y += info.getLineHeight();
        } while (++pos < text.length());
        if (lineSb.length() > 0) {
            String line = lineSb.toString();
            int lineLength = line.length();
            if (lineLength > 1 && line.charAt(lineLength - 1) == ' ' && line.charAt(lineLength - 2) != ' ') {
                line = line.substring(0, lineLength - 1);
            }
            lineWidth = ComplexTextRenderer.calculateLineWidth(line, info, fontMetrics);
            x = ComplexTextRenderer.calculateOffsetX(lineWidth, width, style.getHorizontalAlign());
            ComplexTextRenderer.drawLine(ext, line, info, fontMetrics, x, y);
        }
        ext.dealThroughEnd(text, info, style, height, y, lineMetrics);
    }

    private static int calculateLineWidth(String line, DrawingInfo info, FontMetrics fontMetrics) {
        int lineWidth = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            int charWidth = fontMetrics.charWidth(c);
            lineWidth += charWidth;
            if (i == line.length()) continue;
            lineWidth = (int)((float)lineWidth + info.getWordSpacing());
        }
        return lineWidth;
    }

    private static void drawLine(IThroughStringAtRect ext, String line, DrawingInfo info, FontMetrics fontMetrics, float x, float y) {
        float drawX = x;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            int charWidth = fontMetrics.charWidth(c);
            ext.dealAChar(drawX, y, c, charWidth);
            drawX += (float)charWidth;
            drawX += info.getWordSpacing();
        }
    }

    private static boolean isInWord(String source, int index) {
        if (index <= 0 || index >= source.length()) {
            return false;
        }
        char c = source.charAt(index);
        char pc = source.charAt(index - 1);
        if (ComplexTextRenderer.isCJKCharacter(pc)) {
            return ComplexTextRenderer.isPunctuation(c);
        }
        if (ComplexTextRenderer.isCJKCharacter(c)) {
            return false;
        }
        return !Character.isWhitespace(c) && !Character.isWhitespace(pc);
    }

    private static int getPreWordBreak(String line, int fromIndex) {
        for (int i = fromIndex; i >= 1; --i) {
            if (ComplexTextRenderer.isInWord(line, i)) continue;
            return i;
        }
        return fromIndex;
    }

    private static boolean isPunctuation(char c) {
        int type = Character.getType(c);
        HashSet<Integer> punctuationTypes = new HashSet<Integer>();
        punctuationTypes.add(23);
        punctuationTypes.add(20);
        punctuationTypes.add(22);
        punctuationTypes.add(30);
        punctuationTypes.add(29);
        punctuationTypes.add(24);
        punctuationTypes.add(21);
        boolean isPunctuation = punctuationTypes.contains(type);
        return isPunctuation;
    }

    private static boolean isCJKCharacter(char c) {
        Character.UnicodeBlock[] cjkBlocks;
        int[][] cjkUnicodeRanges;
        for (int[] range : cjkUnicodeRanges = new int[][]{{12288, 40959}, {11904, 12031}, {12032, 12245}, {11904, 12019}, {63744, 64217}, {59413, 59503}, {58368, 58856}, {58880, 59087}, {12272, 12287}, {65040, 65055}, {44032, 55215}, {4352, 4607}}) {
            if (range[0] > c || c > range[1]) continue;
            return true;
        }
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        for (Character.UnicodeBlock cjkBlock : cjkBlocks = new Character.UnicodeBlock[]{Character.UnicodeBlock.CJK_COMPATIBILITY, Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS, Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT, Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B}) {
            if (!cjkBlock.equals(unicodeBlock)) continue;
            return true;
        }
        return false;
    }

    private static int calculateOffsetX(double lineWidth, double width, Styles.HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == Styles.HorizontalAlignment.LEFT) {
            return 0;
        }
        if (horizontalAlignment == Styles.HorizontalAlignment.CENTER) {
            double offsetX = (width - lineWidth) / 2.0;
            if (offsetX < 0.0) {
                offsetX = 0.0;
            }
            return (int)Math.round(offsetX);
        }
        if (horizontalAlignment == Styles.HorizontalAlignment.RIGHT) {
            double offsetX = width - lineWidth;
            return (int)Math.round(offsetX);
        }
        return 0;
    }

    private static int calculateOffsetX(String text, int startIdx, DrawingInfo info, FontMetrics fontMetrics, int width, Styles.HorizontalAlignment horizontalAlignment) {
        if (horizontalAlignment == Styles.HorizontalAlignment.LEFT) {
            return 0;
        }
        float lineWidth = 0.0f;
        int charCount = text.length();
        for (int lineCharIndex = startIdx; lineCharIndex < charCount; ++lineCharIndex) {
            char aChar = text.charAt(lineCharIndex);
            int charWidth = fontMetrics.charWidth(aChar);
            float addWidth = 0.0f;
            if (lineWidth > 0.0f && charWidth > 0) {
                addWidth = info.getWordSpacing();
            }
            if (lineWidth + (addWidth += (float)charWidth) > (float)width || aChar == '\n') break;
            lineWidth += addWidth;
        }
        int offsetX = horizontalAlignment == Styles.HorizontalAlignment.CENTER ? (width - (int)lineWidth) / 2 : width - (int)lineWidth;
        return offsetX;
    }

    static class DrawingExtend
    implements IThroughStringAtRect {
        private Graphics2D g2d;

        public DrawingExtend(Graphics2D g) {
            this.g2d = g;
        }

        @Override
        public void dealAChar(float x, float y, char aChar, int charWidth) {
            if (charWidth > 0) {
                this.g2d.drawString(String.valueOf(aChar), x, y);
            }
        }

        @Override
        public void dealOutSideRect(String text, DrawingInfo info, Style style, int height, int throughingTextIdx) {
        }

        @Override
        public void dealThroughEnd(String text, DrawingInfo info, Style style, int height, float yEnd, LineMetrics lm) {
        }
    }

    static class CalculateExtend
    implements IThroughStringAtRect {
        private boolean onceMore;
        private Graphics2D g2d;
        private int cacheFitSize = -1;
        private int cacheMinTooBigSize = Integer.MAX_VALUE;
        private int cacheFitYEnd = 0;

        public CalculateExtend(Graphics2D g) {
            this.g2d = g;
        }

        public void setOnceMore(boolean is) {
            this.onceMore = is;
        }

        public boolean isOnceMore() {
            return this.onceMore;
        }

        public int getUsedHeight() {
            return this.cacheFitYEnd;
        }

        public int getFitSize() {
            return this.cacheFitSize;
        }

        @Override
        public void dealOutSideRect(String text, DrawingInfo info, Style style, int height, int throughingTextIdx) {
            if (info.getFontSize() < this.cacheMinTooBigSize) {
                this.cacheMinTooBigSize = info.getFontSize();
            }
            int newSize = (int)((double)info.getFontSize() * Math.sqrt((float)throughingTextIdx / (float)text.length()));
            info.updateFontSize(newSize, style, height, this.g2d);
            if (newSize > this.cacheFitSize && newSize < this.cacheMinTooBigSize) {
                this.onceMore = true;
                log.debug((Object)("\u7a7a\u95f4\u4e0d\u591f\uff0c\u5c0f\u5c0f\u5c0f\u5230" + newSize));
            } else {
                log.debug((Object)("\u7a7a\u95f4\u4e0d\u591f\uff0c\u4f46\u6ca1\u5fc5\u8981\u518d\u5c0f\u5230" + newSize + "\uff0c\u5c31\u7528" + this.cacheFitSize));
            }
        }

        @Override
        public void dealAChar(float x, float y, char aChar, int charWidth) {
        }

        @Override
        public void dealThroughEnd(String text, DrawingInfo info, Style style, int height, float yEnd, LineMetrics lm) {
            int newSize;
            double y = yEnd + lm.getDescent() + 1.0f;
            int size = info.getFontSize();
            int oriSize = ComplexTextRenderer.getOriSize(style);
            double usedRate = y / (double)height;
            if (usedRate <= 1.0 && size > this.cacheFitSize && size <= oriSize) {
                log.debug((Object)("\u7f13\u5b58\u5408\u9002\u5b57\u53f7\u53ca\u7ed8\u5236\u72b6\u6001: " + this.cacheFitSize + " => " + info.getFontSize()));
                this.cacheFitSize = size;
                this.cacheFitYEnd = (int)y;
            }
            if ((newSize = usedRate > 1.0 ? (int)((double)info.getFontSize() * Math.sqrt(1.0 / usedRate) - 0.5) : (int)((double)info.getFontSize() * Math.sqrt(1.0 / usedRate) + 0.5)) > oriSize) {
                newSize = oriSize;
            }
            info.updateFontSize(newSize, style, height, this.g2d);
            this.onceMore = newSize != this.cacheFitSize;
        }
    }

    static interface IThroughStringAtRect {
        public void dealAChar(float var1, float var2, char var3, int var4);

        public void dealOutSideRect(String var1, DrawingInfo var2, Style var3, int var4, int var5);

        public void dealThroughEnd(String var1, DrawingInfo var2, Style var3, int var4, float var5, LineMetrics var6);
    }

    private static class DrawingInfo {
        private String text;
        private int fontSize;
        private float lineHeight;
        private float wordSpacing;
        private float lineSpacing;

        private DrawingInfo(String text) {
            this.text = text;
        }

        public static DrawingInfo create(String text, int fontSize, float lineHeight, float wordSpacing, float lineSpacing) {
            DrawingInfo info = new DrawingInfo(text);
            info.fontSize = fontSize;
            info.lineHeight = lineHeight;
            info.wordSpacing = wordSpacing;
            info.lineSpacing = lineSpacing;
            return info;
        }

        public final String getText() {
            return this.text;
        }

        public final float getLineHeight() {
            return this.lineHeight;
        }

        public final int getFontSize() {
            return this.fontSize;
        }

        public final float getWordSpacing() {
            return this.wordSpacing;
        }

        public final float getLineSpacing() {
            return this.lineSpacing;
        }

        public final void updateFontSize(int fontSize, Style style, int rectHeight, Graphics2D g2d) {
            this.fontSize = fontSize;
            this.lineHeight = ComplexTextRenderer.calculateLineHeight(this.text, ComplexTextRenderer.createFont(style, fontSize), this.lineSpacing, g2d);
        }
    }
}

