/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle;

import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.ISplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class SplitRectInfo
implements ISplitRectInfo {
    protected Integer _relatePos;
    protected int _xSplitNum;
    protected int _ySplitNum;
    private TriangleInfo[] triangles;

    public SplitRectInfo() {
    }

    public SplitRectInfo(Integer relatePos, int xSplitNum, int ySplitNum) {
        this.reset(relatePos, xSplitNum, ySplitNum);
    }

    public void reset(Integer relatePos, int xSplitNum, int ySplitNum) {
        this._relatePos = relatePos;
        this._xSplitNum = xSplitNum;
        this._ySplitNum = ySplitNum;
        this.triangles = null;
    }

    @Override
    public int size() {
        return this._xSplitNum + this._ySplitNum + 2;
    }

    @Override
    public TriangleInfo getTriangleInfo(Rectangle2D rect, int index) {
        Point2D[] points = new Point2D.Double[3];
        this.calcTrianglePoints(points, rect, index);
        TriangleInfo polygon = this.getTriangleInfo(index);
        polygon.setPoints(points);
        return polygon;
    }

    @Override
    public Line2D getLine(Rectangle2D rect, int index) {
        Line2D.Double line = new Line2D.Double();
        this.calcLine(line, rect, index);
        return line;
    }

    public int contains(Rectangle2D rect, Point2D p) {
        for (int i = this.size() - 1; i >= 0; --i) {
            TriangleInfo info = this.getTriangleInfo(rect, i);
            if (!info.getAwtShape().contains(p)) continue;
            return i;
        }
        return -1;
    }

    public int contains(Point2D p) {
        for (int i = this.size() - 1; i >= 0; --i) {
            TriangleInfo info = this.getTriangleInfo(i);
            if (!info.getAwtShape().contains(p)) continue;
            return i;
        }
        return -1;
    }

    public void setDrawBackground(boolean drawBack, int triangleIndex) {
        this.getTriangleInfo(triangleIndex).setDrawBackground(drawBack);
    }

    public void setText(String text, int triangleIndex) {
        this.getTriangleInfo(triangleIndex).setText(text);
    }

    public void setAutoZoom(boolean autoZoom, int triangleIndex) {
        this.getTriangleInfo(triangleIndex).setAutoZoom(autoZoom);
    }

    public void setLean(boolean lean, int triangleIndex) {
        this.getTriangleInfo(triangleIndex).setLean(lean);
    }

    public void setStyle(Style style, int triangleIndex) {
        this.getTriangleInfo(triangleIndex).setStyle(style);
    }

    public Integer getPosition() {
        return this._relatePos;
    }

    public TriangleInfo getTriangleInfo(int index) {
        if (this.triangles == null) {
            this.triangles = new TriangleInfo[this.size()];
        }
        if (this.triangles[index] == null) {
            this.triangles[index] = new TriangleInfo();
        }
        return this.triangles[index];
    }

    private void calcLine(Line2D line, Rectangle2D rect, int lineIndex) {
        Point2D.Double p2;
        Point2D.Double p;
        double minx = rect.getX();
        double miny = rect.getY();
        double maxx = rect.getMaxX() - 1.0;
        double maxy = rect.getMaxY() - 1.0;
        if (RELATE_TO_UPLEFT.equals(this._relatePos)) {
            if (lineIndex < this._ySplitNum) {
                p = new Point2D.Double(minx, miny);
                double tempy = miny;
                double[] ys = this.getYSplitOffs();
                for (int i = 0; i <= lineIndex; ++i) {
                    tempy += ys[i];
                }
                p2 = new Point2D.Double(maxx, tempy);
            } else if (this.size() - 2 - lineIndex < this._xSplitNum) {
                p = new Point2D.Double(minx, miny);
                double tempx = minx;
                double[] xs = this.getXSplitOffs();
                int tempIndex = this.size() - 2 - lineIndex;
                for (int i = 0; i <= tempIndex; ++i) {
                    tempx += xs[i];
                }
                p2 = new Point2D.Double(tempx, maxy);
            } else {
                p = new Point2D.Double(minx, miny);
                p2 = new Point2D.Double(maxx, maxy);
            }
        } else if (RELATE_TO_UPRIGHT.equals(this._relatePos)) {
            if (lineIndex < this._xSplitNum) {
                p = new Point2D.Double(maxx, miny);
                double tempx = minx;
                double[] xs = this.getXSplitOffs();
                int tempIndex = this._xSplitNum - lineIndex;
                for (int i = 0; i < tempIndex; ++i) {
                    tempx += xs[i];
                }
                p2 = new Point2D.Double(tempx, maxy);
            } else if (this.size() - 2 - lineIndex < this._ySplitNum) {
                p = new Point2D.Double(maxx, miny);
                double tempy = miny;
                double[] ys = this.getYSplitOffs();
                int tempIndex = this.size() - 2 - lineIndex;
                for (int i = 0; i <= tempIndex; ++i) {
                    tempy += ys[i];
                }
                p2 = new Point2D.Double(minx, tempy);
            } else {
                p = new Point2D.Double(maxx, miny);
                p2 = new Point2D.Double(minx, maxy);
            }
        } else if (RELATE_TO_DOWNLEFT.equals(this._relatePos)) {
            if (lineIndex < this._xSplitNum) {
                p = new Point2D.Double(minx, maxy);
                double tempx = minx;
                double[] xs = this.getXSplitOffs();
                for (int i = 0; i <= lineIndex; ++i) {
                    tempx += xs[i];
                }
                p2 = new Point2D.Double(tempx, miny);
            } else if (this.size() - 2 - lineIndex < this._ySplitNum) {
                p = new Point2D.Double(minx, maxy);
                double tempy = miny;
                double[] ys = this.getYSplitOffs();
                int tempIndex = lineIndex - this._xSplitNum - 1;
                for (int i = 0; i <= tempIndex; ++i) {
                    tempy += ys[i];
                }
                p2 = new Point2D.Double(maxx, tempy);
            } else {
                p = new Point2D.Double(minx, maxy);
                p2 = new Point2D.Double(maxx, miny);
            }
        } else if (lineIndex < this._ySplitNum) {
            p = new Point2D.Double(maxx, maxy);
            double tempy = miny;
            double[] ys = this.getYSplitOffs();
            int tempIndex = this._ySplitNum - lineIndex;
            for (int i = 0; i < tempIndex; ++i) {
                tempy += ys[i];
            }
            p2 = new Point2D.Double(minx, tempy);
        } else if (this.size() - 2 - lineIndex < this._xSplitNum) {
            p = new Point2D.Double(maxx, maxy);
            double tempx = minx;
            double[] xs = this.getXSplitOffs();
            int tempIndex = lineIndex - this._ySplitNum - 1;
            for (int i = 0; i <= tempIndex; ++i) {
                tempx += xs[i];
            }
            p2 = new Point2D.Double(tempx, miny);
        } else {
            p = new Point2D.Double(maxx, maxy);
            p2 = new Point2D.Double(minx, miny);
        }
        line.setLine(p, p2);
    }

    private void calcTrianglePoints(Point2D[] points, Rectangle2D rect, int triangleIndex) {
        double minx = rect.getX();
        double miny = rect.getY();
        double maxx = rect.getMaxX() - 1.0;
        double maxy = rect.getMaxY() - 1.0;
        if (RELATE_TO_UPLEFT.equals(this._relatePos)) {
            if (triangleIndex < this._ySplitNum) {
                points[0] = new Point2D.Double(minx, miny);
                double tempy = miny;
                double[] ys = this.getYSplitOffs();
                for (int i = 0; i < triangleIndex; ++i) {
                    tempy += ys[i];
                }
                points[1] = new Point2D.Double(maxx, tempy);
                points[2] = new Point2D.Double(maxx, tempy + ys[triangleIndex]);
            } else if (this.size() - 1 - triangleIndex < this._xSplitNum) {
                points[0] = new Point2D.Double(minx, miny);
                double tempx = minx;
                double[] xs = this.getXSplitOffs();
                int tempIndex = this.size() - 1 - triangleIndex;
                for (int i = 0; i < tempIndex; ++i) {
                    tempx += xs[i];
                }
                points[1] = new Point2D.Double(tempx, maxy);
                points[2] = new Point2D.Double(tempx + xs[tempIndex], maxy);
            } else if (triangleIndex == this._ySplitNum) {
                points[0] = new Point2D.Double(minx, miny);
                points[2] = new Point2D.Double(maxx, maxy);
                double tempy = miny;
                double[] ys = this.getYSplitOffs();
                for (int i = ys.length - 1; i >= 0; --i) {
                    tempy += ys[i];
                }
                points[1] = new Point2D.Double(maxx, tempy);
            } else {
                points[0] = new Point2D.Double(minx, miny);
                points[1] = new Point2D.Double(maxx, maxy);
                double tempx = minx;
                double[] xs = this.getXSplitOffs();
                for (int i = xs.length - 1; i >= 0; --i) {
                    tempx += xs[i];
                }
                points[2] = new Point2D.Double(tempx, maxy);
            }
        } else if (RELATE_TO_UPRIGHT.equals(this._relatePos)) {
            if (triangleIndex < this._xSplitNum) {
                points[0] = new Point2D.Double(maxx, miny);
                double tempx = minx;
                double[] xs = this.getXSplitOffs();
                int tempIndex = this._xSplitNum - triangleIndex;
                for (int i = 0; i < tempIndex; ++i) {
                    tempx += xs[i];
                }
                points[1] = new Point2D.Double(tempx, maxy);
                points[2] = tempIndex < this._xSplitNum ? new Point2D.Double(tempx + xs[tempIndex], maxy) : new Point2D.Double(maxx, maxy);
            } else if (this.size() - 1 - triangleIndex < this._ySplitNum) {
                points[0] = new Point2D.Double(maxx, miny);
                double tempy = miny;
                double[] ys = this.getYSplitOffs();
                int tempIndex = this.size() - 1 - triangleIndex;
                for (int i = 0; i < tempIndex; ++i) {
                    tempy += ys[i];
                }
                points[1] = new Point2D.Double(minx, tempy);
                points[2] = new Point2D.Double(minx, tempy + ys[tempIndex]);
            } else if (triangleIndex == this._xSplitNum) {
                points[0] = new Point2D.Double(minx, maxy);
                points[2] = new Point2D.Double(maxx, miny);
                double tempx = minx;
                double[] xs = this.getXSplitOffs();
                tempx = xs.length > 0 ? (tempx += xs[0]) : maxx;
                points[1] = new Point2D.Double(tempx, maxy);
            } else {
                points[0] = new Point2D.Double(minx, maxy);
                points[1] = new Point2D.Double(maxx, miny);
                double tempy = miny;
                double[] ys = this.getYSplitOffs();
                for (int i = ys.length - 1; i >= 0; --i) {
                    tempy += ys[i];
                }
                points[2] = new Point2D.Double(minx, tempy);
            }
        } else if (RELATE_TO_DOWNLEFT.equals(this._relatePos)) {
            if (triangleIndex < this._xSplitNum) {
                points[0] = new Point2D.Double(minx, maxy);
                double tempx = minx;
                double[] xs = this.getXSplitOffs();
                for (int i = 0; i < triangleIndex; ++i) {
                    tempx += xs[i];
                }
                points[1] = new Point2D.Double(tempx, miny);
                points[2] = new Point2D.Double(tempx + xs[triangleIndex], miny);
            } else if (this.size() - 1 - triangleIndex < this._ySplitNum) {
                points[0] = new Point2D.Double(minx, maxy);
                double tempy = miny;
                double[] ys = this.getYSplitOffs();
                int tempIndex = triangleIndex - this._xSplitNum - 1;
                for (int i = 0; i < tempIndex; ++i) {
                    tempy += ys[i];
                }
                points[1] = new Point2D.Double(maxx, tempy);
                points[2] = tempIndex < this._ySplitNum ? new Point2D.Double(maxx, tempy + ys[tempIndex]) : new Point2D.Double(maxx, maxy);
            } else if (triangleIndex == this._xSplitNum) {
                points[0] = new Point2D.Double(minx, maxy);
                points[2] = new Point2D.Double(maxx, miny);
                double tempx = minx;
                double[] xs = this.getXSplitOffs();
                for (int i = xs.length - 1; i >= 0; --i) {
                    tempx += xs[i];
                }
                points[1] = new Point2D.Double(tempx, miny);
            } else {
                points[0] = new Point2D.Double(minx, maxy);
                points[1] = new Point2D.Double(maxx, miny);
                double[] ys = this.getYSplitOffs();
                double tempy = miny;
                tempy = ys.length > 0 ? (tempy += ys[0]) : maxy;
                points[2] = new Point2D.Double(maxx, tempy);
            }
        } else if (triangleIndex < this._ySplitNum) {
            points[0] = new Point2D.Double(maxx, maxy);
            double tempy = miny;
            double[] ys = this.getYSplitOffs();
            int tempIndex = this._ySplitNum - triangleIndex;
            for (int i = 0; i < tempIndex; ++i) {
                tempy += ys[i];
            }
            points[1] = new Point2D.Double(minx, tempy);
            points[2] = tempIndex < this._ySplitNum ? new Point2D.Double(minx, tempy + ys[triangleIndex]) : new Point2D.Double(minx, maxy);
        } else if (this.size() - 1 - triangleIndex < this._xSplitNum) {
            points[0] = new Point2D.Double(maxx, maxy);
            double tempx = minx;
            double[] xs = this.getXSplitOffs();
            int tempIndex = triangleIndex - this._ySplitNum - 1;
            for (int i = 0; i < tempIndex; ++i) {
                tempx += xs[i];
            }
            points[1] = new Point2D.Double(tempx, miny);
            points[2] = tempIndex < this._xSplitNum ? new Point2D.Double(tempx + xs[tempIndex], miny) : new Point2D.Double(maxx, miny);
        } else if (triangleIndex == this._ySplitNum) {
            points[0] = new Point2D.Double(minx, miny);
            points[1] = new Point2D.Double(maxx, maxy);
            double tempy = miny;
            double[] ys = this.getYSplitOffs();
            tempy = ys.length > 0 ? (tempy += ys[0]) : maxy;
            points[2] = new Point2D.Double(minx, tempy);
        } else {
            points[0] = new Point2D.Double(minx, miny);
            points[1] = new Point2D.Double(maxx, maxy);
            double tempx = minx;
            double[] xs = this.getXSplitOffs();
            tempx = xs.length > 0 ? (tempx += xs[0]) : maxx;
            points[2] = new Point2D.Double(tempx, miny);
        }
    }

    public abstract double[] getXSplitOffs();

    public abstract double[] getYSplitOffs();

    public boolean equals(Object o) {
        if (o instanceof SplitRectInfo) {
            SplitRectInfo si = (SplitRectInfo)o;
            return si._relatePos.equals(this._relatePos) && si._xSplitNum == this._xSplitNum && si._ySplitNum == this._ySplitNum;
        }
        return false;
    }
}

