/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.TableSplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class TableSplitRectInfoXml {
    public static final String DIAGONALHEADER = "DiagonalHeader";
    static final String DH_COL = "Col";
    static final String DH_ROW2 = "Row2";
    static final String DH_COL2 = "Col2";
    static final String ROWOFFERS = "RowOffers";
    static final String COLOFFERS = "ColOffers";
    static final String XOFFERS = "xOffers";
    static final String YOFFERS = "yOffers";
    static final String TRIANGLE = "Triangle";
    static final String LEAN = "Lean";
    static final String ZOOM = "Zoom";
    static final String DRAWBACK = "DrawBack";
    static final String POSITION = "Position";
    static final String LINESTYLE = "LineStyle";
    static final String WEIGHT = "Weight";
    static final String ROW = "Row";
    static final String STYLEID = "StyleID";
    static final String INDEX = "Index";
    static final String Data_String = "String";
    static final String TRUEVALUE = "True";
    static final String FALSEVALUE = "False";

    public static AbstractTableSplitRectInfo fromXml(IXmlElement dhe, Map styles) {
        Integer position = Integer.valueOf(dhe.getAttribute(POSITION));
        int row = Integer.parseInt(dhe.getAttribute(ROW));
        int col = Integer.parseInt(dhe.getAttribute(DH_COL));
        int row2 = Integer.parseInt(dhe.getAttribute(DH_ROW2));
        int col2 = Integer.parseInt(dhe.getAttribute(DH_COL2));
        int[] rowOffers = new int[]{};
        int[] colOffers = new int[]{};
        if (dhe.getAttribute(ROWOFFERS) != null) {
            rowOffers = TableSplitRectInfoXml.arrayToInt(dhe.getAttribute(ROWOFFERS));
        }
        if (dhe.getAttribute(COLOFFERS) != null) {
            colOffers = TableSplitRectInfoXml.arrayToInt(dhe.getAttribute(COLOFFERS));
        }
        TableSplitRectInfo info = new TableSplitRectInfo(row, col, row2, col2, position, rowOffers, colOffers);
        double[] xOffers = new double[]{};
        double[] yOffers = new double[]{};
        if (dhe.getAttribute(XOFFERS) != null) {
            xOffers = TableSplitRectInfoXml.arrayToDouble(dhe.getAttribute(XOFFERS));
        }
        if (dhe.getAttribute(YOFFERS) != null) {
            yOffers = TableSplitRectInfoXml.arrayToDouble(dhe.getAttribute(YOFFERS));
        }
        info.setXSplitOffs(xOffers);
        info.setYSplitOffs(yOffers);
        List children = dhe.searchChildren(TRIANGLE);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            IXmlElement triangle = (IXmlElement)children.get(i);
            TableSplitRectInfoXml.fromTriangle(info, triangle, styles);
        }
        return info;
    }

    private static double[] arrayToDouble(String attributeValue) {
        StringTokenizer strToken = new StringTokenizer(attributeValue, ",");
        double[] arrayInts = new double[strToken.countTokens()];
        int i = 0;
        while (strToken.hasMoreTokens()) {
            arrayInts[i] = Double.parseDouble(strToken.nextToken());
            ++i;
        }
        return arrayInts;
    }

    private static int[] arrayToInt(String attributeValue) {
        StringTokenizer strToken = new StringTokenizer(attributeValue, ",");
        int[] arrayInts = new int[strToken.countTokens()];
        int i = 0;
        while (strToken.hasMoreTokens()) {
            arrayInts[i] = Integer.parseInt(strToken.nextToken());
            ++i;
        }
        return arrayInts;
    }

    public static IXmlElement toXml(AbstractTableSplitRectInfo dh, List styles) {
        double[] yOffs;
        double[] xOffs;
        int[] colOffs;
        IXmlElement dhe = XmlUtil.createNode((String)DIAGONALHEADER);
        dhe.setAttribute(POSITION, dh.getPosition().toString());
        dhe.setAttribute(ROW, String.valueOf(dh.getRow()));
        dhe.setAttribute(DH_COL, String.valueOf(dh.getCol()));
        dhe.setAttribute(DH_ROW2, String.valueOf(dh.getRow2()));
        dhe.setAttribute(DH_COL2, String.valueOf(dh.getCol2()));
        int[] rowOffs = dh.getRowOffs();
        if (rowOffs != null && rowOffs.length > 0) {
            dhe.setAttribute(ROWOFFERS, StringUtil.array2String((int[])rowOffs, (String)","));
        }
        if ((colOffs = dh.getColOffs()) != null && colOffs.length > 0) {
            dhe.setAttribute(COLOFFERS, StringUtil.array2String((int[])colOffs, (String)","));
        }
        if ((xOffs = dh.getXSplitOffs()) != null && xOffs.length > 0) {
            dhe.setAttribute(XOFFERS, StringUtil.array2String((double[])xOffs, (String)","));
        }
        if ((yOffs = dh.getYSplitOffs()) != null && yOffs.length > 0) {
            dhe.setAttribute(YOFFERS, StringUtil.array2String((double[])yOffs, (String)","));
        }
        int size = dh.size();
        for (int i = 0; i < size; ++i) {
            TableSplitRectInfoXml.buildTraingleInfoElement(dh, i, dhe, styles);
        }
        return dhe;
    }

    private static void fromTriangle(TableSplitRectInfo info, IXmlElement triangle, Map styles) {
        int index = Integer.parseInt(triangle.getAttribute(INDEX));
        TriangleInfo tri = info.getTriangleInfo(index);
        String styleID = triangle.getAttribute(STYLEID);
        if (styleID != null) {
            tri.setStyle((Style)styles.get(styleID));
        }
        tri.setText(triangle.getAttribute(Data_String));
        tri.setLean(triangle.getAttribute(LEAN).equals(TRUEVALUE));
        tri.setAutoZoom(triangle.getAttribute(ZOOM).equals(TRUEVALUE));
        tri.setDrawBackground(triangle.getAttribute(DRAWBACK).equals(TRUEVALUE));
    }

    private static void buildTraingleInfoElement(AbstractTableSplitRectInfo dh, int index, IXmlElement pElement, List styles) {
        IXmlElement te = XmlUtil.createNode((String)TRIANGLE);
        TriangleInfo ti = dh.getTriangleInfo(index);
        Style ssa = ti.getStyle();
        if (ssa != null && !ssa.isEmpty()) {
            te.setAttribute(STYLEID, "" + ssa.getUID());
            styles.add(ssa);
        }
        te.setAttribute(INDEX, String.valueOf(index));
        te.setAttribute(Data_String, ti.getText());
        te.setAttribute(LEAN, ti.isLean() ? TRUEVALUE : FALSEVALUE);
        te.setAttribute(ZOOM, ti.isAutoZoom() ? TRUEVALUE : FALSEVALUE);
        te.setAttribute(DRAWBACK, ti.isDrawBackground() ? TRUEVALUE : FALSEVALUE);
        pElement.addChild(te);
    }
}

