/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style;

import com.kingdee.cosmic.ctrl.kdf.util.style.Border;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Rect;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributesChangeEvent;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributesChangeListener;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;

public class StyleAttributes
extends ShareStyleAttributes {
    private Object _owner;
    private StyleAttributesChangeListener _listener;
    protected long _mixedBits;

    protected StyleAttributes() {
    }

    protected StyleAttributes(ShareStyleAttributes ssa) {
        super(ssa);
    }

    protected StyleAttributes(StyleAttributes sa) {
        super(sa);
        this._mixedBits = sa._mixedBits;
    }

    public Object getOwner() {
        return this._owner;
    }

    public void setOwner(Object owner) {
        this._owner = owner;
    }

    public StyleAttributesChangeListener getListener() {
        return this._listener;
    }

    public void setListener(StyleAttributesChangeListener listener) {
        this._listener = listener;
    }

    public void update() {
        if (this._owner != null && this._listener != null && this.isDirty()) {
            this._listener.changeStyleAttributes(new StyleAttributesChangeEvent(this._owner, this));
            this.clearDirtyFlag();
        }
    }

    public void setFont(ShareStyleAttributes ssa) {
        Object owner = this._owner;
        this._owner = null;
        if (ssa.hasAttributes(FONT_NAME)) {
            this.setFontName(ssa.getFontName());
        }
        if (ssa.hasAttributes(FONT_ITALIC)) {
            this.setItalic(ssa.isItalic());
        }
        if (ssa.hasAttributes(FONT_UNDERLINE)) {
            this.setUnderline(ssa.isUnderline());
        }
        if (ssa.hasAttributes(FONT_BOLD)) {
            this.setBold(ssa.isBold());
        }
        if (ssa.hasAttributes(FONT_SIZE)) {
            this.setFontSize(ssa.getFontSize());
        }
        if (ssa.hasAttributes(FONT_WEIGHT)) {
            this.setWeight(ssa.getWeight());
        }
        if (ssa.hasAttributes(FONT_STRIKETHROUGH)) {
            this.setStrikeThrough(ssa.isStrikeThrough());
        }
        if (ssa.hasAttributes(FONT_COLOR)) {
            this.setFontColor(ssa.getFontColor());
        }
        this._owner = owner;
        this.update();
    }

    public void setFont(Font awtFont) {
        this.setFontName(awtFont.getFontName());
        this.setFontSize(awtFont.getSize());
        this.setBold(awtFont.isBold());
        this.setItalic(awtFont.isItalic());
    }

    public void setProtection(ShareStyleAttributes ssa) {
        Object owner = this._owner;
        this._owner = null;
        if (ssa.hasAttributes(PROTECTION_HIDDED)) {
            this.setHided(ssa.isHided());
        }
        if (ssa.hasAttributes(PROTECTION_LOCKED)) {
            this.setLocked(ssa.isLocked());
        }
        this._owner = owner;
        this.update();
    }

    public void setInterior(ShareStyleAttributes ssa) {
        Object owner = this._owner;
        this._owner = null;
        if (ssa.hasAttributes(BACKGROUND_COLOR)) {
            this.setBackground(ssa.getBackground());
        }
        if (ssa.hasAttributes(PATTERN)) {
            this.setPattern(ssa.getPattern());
        }
        if (ssa.hasAttributes(PATTERN_COLOR)) {
            this.setPatternColor(ssa.getPatternColor());
        }
        this._owner = owner;
        this.update();
    }

    public void setAlignment(ShareStyleAttributes ssa) {
        Object owner = this._owner;
        this._owner = null;
        if (ssa.hasAttributes(HORIZONTAL_ALIGN)) {
            this.setHorizontalAlign(ssa.getHorizontalAlign());
        }
        if (ssa.hasAttributes(VERTICAL_ALIGN)) {
            this.setVerticalAlign(ssa.getVerticalAlign());
        }
        if (ssa.hasAttributes(LINE_SPACING)) {
            this.setLinespacing(ssa.getLinespacing());
        }
        if (ssa.hasAttributes(WORD_SPACING)) {
            this.setWordspacing(ssa.getWordspacing());
        }
        if (ssa.hasAttributes(ROTATION)) {
            this.setRotation(ssa.getRotation());
        }
        if (ssa.hasAttributes(SHRINK_TEXT)) {
            this.setShrinkText(ssa.isShrinkText());
        }
        if (ssa.hasAttributes(WRAP_TEXT)) {
            this.setWrapText(ssa.isWrapText());
        }
        this._owner = owner;
        this.update();
    }

    public void setBorder(ShareStyleAttributes ssa) {
        Object owner = this._owner;
        this._owner = null;
        this.setBorder(Styles.Position.LEFT, ssa);
        this.setBorder(Styles.Position.TOP, ssa);
        this.setBorder(Styles.Position.RIGHT, ssa);
        this.setBorder(Styles.Position.BOTTOM, ssa);
        this.setBorder(Styles.Position.DIAGONALRIGHT, ssa);
        this.setBorder(Styles.Position.DIAGONALLEFT, ssa);
        this._owner = owner;
        this.update();
    }

    public void setBorder(Styles.Position pos, ShareStyleAttributes ssa) {
        Object owner = this._owner;
        this._owner = null;
        if (ssa.hasAttributes(StyleAttributes.getBorderPenStyleIndex(pos))) {
            this.setBorderPenStyle(pos, ssa.getBorderPenStyle(pos));
        }
        if (ssa.hasAttributes(StyleAttributes.getBorderLineStyleIndex(pos))) {
            this.setBorderLineStyle(pos, ssa.getBorderLineStyle(pos));
        }
        if (ssa.hasAttributes(StyleAttributes.getBorderColorIndex(pos))) {
            this.setBorderColor(pos, ssa.getBorderColor(pos));
        }
        this._owner = owner;
        this.update();
    }

    public void setBorder(Border bdr) {
        this.setBorder(bdr, bdr.getPosition());
    }

    public void setBorder(Border bdr, Styles.Position pos) {
        Object owner = this._owner;
        this._owner = null;
        this.setBorderPenStyle(pos, bdr.getPenStyle());
        this.setBorderLineStyle(pos, bdr.getLineStyle());
        this.setBorderColor(pos, bdr.getColor());
        this._owner = owner;
        this.update();
    }

    public void put(int index, Object attr) {
        if (index >= ATTRS_COUNT || index < 0) {
            throw new IllegalArgumentException();
        }
        this._put(index, attr);
    }

    public void put(String id, Object attr) {
        this._put(this.getIndex(id), attr);
    }

    int _put(int index, Object newAttr) {
        int ret = 0;
        Object oriObj = this._attrs[index];
        if (oriObj == null) {
            if (newAttr != null) {
                this._attrs[index] = newAttr;
                long bit = 1L << index;
                this._attrsBits |= bit;
                this.setDirty(bit);
                ret = 1;
            }
        } else if (!oriObj.equals(newAttr)) {
            this._attrs[index] = newAttr;
            long bit = 1L << index;
            if (newAttr == null) {
                this._attrsBits ^= bit;
            }
            this.setDirty(bit);
            ret = 1;
        }
        this.update();
        return ret;
    }

    public int putMix(int index, Object newAttr) {
        long bit = 0L;
        Object oriObj = this._attrs[index];
        if (oriObj == null) {
            if (newAttr != null) {
                this._attrs[index] = newAttr;
                bit = 1L << index;
                this._attrsBits |= bit;
                this.setDirty(bit);
                return 1;
            }
        } else if (newAttr != null && !oriObj.equals(newAttr)) {
            this._attrs[index] = UNKOWN_VALUE;
            bit = 1L << index;
            this.setDirty(bit);
            this._mixedBits |= bit;
            return 2;
        }
        return 0;
    }

    public boolean isMixedAttribute(int index) {
        return (this._mixedBits & 1L << index) != 0L;
    }

    public boolean isEntireMixedBorder(Styles.Position pos) {
        return this.isAllMixed(StyleAttributes.getBorderBits(pos));
    }

    public boolean isAllMixed(long bits) {
        return (this._mixedBits & bits) == bits;
    }

    public int append(ShareStyleAttributes ssa, boolean bChangeDirtyFlag) {
        return this.append(ssa, bChangeDirtyFlag, this.count());
    }

    public int append(ShareStyleAttributes ssa, boolean bChangeDirtyFlag, int count) {
        if (ssa._attrsBits == 0L || this.isFull(StyleAttributes.getAllBits(count))) {
            return 0;
        }
        int append = 0;
        for (int i = 0; i < count; ++i) {
            if (!this.appendAttribute(ssa, i, bChangeDirtyFlag)) continue;
            ++append;
        }
        this.update();
        return append;
    }

    public boolean appendAttribute(ShareStyleAttributes ssa, int index, boolean bChangeDirtyFlag) {
        Object obj = ssa._attrs[index];
        if (obj != null && obj != UNKOWN_VALUE && this._attrs[index] == null) {
            this._attrs[index] = obj;
            long bit = 1L << index;
            this._attrsBits |= bit;
            if (bChangeDirtyFlag) {
                this.setDirty(bit);
            }
            return true;
        }
        return false;
    }

    public int appendAll(ShareStyleAttributes ssa, boolean bChangeDirtyFlag, int count) {
        if (ssa._attrsBits == 0L || this.isFull(StyleAttributes.getAllBits(count))) {
            return 0;
        }
        int append = 0;
        for (int i = 0; i < count; ++i) {
            Object newAttr = ssa._attrs[i];
            if (newAttr == null || this._attrs[i] != null) continue;
            this._attrs[i] = newAttr;
            long bit = 1L << i;
            this._attrsBits |= bit;
            if (bChangeDirtyFlag) {
                this.setDirty(bit);
            }
            if (newAttr == UNKOWN_VALUE) {
                this._mixedBits |= bit;
            }
            ++append;
        }
        this.update();
        return append;
    }

    public int appendBorderAttributes(ShareStyleAttributes ssa, Styles.Position posSrc, Styles.Position posDst) {
        int count = 0;
        int index = StyleAttributes.getBorderLineStyleIndex(posDst);
        if (!this.hasAttributes(index)) {
            count += this._put(index, ssa._get(StyleAttributes.getBorderLineStyleIndex(posSrc)));
        }
        if (!this.hasAttributes(index = StyleAttributes.getBorderPenStyleIndex(posDst))) {
            count += this._put(index, ssa._get(StyleAttributes.getBorderPenStyleIndex(posSrc)));
        }
        if (!this.hasAttributes(index = StyleAttributes.getBorderColorIndex(posDst))) {
            count += this._put(index, ssa._get(StyleAttributes.getBorderColorIndex(posSrc)));
        }
        return count;
    }

    public boolean copyBorderAttributes(ShareStyleAttributes ssa, Styles.Position posSrc, Styles.Position posDst) {
        if (posSrc == posDst) {
            int index = StyleAttributes.getBorderLineStyleIndex(posSrc);
            this._attrs[index] = ssa._attrs[index];
            index = StyleAttributes.getBorderPenStyleIndex(posSrc);
            this._attrs[index] = ssa._attrs[index];
            index = StyleAttributes.getBorderColorIndex(posSrc);
            this._attrs[index] = ssa._attrs[index];
            long borderBits = StyleAttributes.getBorderBits(posSrc);
            this._attrsBits &= borderBits ^ 0xFFFFFFFFFFFFFFFFL;
            this._attrsBits |= ssa._attrsBits & borderBits;
            this._dirtyBits &= borderBits ^ 0xFFFFFFFFFFFFFFFFL;
            this._dirtyBits |= ssa._dirtyBits & borderBits;
            if (ssa instanceof StyleAttributes) {
                StyleAttributes sa = (StyleAttributes)ssa;
                this._mixedBits &= borderBits ^ 0xFFFFFFFFFFFFFFFFL;
                this._mixedBits |= sa._mixedBits & borderBits;
            }
        } else {
            int indexDst = StyleAttributes.getBorderLineStyleIndex(posDst);
            int indexSrc = StyleAttributes.getBorderLineStyleIndex(posSrc);
            this._attrs[indexDst] = ssa._attrs[indexSrc];
            this._attrs[StyleAttributes.getBorderPenStyleIndex((Styles.Position)posDst)] = ssa._attrs[StyleAttributes.getBorderPenStyleIndex(posSrc)];
            this._attrs[StyleAttributes.getBorderColorIndex((Styles.Position)posDst)] = ssa._attrs[StyleAttributes.getBorderColorIndex(posSrc)];
            long dstBorderBits = StyleAttributes.getBorderBits(posDst);
            long srcBorderBits = StyleAttributes.getBorderBits(posSrc);
            this._attrsBits &= dstBorderBits ^ 0xFFFFFFFFFFFFFFFFL;
            this._attrsBits |= (ssa._attrsBits & srcBorderBits) >> indexSrc << indexDst;
            this._dirtyBits &= dstBorderBits ^ 0xFFFFFFFFFFFFFFFFL;
            this._dirtyBits |= (ssa._dirtyBits & srcBorderBits) >> indexSrc << indexDst;
            if (ssa instanceof StyleAttributes) {
                StyleAttributes sa = (StyleAttributes)ssa;
                this._mixedBits &= dstBorderBits ^ 0xFFFFFFFFFFFFFFFFL;
                this._mixedBits |= (sa._mixedBits & srcBorderBits) >> indexSrc << indexDst;
            }
        }
        return true;
    }

    public int replaceDirty(ShareStyleAttributes ssa) {
        return this.replaceDirty(ssa, 0, this.count() - 1, true);
    }

    public int replaceDirty(ShareStyleAttributes ssa, int from, int to) {
        return this.replaceDirty(ssa, from, to, true);
    }

    public int replaceDirty(ShareStyleAttributes ssa, boolean replaceNull) {
        return this.replaceDirty(ssa, 0, this.count() - 1, replaceNull);
    }

    private int replaceDirty(ShareStyleAttributes ssa, int from, int to, boolean replaceNull) {
        if (!ssa.isDirty()) {
            return 0;
        }
        int count = 0;
        for (int i = from; i <= to; ++i) {
            if (!this.replaceDirtyAttribute(ssa, i, replaceNull)) continue;
            ++count;
        }
        this.update();
        return count;
    }

    public int replaceDirty(ShareStyleAttributes ssa, ShareStyleAttributes referSSA) {
        if (!ssa.isDirty()) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.count(); ++i) {
            if (!this.replaceDirtyAttribute(ssa, i, referSSA)) continue;
            ++count;
        }
        this.update();
        return count;
    }

    public boolean replaceDirtyAttribute(ShareStyleAttributes ssa, int i) {
        return this.replaceDirtyAttribute(ssa, i, true);
    }

    public boolean replaceDirtyAttribute(ShareStyleAttributes ssa, int i, boolean replaceNull) {
        Object newAttr;
        if (ssa.isDirtyAttribute(i) && (newAttr = ssa._attrs[i]) != UNKOWN_VALUE) {
            Object oldAttr = this._attrs[i];
            if (oldAttr == null) {
                if (replaceNull) {
                    this._attrs[i] = newAttr;
                    long bit = 1L << i;
                    this._attrsBits = newAttr != null ? (this._attrsBits |= bit) : (this._attrsBits &= bit ^ 0xFFFFFFFFFFFFFFFFL);
                    this.setDirty(bit);
                    return true;
                }
            } else if (!oldAttr.equals(newAttr)) {
                this._attrs[i] = newAttr;
                long bit = 1L << i;
                this._attrsBits = newAttr != null ? (this._attrsBits |= bit) : (this._attrsBits &= bit ^ 0xFFFFFFFFFFFFFFFFL);
                this.setDirty(bit);
                return true;
            }
        }
        return false;
    }

    public boolean replaceDirtyAttribute(ShareStyleAttributes ssa, int i, ShareStyleAttributes referSSA) {
        Object newAttr;
        if (ssa.isDirtyAttribute(i) && (newAttr = ssa._attrs[i]) != UNKOWN_VALUE) {
            Object oldAttr = this._attrs[i];
            if (oldAttr == null) {
                if (newAttr != null && referSSA != null && referSSA._attrs[i] != null && !newAttr.equals(referSSA._attrs[i])) {
                    this._attrs[i] = newAttr;
                    long bit = 1L << i;
                    this._attrsBits |= bit;
                    this.setDirty(bit);
                    return true;
                }
            } else if (!oldAttr.equals(newAttr)) {
                this._attrs[i] = newAttr;
                long bit = 1L << i;
                if (newAttr != null) {
                    this._attrsBits |= bit;
                }
                this.setDirty(bit);
                return true;
            }
        }
        return false;
    }

    public int replaceDirtyBorder(ShareStyleAttributes ssa, Styles.Position pos) {
        int count = 0;
        if (this.replaceDirtyAttribute(ssa, StyleAttributes.getBorderPenStyleIndex(pos))) {
            ++count;
        }
        if (this.replaceDirtyAttribute(ssa, StyleAttributes.getBorderLineStyleIndex(pos))) {
            ++count;
        }
        if (this.replaceDirtyAttribute(ssa, StyleAttributes.getBorderColorIndex(pos))) {
            ++count;
        }
        return count;
    }

    public int replaceDirtyBorder(ShareStyleAttributes ssa, Styles.Position posFrom, Styles.Position posTo) {
        int count = 0;
        int index = StyleAttributes.getBorderLineStyleIndex(posFrom);
        if (ssa.isDirtyAttribute(index)) {
            count += this._put(StyleAttributes.getBorderLineStyleIndex(posTo), ssa._get(index));
        }
        if (ssa.isDirtyAttribute(index = StyleAttributes.getBorderPenStyleIndex(posFrom))) {
            count += this._put(StyleAttributes.getBorderPenStyleIndex(posTo), ssa._get(index));
        }
        if (ssa.isDirtyAttribute(index = StyleAttributes.getBorderColorIndex(posFrom))) {
            count += this._put(StyleAttributes.getBorderColorIndex(posTo), ssa._get(index));
        }
        return count;
    }

    public int replace(ShareStyleAttributes ssa) {
        if (ssa == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.count(); ++i) {
            Object oldAttr;
            Object newAttr = ssa._attrs[i];
            if (newAttr == null || newAttr == UNKOWN_VALUE || (oldAttr = this._attrs[i]) != null && oldAttr.equals(newAttr)) continue;
            this._attrs[i] = newAttr;
            long bit = 1L << i;
            this._attrsBits |= bit;
            this.setDirty(bit);
            ++count;
        }
        this.update();
        return count;
    }

    public int replace(ShareStyleAttributes ssa, long bits) {
        if (ssa == null) {
            return 0;
        }
        int count = 0;
        long bit = 1L;
        for (int i = 0; i < this.count(); ++i) {
            Object newAttr;
            if ((bits & bit) != 0L && (newAttr = ssa._attrs[i]) != null && newAttr != UNKOWN_VALUE) {
                this._attrs[i] = newAttr;
                this._attrsBits |= bit;
                this.setDirty(bit);
                ++count;
            }
            bit <<= 1;
        }
        this.update();
        return count;
    }

    public int mix(ShareStyleAttributes ssa, boolean bExceptBorder) {
        if (ssa == null) {
            return 0;
        }
        int mixed = 0;
        int count = bExceptBorder ? BORDER_START : this.count();
        for (int i = 0; i < count; ++i) {
            if (this.isMixedAttribute(i) || this.putMix(i, ssa._get(i)) <= 1) continue;
            ++mixed;
        }
        return mixed;
    }

    public int mix(ShareStyleAttributes[] aSSA, boolean bExceptBorder) {
        if (aSSA == null || aSSA.length == 0) {
            return 0;
        }
        int mixed = 0;
        int count = bExceptBorder ? BORDER_START : this.count();
        block0: for (int i = 0; i < count; ++i) {
            if (this.isMixedAttribute(i)) continue;
            for (int j = 0; j < aSSA.length; ++j) {
                if (this.putMix(i, aSSA[j]._get(i)) <= 1) continue;
                ++mixed;
                continue block0;
            }
        }
        return mixed;
    }

    public void clearBorderAttribures() {
        Arrays.fill(this._attrs, BORDER_START, ATTRS_COUNT, null);
        long bitsKeep = _allBorderBits ^ 0xFFFFFFFFFFFFFFFFL;
        this._attrsBits &= bitsKeep;
        this._dirtyBits &= bitsKeep;
        this._mixedBits &= bitsKeep;
    }

    public void clearBorderAttribures(Styles.Position pos, boolean setDirty) {
        Arrays.fill(this._attrs, StyleAttributes.getBorderLineStyleIndex(pos), StyleAttributes.getBorderColorIndex(pos) + 1, null);
        long borderBits = StyleAttributes.getBorderBits(pos);
        this._attrsBits &= borderBits ^ 0xFFFFFFFFFFFFFFFFL;
        this._dirtyBits = setDirty ? (this._dirtyBits |= borderBits) : (this._dirtyBits &= borderBits ^ 0xFFFFFFFFFFFFFFFFL);
        this._mixedBits &= borderBits ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void clearAttributes() {
        if (this.isEmpty()) {
            return;
        }
        Arrays.fill(this._attrs, null);
        this._attrsBits = 0L;
        this._dirtyBits = 0L;
        this._mixedBits = 0L;
        this._listener = null;
        this._hashCode = -1;
    }

    public void clearAttributes(long bits) {
        if (this.isEmpty() || bits == 0L) {
            return;
        }
        long bit = 1L;
        int count = this.count();
        for (int i = 0; i < count; ++i) {
            if ((bits & bit) != 0L) {
                this._attrs[i] = null;
                this._attrsBits &= bit ^ 0xFFFFFFFFFFFFFFFFL;
                this._mixedBits &= bit ^ 0xFFFFFFFFFFFFFFFFL;
                this._dirtyBits |= bit;
                if (this._attrsBits == 0L) break;
            }
            bit <<= 1;
        }
        this._hashCode = -1;
    }

    public void validateBorderAttributes() {
        if (!this.hasBordersAttributes()) {
            return;
        }
        if (this._get(BORDER_LEFT_LINESTYLE) == LineStyle.NULL_LINE && this._get(BORDER_LEFT_PENSTYLE) == null && this._get(BORDER_LEFT_COLOR) == null) {
            this._put(BORDER_LEFT_LINESTYLE, null);
        }
        if (this._get(BORDER_TOP_LINESTYLE) == LineStyle.NULL_LINE && this._get(BORDER_TOP_PENSTYLE) == null && this._get(BORDER_TOP_COLOR) == null) {
            this._put(BORDER_TOP_LINESTYLE, null);
        }
        if (this._get(BORDER_RIGHT_LINESTYLE) == LineStyle.NULL_LINE && this._get(BORDER_RIGHT_PENSTYLE) == null && this._get(BORDER_RIGHT_COLOR) == null) {
            this._put(BORDER_RIGHT_LINESTYLE, null);
        }
        if (this._get(BORDER_BOTTOM_LINESTYLE) == LineStyle.NULL_LINE && this._get(BORDER_BOTTOM_PENSTYLE) == null && this._get(BORDER_BOTTOM_COLOR) == null) {
            this._put(BORDER_BOTTOM_LINESTYLE, null);
        }
    }

    public void setFontName(String name) {
        this._put(FONT_NAME, name);
    }

    public void setFontSize(int size) {
        this._put(FONT_SIZE, size);
    }

    public void setBold(boolean bBold) {
        this._put(FONT_BOLD, bBold);
    }

    public void setItalic(boolean bItalic) {
        this._put(FONT_ITALIC, bItalic);
    }

    public void setUnderline(boolean bUnderline) {
        this._put(FONT_UNDERLINE, bUnderline);
    }

    public void setStrikeThrough(boolean bStrikeThrough) {
        this._put(FONT_STRIKETHROUGH, bStrikeThrough);
    }

    public void setWeight(float weight) {
        this._put(FONT_WEIGHT, Float.valueOf(weight));
    }

    public void setFontColor(Color clr) {
        this._put(FONT_COLOR, clr);
    }

    public void setBackground(Color clr) {
        this._put(BACKGROUND_COLOR, clr);
        if (!Styles.isNullColor(clr)) {
            if (!this.hasAttributes(PATTERN) || this.getPattern() == Pattern.None) {
                this.setPattern(Pattern.Solid);
            }
            this.setDirty(1L << PATTERN);
        } else if (this.hasAttributes(PATTERN) && this.getPattern() != Pattern.None) {
            this.setPattern(Pattern.None);
        }
    }

    public void setPattern(Pattern ptn) {
        this._put(PATTERN, ptn);
    }

    public void setIndentation(int indentation) {
        this._put(AUTO_INDENTATION, indentation);
    }

    public void setPatternColor(Color clr) {
        this._put(PATTERN_COLOR, clr);
    }

    public void setHorizontalAlign(Styles.HorizontalAlignment hAlign) {
        this._put(HORIZONTAL_ALIGN, hAlign);
    }

    public void setVerticalAlign(Styles.VerticalAlignment vAlign) {
        this._put(VERTICAL_ALIGN, vAlign);
    }

    public void setWrapText(boolean bWrapText) {
        this._put(WRAP_TEXT, bWrapText);
    }

    public void setShrinkText(boolean bShrinkText) {
        this._put(SHRINK_TEXT, bShrinkText);
    }

    public void setVerticalText(boolean bVerticalText) {
        this._put(VERTICAL_TEXT, bVerticalText);
    }

    public void setClip(boolean bClip) {
        this._put(AUTO_CLIP, bClip);
    }

    public void setRotation(int rotation) {
        this._put(ROTATION, rotation % 91);
    }

    public void setLinespacing(float lineSpacing) {
        this._put(LINE_SPACING, Float.valueOf(lineSpacing));
    }

    public void setWordspacing(float wordSpacing) {
        this._put(WORD_SPACING, Float.valueOf(wordSpacing));
    }

    public void setPadding(Rect pad) {
        this._put(PADDING, pad);
    }

    public void setPadding(Styles.Dir dir, int pad) {
        Rect rc = (Rect)this._get(PADDING);
        if (rc == null || rc.get(dir) != pad) {
            rc = rc == null ? new Rect(0, 0, 0, 0) : rc.getCopy();
            rc.set(dir, pad);
            this._put(PADDING, rc);
        }
    }

    public void setLocked(boolean bLocked) {
        this._put(PROTECTION_LOCKED, bLocked);
    }

    public void setHided(boolean bHided) {
        this._put(PROTECTION_HIDDED, bHided);
    }

    public void setNumberFormat(String fmt) {
        this._put(NUMBER_FORMAT, fmt);
    }

    public void setBorderPenStyle(Styles.Position pos, PenStyle ps) {
        this._put(StyleAttributes.getBorderPenStyleIndex(pos), ps);
    }

    public void setBorderLineStyle(Styles.Position pos, LineStyle ls) {
        this._put(StyleAttributes.getBorderLineStyleIndex(pos), ls);
    }

    public void setBorderColor(Styles.Position pos, Color clr) {
        this._put(StyleAttributes.getBorderColorIndex(pos), clr);
    }
}

