/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.variant.WeakHashSet;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Rect;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Styles {
    private static final Color NULL_COLOR = new Color(255, 255, 255, 0);
    private static final Cache<ShareStyleAttributes, ShareStyleAttributes> _SSAs = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private static final Cache<ShareStyleAttributes, ShareStyleAttributes> _styles = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterAccess(30L, TimeUnit.MINUTES).build();
    private static int _uid = 0;
    private static final WeakHashSet _fonts = new WeakHashSet();
    private static final WeakHashSet _strokes = new WeakHashSet();
    private static ShareStyleAttributes _emptySSA = new ShareStyleAttributes();
    private static ShareStyleAttributes _defaultSSA;
    private static Style _defaultStyle;

    public static boolean isNullColor(Color clr) {
        return clr == null || clr.getAlpha() == 0;
    }

    public static Color getNullColor() {
        return NULL_COLOR;
    }

    public static StyleAttributes getSA(ShareStyleAttributes ssa) {
        return new StyleAttributes(ssa);
    }

    public static StyleAttributes getSA(StyleAttributes sa) {
        return new StyleAttributes(sa);
    }

    public static StyleAttributes getEmptySA() {
        return new StyleAttributes();
    }

    public static StyleAttributes getDefaultSA() {
        return Styles.getSA(_defaultSSA);
    }

    public static ShareStyleAttributes getEmptySSA() {
        return _emptySSA;
    }

    public static ShareStyleAttributes getDefaultSSA() {
        return _defaultSSA;
    }

    public static Style getDefaultStyle() {
        return _defaultStyle;
    }

    public static StyleAttributes mixSA(ShareStyleAttributes[] aSSA) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.mix(aSSA, false);
        return sa;
    }

    public static ShareStyleAttributes mergeSSA(ShareStyleAttributes[] aSSA) {
        if (aSSA == null || aSSA.length == 0) {
            return _emptySSA;
        }
        StyleAttributes sa = Styles.getSA(aSSA[0]);
        for (int i = 1; i < aSSA.length && !sa.isFull(); ++i) {
            sa.append(aSSA[i], false);
        }
        return Styles.getSSA(sa);
    }

    public static synchronized ShareStyleAttributes getSSA(StyleAttributes sa) {
        ShareStyleAttributes ssa;
        if (sa == null) {
            throw new IllegalArgumentException();
        }
        Object obj = _SSAs.getIfPresent((Object)sa);
        if (obj == null) {
            ssa = new ShareStyleAttributes(sa);
            ssa.setUID(Styles.getUID());
            _SSAs.put((Object)ssa, (Object)ssa);
        } else {
            ssa = (ShareStyleAttributes)obj;
        }
        return ssa;
    }

    public static synchronized Style getStyle(ShareStyleAttributes ssa) {
        Style stl;
        Object obj;
        if (!ssa.isFull()) {
            StyleAttributes sa = Styles.getSA(ssa);
            sa.append(_defaultSSA, false);
            ssa = sa;
        }
        if ((obj = _styles.getIfPresent((Object)ssa)) == null) {
            stl = new Style(ssa);
            stl.setUID(Styles.getUID());
            _styles.put((Object)stl, (Object)stl);
        } else {
            stl = (Style)obj;
        }
        return stl;
    }

    public static Style getStyle(ShareStyleAttributes[] aSSA) {
        ShareStyleAttributes ssa;
        if (aSSA == null || aSSA.length == 0) {
            ssa = _defaultSSA;
        } else {
            StyleAttributes sa = Styles.getSA(aSSA[0]);
            if (!sa.isFull()) {
                for (int i = 1; i < aSSA.length; ++i) {
                    ssa = aSSA[i];
                    if (ssa == null) continue;
                    sa.append(ssa, false);
                    if (sa.isFull()) break;
                }
            }
            if (!sa.isFull()) {
                sa.append(_defaultSSA, false);
            }
            ssa = sa;
        }
        return Styles.getStyle(ssa);
    }

    public static synchronized Style.KDFontShell getFontShell(String name, int style, int size) {
        Style.KDFontShell fs = new Style.KDFontShell(name, style, size);
        Object obj = _fonts.get((Object)fs);
        if (obj == null) {
            _fonts.addKey((Object)fs);
        } else {
            fs = (Style.KDFontShell)obj;
        }
        return fs;
    }

    public static synchronized Style.StrokeShell getStrokeShell(PenStyle ps, LineStyle ls) {
        Style.StrokeShell ss = new Style.StrokeShell(ps, ls);
        Object obj = _strokes.get((Object)ss);
        if (obj == null) {
            _strokes.addKey((Object)ss);
        } else {
            ss = (Style.StrokeShell)obj;
        }
        return ss;
    }

    public static int getSSACount() {
        return (int)_SSAs.size();
    }

    static Map<ShareStyleAttributes, ShareStyleAttributes> getSSAEntrySet() {
        return _SSAs.asMap();
    }

    public static HashMap getStaticContent() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ssas", _SSAs);
        map.put("styles", _styles);
        map.put("fonts", _fonts);
        map.put("strocks", _strokes);
        return map;
    }

    public static synchronized int getUID() {
        if (_uid == Integer.MAX_VALUE) {
            _uid = 0;
            for (Map.Entry e : _SSAs.asMap().entrySet()) {
                ((ShareStyleAttributes)e.getKey()).setUID(_uid++);
            }
            for (Map.Entry e : _styles.asMap().entrySet()) {
                ((ShareStyleAttributes)e.getKey()).setUID(_uid++);
            }
        }
        return _uid++;
    }

    static {
        _emptySSA.setUID(Styles.getUID());
        _SSAs.put((Object)_emptySSA, (Object)_emptySSA);
        StyleAttributes sa = new StyleAttributes();
        sa.setItalic(false);
        sa.setFontName(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"));
        sa.setUnderline(false);
        sa.setWeight(400.0f);
        sa.setBold(false);
        sa.setFontSize(9);
        sa.setStrikeThrough(false);
        sa.setFontColor(Color.black);
        sa.setNumberFormat("");
        sa.setHided(false);
        sa.setLocked(false);
        sa.setBackground(NULL_COLOR);
        sa.setPattern(Pattern.None);
        sa.setPatternColor(Color.black);
        sa.setHorizontalAlign(HorizontalAlignment.CENTER);
        sa.setRotation(0);
        sa.setLinespacing(0.0f);
        sa.setWordspacing(0.0f);
        sa.setPadding(new Rect(1, 1, 1, 1));
        sa.setShrinkText(false);
        sa.setWrapText(false);
        sa.setVerticalAlign(VerticalAlignment.MIDDLE);
        sa.setClip(true);
        sa.setVerticalText(false);
        sa.setBorderPenStyle(Position.RIGHT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Position.RIGHT, LineStyle.NULL_LINE);
        sa.setBorderColor(Position.RIGHT, Color.black);
        sa.setBorderPenStyle(Position.BOTTOM, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Position.BOTTOM, LineStyle.NULL_LINE);
        sa.setBorderColor(Position.BOTTOM, Color.black);
        sa.setBorderPenStyle(Position.LEFT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Position.LEFT, LineStyle.NULL_LINE);
        sa.setBorderColor(Position.LEFT, Color.black);
        sa.setBorderPenStyle(Position.TOP, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Position.TOP, LineStyle.NULL_LINE);
        sa.setBorderColor(Position.TOP, Color.black);
        sa.setBorderPenStyle(Position.DIAGONALRIGHT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Position.DIAGONALRIGHT, LineStyle.NULL_LINE);
        sa.setBorderColor(Position.DIAGONALRIGHT, Color.black);
        sa.setBorderPenStyle(Position.DIAGONALLEFT, PenStyle.PS_SOLID);
        sa.setBorderLineStyle(Position.DIAGONALLEFT, LineStyle.NULL_LINE);
        sa.setBorderColor(Position.DIAGONALLEFT, Color.black);
        sa.setIndentation(0);
        sa.clearDirtyFlag();
        _defaultSSA = Styles.getSSA(sa);
        _defaultStyle = Styles.getStyle(_defaultSSA);
    }

    public static class Dir {
        public static final int East = 1;
        public static final int South = 2;
        public static final int West = 4;
        public static final int North = 8;
        public static final int EastSouth = 3;
        public static final int EastNorth = 9;
        public static final int WestSouth = 6;
        public static final int WestNorth = 12;
        public static final int Left = 4;
        public static final int Top = 8;
        public static final int Right = 1;
        public static final int Bottom = 2;
        public static final Dir EAST = new Dir(1, "east");
        public static final Dir SOUTH = new Dir(2, "south");
        public static final Dir WEST = new Dir(4, "west");
        public static final Dir NORTH = new Dir(8, "north");
        public static final Dir EASTSOUTH = new Dir(3, "eastsouth");
        public static final Dir EASTNORTH = new Dir(9, "eastnorth");
        public static final Dir WESTSOUTH = new Dir(6, "westsouth");
        public static final Dir WESTNORTH = new Dir(12, "westnorth");
        public static final Dir LEFT = WEST;
        public static final Dir TOP = NORTH;
        public static final Dir RIGHT = EAST;
        public static final Dir BOTTOM = SOUTH;
        private static HashMap _map = new HashMap();
        private int _index;
        private String _name;

        public static Dir parse(String dir) {
            Object obj = _map.get(dir.toLowerCase());
            if (obj == null) {
                return EAST;
            }
            return (Dir)obj;
        }

        private Dir(int index, String name) {
            this._index = index;
            this._name = name;
        }

        public int getIndex() {
            return this._index;
        }

        public String getName() {
            return this._name;
        }

        public String toString() {
            return this._name;
        }

        public boolean isEast() {
            return (this._index & 1) != 0;
        }

        public boolean isWest() {
            return (this._index & 4) != 0;
        }

        public boolean isNorth() {
            return (this._index & 8) != 0;
        }

        public boolean isSouth() {
            return (this._index & 2) != 0;
        }

        static {
            _map.put(EAST.getName(), EAST);
            _map.put(SOUTH.getName(), SOUTH);
            _map.put(WEST.getName(), WEST);
            _map.put(NORTH.getName(), NORTH);
            _map.put(EASTSOUTH.getName(), EASTSOUTH);
            _map.put(EASTNORTH.getName(), EASTNORTH);
            _map.put(WESTSOUTH.getName(), WESTSOUTH);
            _map.put(WESTNORTH.getName(), WESTNORTH);
        }
    }

    public static class Position {
        public static final int Left = 0;
        public static final int Top = 1;
        public static final int Right = 2;
        public static final int Bottom = 3;
        public static final int DiagLeft = 4;
        public static final int DiagRight = 5;
        public static final Position LEFT = new Position(0, "left");
        public static final Position TOP = new Position(1, "top");
        public static final Position RIGHT = new Position(2, "right");
        public static final Position BOTTOM = new Position(3, "bottom");
        public static final Position DIAGONALLEFT = new Position(4, "diagonalleft");
        public static final Position DIAGONALRIGHT = new Position(5, "diagonalright");
        public static final Position INNER_H = TOP;
        public static final Position INNER_V = LEFT;
        private static HashMap _map = new HashMap();
        private int _index;
        private String _name;

        public static Position parse(String pos) {
            Object obj = _map.get(pos.toLowerCase());
            if (obj == null) {
                return LEFT;
            }
            return (Position)obj;
        }

        private Position(int index, String name) {
            this._index = index;
            this._name = name;
        }

        public int getIndex() {
            return this._index;
        }

        public String getName() {
            return this._name;
        }

        public Position getOpposite() {
            Position pos;
            switch (this._index) {
                case 0: {
                    pos = RIGHT;
                    break;
                }
                case 1: {
                    pos = BOTTOM;
                    break;
                }
                case 2: {
                    pos = LEFT;
                    break;
                }
                case 3: {
                    pos = TOP;
                    break;
                }
                case 4: {
                    pos = DIAGONALRIGHT;
                    break;
                }
                default: {
                    pos = DIAGONALLEFT;
                }
            }
            return pos;
        }

        public String toString() {
            return this._name;
        }

        static {
            _map.put(LEFT.getName(), LEFT);
            _map.put(TOP.getName(), TOP);
            _map.put(RIGHT.getName(), RIGHT);
            _map.put(BOTTOM.getName(), BOTTOM);
            _map.put(DIAGONALLEFT.getName(), DIAGONALLEFT);
            _map.put(DIAGONALRIGHT.getName(), DIAGONALRIGHT);
        }
    }

    public static class VerticalAlignment {
        public static final VerticalAlignment TOP = new VerticalAlignment(1);
        public static final VerticalAlignment MIDDLE = new VerticalAlignment(2);
        public static final VerticalAlignment BOTTOM = new VerticalAlignment(3);
        int _value;

        public static VerticalAlignment getAlignment(String str) {
            if (str.compareToIgnoreCase("top") == 0) {
                return TOP;
            }
            if (str.compareToIgnoreCase("middle") == 0) {
                return MIDDLE;
            }
            if (str.compareToIgnoreCase("bottom") == 0) {
                return BOTTOM;
            }
            return TOP;
        }

        public static VerticalAlignment getAlignment(int i) {
            switch (i) {
                case 1: {
                    return TOP;
                }
                case 2: {
                    return MIDDLE;
                }
                case 3: {
                    return BOTTOM;
                }
            }
            return TOP;
        }

        VerticalAlignment(int value) {
            this._value = value;
        }

        public String toString() {
            switch (this._value) {
                case 1: {
                    return "top";
                }
                case 2: {
                    return "middle";
                }
                case 3: {
                    return "bottom";
                }
            }
            return String.valueOf(this._value);
        }

        public int getValue() {
            return this._value;
        }
    }

    public static class HorizontalAlignment {
        public static final HorizontalAlignment NORMAL = new HorizontalAlignment(0);
        public static final HorizontalAlignment LEFT = new HorizontalAlignment(1);
        public static final HorizontalAlignment CENTER = new HorizontalAlignment(2);
        public static final HorizontalAlignment RIGHT = new HorizontalAlignment(3);
        private int _value;

        public static HorizontalAlignment getAlignment(String str) {
            if (str.compareToIgnoreCase("left") == 0) {
                return LEFT;
            }
            if (str.compareToIgnoreCase("center") == 0) {
                return CENTER;
            }
            if (str.compareToIgnoreCase("right") == 0) {
                return RIGHT;
            }
            return NORMAL;
        }

        public static HorizontalAlignment getAlignment(int i) {
            switch (i) {
                case 1: {
                    return LEFT;
                }
                case 2: {
                    return CENTER;
                }
                case 3: {
                    return RIGHT;
                }
            }
            return NORMAL;
        }

        HorizontalAlignment(int value) {
            this._value = value;
        }

        public String toString() {
            switch (this._value) {
                case 1: {
                    return "left";
                }
                case 2: {
                    return "center";
                }
                case 3: {
                    return "right";
                }
            }
            return String.valueOf(this._value);
        }

        public int getValue() {
            return this._value;
        }
    }
}

