/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.StyleDesignerUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.packing.IStylePane;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.model.ComboColorSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class InteriorPane
extends KDPanel
implements IStylePane {
    private static final Logger logger = LogUtil.getPackageLogger(InteriorPane.class);
    private static final long serialVersionUID = -5555058480611909002L;
    private StyleAttributes sa;
    private KDList lstPattern;
    private KDComboColor cbcPatternColor = new KDComboColor(1, true);
    private KDComboColor cbcBackground = new KDComboColor(1, true);
    private PreviewPanel panPreview = new PreviewPanel();
    private boolean flagIsShowValueFireMe = false;
    private HashMap mapStyle4Paint = new HashMap();

    public InteriorPane() {
        this.initCompoments();
        this.installCompoments();
        this.installListener();
        this.addUsedColorPersistence(this.cbcPatternColor);
        this.addUsedColorPersistence(this.cbcBackground);
    }

    @Override
    public void setSA(StyleAttributes sa) {
        this.flagIsShowValueFireMe = true;
        this.sa = sa;
        this.syncStyle4Paint();
        this.showValue();
        this.flagIsShowValueFireMe = false;
    }

    private void syncStyle4Paint() {
        StyleDesignerUtil.copyAttr(this.sa, StyleDesignerUtil.getSa4Paint(), StyleAttributes.PATTERN);
        StyleDesignerUtil.copyAttr(this.sa, StyleDesignerUtil.getSa4Paint(), StyleAttributes.PATTERN_COLOR);
        StyleDesignerUtil.copyAttr(this.sa, StyleDesignerUtil.getSa4Paint(), StyleAttributes.BACKGROUND_COLOR);
        StyleDesignerUtil.refreshStyle4Paint();
    }

    private void initCompoments() {
        this.cbcBackground.setSelectionModel((ColorSelectionModel)((Object)new BackgroundSelectionModel()));
        this.cbcBackground.setDefaultColor(KDComboColor.TRANSPARENTCOLOR);
        this.cbcBackground.setDefaultColorPrompt(this.getMLS("nonColor", "\u900f\u660e"));
        Object[] allPattern = new Pattern[49];
        StyleAttributes saTemp = Styles.getDefaultSA();
        saTemp.setBackground(new Color(204, 204, 204));
        saTemp.setPatternColor(Color.BLACK);
        for (int i = allPattern.length; i > 0; --i) {
            allPattern[i - 1] = Pattern.getPattern(i);
            saTemp.setPattern((Pattern)allPattern[i - 1]);
            this.mapStyle4Paint.put(allPattern[i - 1], Styles.getStyle(saTemp));
        }
        this.lstPattern = new KDList(allPattern);
        this.lstPattern.setCellRenderer((ListCellRenderer)new PatternListCellRenderer());
        this.lstPattern.setVisibleRowCount(7);
        this.lstPattern.setLayoutOrientation(2);
        this.panPreview.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), this.getMLS("titlePreview", CtrlCommonUIMessages.getMLS("titlePreview", "\u9884\u89c8"))));
        this.panPreview.setOpaque(false);
    }

    private void installCompoments() {
        KDScrollPane scpPattern = new KDScrollPane((Component)this.lstPattern);
        KDLabelContainer lbcBackground = new KDLabelContainer((JComponent)this.cbcBackground);
        lbcBackground.setBoundLabelText(this.getMLS("backgroundColor", "\u80cc\u666f\u989c\u8272"));
        lbcBackground.setBoundLabelAlignment(8);
        lbcBackground.setBoundLabelLength(20);
        KDLabelContainer lbcPattern = new KDLabelContainer((JComponent)scpPattern);
        lbcPattern.setBoundLabelText(this.getMLS("pattern", "\u80cc\u666f\u56fe\u6848"));
        lbcPattern.setBoundLabelAlignment(8);
        lbcPattern.setBoundLabelLength(20);
        KDLabelContainer lbcPatternColor = new KDLabelContainer((JComponent)this.cbcPatternColor);
        lbcPatternColor.setBoundLabelText(this.getMLS("patternColor", "\u56fe\u6848\u989c\u8272"));
        lbcPatternColor.setBoundLabelAlignment(8);
        lbcPatternColor.setBoundLabelLength(20);
        scpPattern.setBorder(null);
        this.add((Component)((Object)this.panPreview));
        this.add((Component)lbcBackground);
        this.add((Component)lbcPattern);
        this.add((Component)lbcPatternColor);
        this.setLayout(null);
        lbcBackground.setBounds(8, 8, 130, 41);
        lbcPatternColor.setBounds(8, 55, 130, 41);
        lbcPattern.setBounds(148, 8, 296, 274);
        this.panPreview.setBounds(8, 102, 132, 182);
    }

    public Dimension getPreferredSize() {
        return new Dimension(454, 290);
    }

    private void installListener() {
        ActionHandler actionHandler = new ActionHandler();
        this.lstPattern.addListSelectionListener((ListSelectionListener)actionHandler);
        this.cbcBackground.getSelectionModel().addChangeListener(actionHandler);
        this.cbcPatternColor.getSelectionModel().addChangeListener(actionHandler);
    }

    private void addUsedColorPersistence(KDComboColor cbc) {
        cbc.addUsedColorPersistence(new KDComboColor.IUsedColorPersistence(){

            public void save(LinkedList<Color> usedColorList) {
                IXmlElement root = XmlUtil.createNode((String)"UsedColors");
                IXmlElement UsedColor = XmlUtil.createNode((String)"UsedColor");
                StringBuilder colorsStr = new StringBuilder();
                for (Color color : usedColorList) {
                    colorsStr.append(color.getRGB()).append(",");
                }
                UsedColor.addCData(colorsStr.toString());
                root.addChild(UsedColor);
                String filePth = GlobalLocator.getInstance().getHomeDir() + "\\UsedColor.xml";
                try {
                    XmlUtil.saveFile((IXmlElement)root, (File)new File(FilenameUtils.normalize((String)filePth)));
                }
                catch (IOException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            }

            public LinkedList<Color> load() {
                String filePth = GlobalLocator.getInstance().getHomeDir() + File.separator + "UsedColor.xml";
                LinkedList<Color> usedColorList = new LinkedList<Color>();
                File f = new File(FilenameUtils.normalize((String)filePth));
                if (f.exists() && f.isFile()) {
                    try {
                        IXmlElement root = XmlUtil.loadRootElementFromFile((File)new File(FilenameUtils.normalize((String)filePth)));
                        if (root.getChild("UsedColor") != null && root.getChild("UsedColor").getText() != "") {
                            String colorStr = root.getChild("UsedColor").getText();
                            String[] color = colorStr.split(",");
                            for (int i = 0; i < color.length; ++i) {
                                if (!StringUtil.isNumber((String)color[i])) continue;
                                Color c = new Color(Integer.parseInt(color[i]));
                                usedColorList.add(c);
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                    catch (XmlParsingException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                }
                return usedColorList;
            }
        });
    }

    private void showValue() {
        if (this.sa.isUnsureValue(StyleAttributes.PATTERN_COLOR)) {
            this.cbcPatternColor.setColor(null);
        } else {
            this.cbcPatternColor.setColor(this.sa.getPatternColor());
        }
        if (this.sa.isUnsureValue(StyleAttributes.BACKGROUND_COLOR)) {
            this.cbcBackground.setColor(null);
        } else {
            this.cbcBackground.setColor(this.sa.getBackground());
        }
        if (this.sa.isUnsureValue(StyleAttributes.PATTERN) || this.sa.getPattern().equals(Pattern.None)) {
            this.lstPattern.setSelectedIndex(-1);
        } else {
            this.lstPattern.setSelectedValue((Object)this.sa.getPattern(), true);
        }
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlCommonUIMessages.getMLS(key, defaultValue);
    }

    public KDComboColor getCbcBackground() {
        return this.cbcBackground;
    }

    public KDComboColor getCbcPatternColor() {
        return this.cbcPatternColor;
    }

    private void repaintPreview() {
        this.syncStyle4Paint();
        this.panPreview.repaint();
    }

    private static class BackgroundSelectionModel
    extends ComboColorSelectionModel {
        private static final long serialVersionUID = 1L;

        private BackgroundSelectionModel() {
        }

        public void setSelectedColor(Color color) {
            boolean isNeedToFire = false;
            if (this.getSelectedColor() != null && this.getSelectedColor().equals(color)) {
                isNeedToFire = true;
            }
            super.setSelectedColor(color);
            if (isNeedToFire) {
                this.fireStateChanged();
            }
        }
    }

    private class PatternListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private Object value;

        private PatternListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.value = value;
            this.setPreferredSize(new Dimension(42, 36));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setOpaque(true);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (((Pattern)this.value).equals(Pattern.getPattern(0))) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            Paint paint = ((Style)InteriorPane.this.mapStyle4Paint.get(this.value)).getFillPaint();
            g2.setPaint(paint);
            g2.fillRect(4, 4, 34, 28);
        }
    }

    private class PreviewPanel
    extends KDPanel {
        private static final long serialVersionUID = 1L;

        public void paint(Graphics g) {
            super.paint(g);
            if (InteriorPane.this.sa.isUnsureValue(StyleAttributes.PATTERN) || InteriorPane.this.sa.isUnsureValue(StyleAttributes.PATTERN_COLOR) || InteriorPane.this.sa.isUnsureValue(StyleAttributes.BACKGROUND_COLOR)) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            int x = 10;
            int y = 20;
            int w = this.getWidth() - 22;
            int h = this.getHeight() - 32;
            if (InteriorPane.this.sa.getPattern().equals(Pattern.getPattern(0))) {
                g2.setBackground(this.getBackground());
                g2.clearRect(x, y, w, h);
            } else {
                Paint paint = StyleDesignerUtil.getStyle4Paint().getFillPaint();
                g2.setPaint(paint);
                g2.fillRect(x, y, w, h);
            }
            g2.setColor(Color.BLACK);
            g2.drawRect(x, y, w, h);
        }
    }

    private class ActionHandler
    implements ListSelectionListener,
    ChangeListener {
        private ActionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (InteriorPane.this.flagIsShowValueFireMe || e.getValueIsAdjusting()) {
                return;
            }
            if (e.getSource().equals(InteriorPane.this.lstPattern)) {
                Pattern pattern = (Pattern)InteriorPane.this.lstPattern.getSelectedValue();
                InteriorPane.this.sa.setPattern(pattern);
                InteriorPane.this.repaintPreview();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (InteriorPane.this.flagIsShowValueFireMe) {
                return;
            }
            if (e.getSource().equals(InteriorPane.this.cbcPatternColor.getSelectionModel())) {
                if (InteriorPane.this.cbcPatternColor.getColor() != null) {
                    InteriorPane.this.sa.setPatternColor(InteriorPane.this.cbcPatternColor.getColor());
                    InteriorPane.this.repaintPreview();
                }
            } else if (e.getSource().equals(InteriorPane.this.cbcBackground.getSelectionModel()) && InteriorPane.this.cbcBackground.getColor() != null) {
                InteriorPane.this.sa.setBackground(InteriorPane.this.cbcBackground.getColor());
                boolean tempFlag = InteriorPane.this.flagIsShowValueFireMe;
                InteriorPane.this.flagIsShowValueFireMe = true;
                if (InteriorPane.this.sa.isUnsureValue(StyleAttributes.PATTERN) || InteriorPane.this.sa.getPattern().equals(Pattern.None)) {
                    InteriorPane.this.lstPattern.setSelectedIndex(-1);
                } else {
                    InteriorPane.this.lstPattern.setSelectedValue((Object)InteriorPane.this.sa.getPattern(), true);
                }
                InteriorPane.this.flagIsShowValueFireMe = tempFlag;
                InteriorPane.this.repaintPreview();
            }
        }
    }
}

