/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.kdf.util.render.BorderRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.LineSupplyCtrl;
import com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner.packing.IStylePane;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LinePane
extends KDPanel
implements IStylePane {
    private static final long serialVersionUID = 1L;
    private StyleAttributes sa;
    private PreviewPanel panPreview;
    private LineSupplyCtrl panLineSupply;
    private boolean flagIsShowValueFireMe;
    private static StyleAttributes sa4Paint = Styles.getDefaultSA();
    private static Style style4Paint = Styles.getStyle(sa4Paint);

    public LinePane() {
        this.initCompoments();
        this.installCompoments();
        this.installListener();
    }

    @Override
    public void setSA(StyleAttributes sa) {
        this.flagIsShowValueFireMe = true;
        this.sa = sa;
        this.syncStyle4Paint();
        this.showValue();
        this.flagIsShowValueFireMe = false;
    }

    private void syncStyle4Paint() {
        sa4Paint.put(StyleAttributes.BORDER_TOP_COLOR, this.sa.get(StyleAttributes.BORDER_LEFT_COLOR));
        sa4Paint.put(StyleAttributes.BORDER_TOP_PENSTYLE, this.sa.get(StyleAttributes.BORDER_LEFT_PENSTYLE));
        sa4Paint.put(StyleAttributes.BORDER_TOP_LINESTYLE, this.sa.get(StyleAttributes.BORDER_LEFT_LINESTYLE));
        style4Paint = Styles.getStyle(sa4Paint);
    }

    private void initCompoments() {
        this.panPreview = new PreviewPanel();
        this.panPreview.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), this.getMLS("titlePreview", CtrlCommonUIMessages.getMLS("titlePreview", "\u9884\u89c8"))));
        this.panLineSupply = new LineSupplyCtrl();
    }

    private void installCompoments() {
        this.add((Component)((Object)this.panLineSupply));
        this.add((Component)((Object)this.panPreview));
        this.setLayout(null);
        this.panLineSupply.setBounds(8, 8, 150, 270);
        this.panPreview.setBounds(170, 8, 276, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(454, 288);
    }

    private void installListener() {
        ActionHandler actionHandler = new ActionHandler();
        this.panLineSupply.getCbcLineColor().getSelectionModel().addChangeListener(actionHandler);
        this.panLineSupply.getCmbPenStyle().addItemListener((ItemListener)actionHandler);
        this.panLineSupply.getLstLineStyle().addListSelectionListener((ListSelectionListener)actionHandler);
    }

    private void showValue() {
        this.panLineSupply.showValue(this.sa);
    }

    private String getMLS(String key, String defaultValue) {
        return CtrlCommonUIMessages.getMLS(key, defaultValue);
    }

    private void repaintPreview() {
        this.syncStyle4Paint();
        this.panPreview.repaint();
    }

    public KDComboColor getCbcLineColor() {
        return this.panLineSupply.getCbcLineColor();
    }

    private class PreviewPanel
    extends KDPanel {
        private static final long serialVersionUID = 1L;
        private BorderRender br = new BorderRender();
        private Rectangle rect;

        public PreviewPanel() {
            this.setOpaque(false);
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setColor(Color.WHITE);
            g.fillRect(10, 20, this.getWidth() - 20, this.getHeight() - 30);
            g.setColor(Color.BLACK);
            g.drawRect(10, 20, this.getWidth() - 20, this.getHeight() - 30);
            if (LinePane.this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_COLOR) || LinePane.this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_PENSTYLE) || LinePane.this.sa.isUnsureValue(StyleAttributes.BORDER_LEFT_LINESTYLE)) {
                return;
            }
            if (!LinePane.this.sa.getBorderLineStyle(Styles.Position.LEFT).equals(LineStyle.NULL_LINE)) {
                if (this.rect == null) {
                    this.rect = new Rectangle(30, this.getHeight() / 2 + 5, this.getWidth() - 60, 0);
                }
                this.br.draw((Graphics2D)g, this.rect, new BorderRender.BorderInfo(2), style4Paint);
            }
        }
    }

    private class ActionHandler
    implements ListSelectionListener,
    ChangeListener,
    ItemListener {
        private ActionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (LinePane.this.flagIsShowValueFireMe) {
                return;
            }
            if (e.getSource().equals(LinePane.this.panLineSupply.getLstLineStyle())) {
                if (LinePane.this.sa.getBorderLineStyle(Styles.Position.LEFT).equals(LineStyle.NULL_LINE)) {
                    LinePane.this.sa.setBorderColor(Styles.Position.LEFT, LinePane.this.panLineSupply.getLineColor());
                    LinePane.this.sa.setBorderPenStyle(Styles.Position.LEFT, LinePane.this.panLineSupply.getPenStyle());
                }
                LinePane.this.sa.setBorderLineStyle(Styles.Position.LEFT, LinePane.this.panLineSupply.getLineStyle());
                LinePane.this.repaintPreview();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (LinePane.this.flagIsShowValueFireMe) {
                return;
            }
            if (e.getSource().equals(LinePane.this.panLineSupply.getCbcLineColor().getSelectionModel())) {
                LinePane.this.sa.setBorderColor(Styles.Position.LEFT, LinePane.this.panLineSupply.getLineColor());
                LinePane.this.repaintPreview();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (LinePane.this.flagIsShowValueFireMe) {
                return;
            }
            if (e.getSource().equals(LinePane.this.panLineSupply.getCmbPenStyle())) {
                LinePane.this.sa.setBorderPenStyle(Styles.Position.LEFT, LinePane.this.panLineSupply.getPenStyle());
                LinePane.this.repaintPreview();
            }
        }
    }
}

