/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.style.styledesigner;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlParsingException;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.BorderRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class LineSupplyCtrl
extends KDPanel {
    private static final Logger logger = LogUtil.getPackageLogger(LineSupplyCtrl.class);
    private static final long serialVersionUID = 1L;
    private KDList lstLineStyle;
    private KDComboBox cmbPenStyle = new KDComboBox();
    private KDComboColor cbcLineColor = new KDComboColor(1, true);
    private HashMap mapLineStyle2SA = new HashMap();
    private HashMap mapLineStyle2Style = new HashMap();

    public LineSupplyCtrl() {
        this.init();
        this.installComponents();
        this.installListener();
        this.addUsedColorPersistence(this.cbcLineColor);
    }

    private void init() {
        Object[] penStyles = new PenStyle[]{PenStyle.PS_SOLID, PenStyle.PS_CONTINUOUS, PenStyle.PS_DOT, PenStyle.PS_DASHDOTDOT, PenStyle.PS_DASHDOT, PenStyle.PS_DASH};
        this.cmbPenStyle.addItems(penStyles);
        this.cmbPenStyle.setRenderer((ListCellRenderer)new PenStyleListCellRenderer());
        Object[] lineStyle = new LineStyle[]{LineStyle.SINGLE_LINE, LineStyle.DOUBLE_LINE_A, LineStyle.TRIGRAM_SOLID_LINE, LineStyle.TRIGRAM_HOLLOW_LINE, LineStyle.WIDTH4, LineStyle.WIDTH5, LineStyle.WIDTH6, LineStyle.WIDTH7, LineStyle.WIDTH8, LineStyle.WIDTH9, LineStyle.WIDTH10};
        this.lstLineStyle = new KDList(lineStyle);
        this.lstLineStyle.setCellRenderer((ListCellRenderer)new LineStyleListCellRenderer());
        this.lstLineStyle.setSelectedIndex(0);
        for (int i = 0; i < lineStyle.length; ++i) {
            StyleAttributes saTemp = Styles.getDefaultSA();
            saTemp.setBorderLineStyle(Styles.Position.TOP, (LineStyle)lineStyle[i]);
            Style styleTemp = Styles.getStyle(saTemp);
            this.mapLineStyle2SA.put(lineStyle[i], saTemp);
            this.mapLineStyle2Style.put(lineStyle[i], styleTemp);
        }
    }

    private void installComponents() {
        KDScrollPane scpLineStyle = new KDScrollPane((Component)this.lstLineStyle);
        scpLineStyle.setVerticalScrollBarPolicy(22);
        KDLabelContainer lbcLineStyle = new KDLabelContainer((JComponent)scpLineStyle);
        lbcLineStyle.setBoundLabelText(CtrlCommonUIMessages.getMLS("lineStyle", "\u7ebf\u578b"));
        lbcLineStyle.setBoundLabelAlignment(8);
        lbcLineStyle.setBoundLabelLength(17);
        KDLabelContainer lbcColor = new KDLabelContainer((JComponent)this.cbcLineColor);
        lbcColor.setBoundLabelText(CtrlCommonUIMessages.getMLS("color", "\u989c\u8272"));
        lbcColor.setBoundLabelAlignment(8);
        lbcColor.setBoundLabelLength(17);
        KDLabelContainer lbcPenStyle = new KDLabelContainer((JComponent)this.cmbPenStyle);
        lbcPenStyle.setBoundLabelText(CtrlCommonUIMessages.getMLS("penStyle", "\u7b14\u578b"));
        lbcPenStyle.setBoundLabelLength(17);
        lbcPenStyle.setBoundLabelAlignment(8);
        this.setLayout(null);
        this.setOpaque(false);
        this.add((Component)lbcLineStyle);
        this.add((Component)lbcColor);
        this.add((Component)lbcPenStyle);
        lbcColor.setBounds(10, 20, 130, 38);
        lbcPenStyle.setBounds(10, 62, 130, 36);
        lbcLineStyle.setBounds(8, 102, 134, 160);
        this.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), CtrlCommonUIMessages.getMLS("titleLine", CtrlCommonUIMessages.getMLS("titleLine", "\u7ebf\u6761"))));
    }

    private void installListener() {
        this.cmbPenStyle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    return;
                }
                LineSupplyCtrl.this.refreshLineStyle4Paint((PenStyle)LineSupplyCtrl.this.cmbPenStyle.getSelectedItem());
                LineSupplyCtrl.this.lstLineStyle.repaint();
            }
        });
    }

    private void refreshLineStyle4Paint(PenStyle ps) {
        for (int i = 0; i < this.lstLineStyle.getElementCount(); ++i) {
            LineStyle ls = (LineStyle)this.lstLineStyle.getElement(i);
            StyleAttributes sa = (StyleAttributes)this.mapLineStyle2SA.get(ls);
            sa.setBorderPenStyle(Styles.Position.TOP, ps);
            this.mapLineStyle2Style.put(ls, Styles.getStyle(sa));
        }
    }

    private void addUsedColorPersistence(KDComboColor cbc) {
        cbc.addUsedColorPersistence(new KDComboColor.IUsedColorPersistence(){

            public void save(LinkedList<Color> usedColorList) {
                IXmlElement root = XmlUtil.createNode((String)"UsedColors");
                IXmlElement UsedColor = XmlUtil.createNode((String)"UsedColor");
                StringBuilder colorsStr = new StringBuilder();
                for (Color color : usedColorList) {
                    colorsStr.append(color.getRGB()).append(",");
                }
                UsedColor.addCData(colorsStr.toString());
                root.addChild(UsedColor);
                String filePth = GlobalLocator.getInstance().getHomeDir() + "\\UsedColor.xml";
                try {
                    XmlUtil.saveFile((IXmlElement)root, (File)new File(FilenameUtils.normalize((String)filePth)));
                }
                catch (IOException e) {
                    logger.error((Object)"err", (Throwable)e);
                }
            }

            public LinkedList<Color> load() {
                String filePth = GlobalLocator.getInstance().getHomeDir() + File.separator + "UsedColor.xml";
                LinkedList<Color> usedColorList = new LinkedList<Color>();
                File f = new File(FilenameUtils.normalize((String)filePth));
                if (f.exists() && f.isFile()) {
                    try {
                        IXmlElement root = XmlUtil.loadRootElementFromFile((File)new File(FilenameUtils.normalize((String)filePth)));
                        if (root.getChild("UsedColor") != null && root.getChild("UsedColor").getText() != "") {
                            String colorStr = root.getChild("UsedColor").getText();
                            String[] color = colorStr.split(",");
                            for (int i = 0; i < color.length; ++i) {
                                if (!StringUtil.isNumber((String)color[i])) continue;
                                Color c = new Color(Integer.parseInt(color[i]));
                                usedColorList.add(c);
                            }
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                    catch (XmlParsingException e) {
                        logger.error((Object)"err", (Throwable)e);
                    }
                }
                return usedColorList;
            }
        });
    }

    public void showValue(StyleAttributes sa) {
        if (sa.isUnsureValue(StyleAttributes.BORDER_LEFT_COLOR)) {
            this.cbcLineColor.setColor(Color.BLACK);
        } else {
            this.cbcLineColor.setColor(sa.getBorderColor(Styles.Position.LEFT));
        }
        if (sa.isUnsureValue(StyleAttributes.BORDER_LEFT_PENSTYLE)) {
            this.cmbPenStyle.setSelectedIndex(0);
        } else {
            this.cmbPenStyle.setSelectedItem((Object)sa.getBorderPenStyle(Styles.Position.LEFT));
        }
        if (sa.isUnsureValue(StyleAttributes.BORDER_LEFT_LINESTYLE) || sa.getBorderLineStyle(Styles.Position.LEFT) == LineStyle.NULL_LINE) {
            this.lstLineStyle.setSelectedValue((Object)LineStyle.SINGLE_LINE, true);
        } else {
            this.lstLineStyle.setSelectedValue((Object)sa.getBorderLineStyle(Styles.Position.LEFT), true);
        }
    }

    public void showValue(StyleAttributes sa, Styles.Position position) {
        boolean linestyle;
        boolean penstyle;
        boolean color;
        if (Styles.Position.LEFT == position) {
            color = sa.isUnsureValue(StyleAttributes.BORDER_LEFT_COLOR);
            penstyle = sa.isUnsureValue(StyleAttributes.BORDER_LEFT_PENSTYLE);
            linestyle = sa.isUnsureValue(StyleAttributes.BORDER_LEFT_LINESTYLE) || sa.getBorderLineStyle(position) == LineStyle.NULL_LINE;
        } else if (Styles.Position.RIGHT == position) {
            color = sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_COLOR);
            penstyle = sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_PENSTYLE);
            linestyle = sa.isUnsureValue(StyleAttributes.BORDER_RIGHT_LINESTYLE) || sa.getBorderLineStyle(position) == LineStyle.NULL_LINE;
        } else if (Styles.Position.TOP == position) {
            color = sa.isUnsureValue(StyleAttributes.BORDER_TOP_COLOR);
            penstyle = sa.isUnsureValue(StyleAttributes.BORDER_TOP_PENSTYLE);
            linestyle = sa.isUnsureValue(StyleAttributes.BORDER_TOP_LINESTYLE) || sa.getBorderLineStyle(position) == LineStyle.NULL_LINE;
        } else if (Styles.Position.BOTTOM == position) {
            color = sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_COLOR);
            penstyle = sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_PENSTYLE);
            linestyle = sa.isUnsureValue(StyleAttributes.BORDER_BOTTOM_LINESTYLE) || sa.getBorderLineStyle(position) == LineStyle.NULL_LINE;
        } else if (Styles.Position.DIAGONALLEFT == position) {
            color = sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALLEFT_COLOR);
            penstyle = sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALLEFT_PENSTYLE);
            linestyle = sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALLEFT_LINESTYLE) || sa.getBorderLineStyle(position) == LineStyle.NULL_LINE;
        } else {
            color = sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALRIGHT_COLOR);
            penstyle = sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALRIGHT_PENSTYLE);
            boolean bl = linestyle = sa.isUnsureValue(StyleAttributes.BORDER_DIAGONALRIGHT_LINESTYLE) || sa.getBorderLineStyle(position) == LineStyle.NULL_LINE;
        }
        if (color) {
            this.cbcLineColor.setColor(Color.BLACK);
        } else {
            this.cbcLineColor.setColor(sa.getBorderColor(position));
        }
        if (penstyle) {
            this.cmbPenStyle.setSelectedIndex(0);
        } else {
            this.cmbPenStyle.setSelectedItem((Object)sa.getBorderPenStyle(position));
        }
        if (linestyle) {
            this.lstLineStyle.setSelectedValue((Object)LineStyle.SINGLE_LINE, true);
        } else {
            this.lstLineStyle.setSelectedValue((Object)sa.getBorderLineStyle(position), true);
        }
    }

    public Color getLineColor() {
        return this.cbcLineColor.getColor();
    }

    public PenStyle getPenStyle() {
        return (PenStyle)this.cmbPenStyle.getSelectedItem();
    }

    public LineStyle getLineStyle() {
        return (LineStyle)this.lstLineStyle.getSelectedValue();
    }

    public KDComboColor getCbcLineColor() {
        return this.cbcLineColor;
    }

    public KDComboBox getCmbPenStyle() {
        return this.cmbPenStyle;
    }

    public KDList getLstLineStyle() {
        return this.lstLineStyle;
    }

    class LineStyleListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        Object value;
        private BorderRender br = new BorderRender();
        private Rectangle rect;
        private StringBuffer sb = new StringBuffer();

        LineStyleListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.value = value;
            this.setPreferredSize(new Dimension(100, 20));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setOpaque(true);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.rect == null) {
                this.rect = new Rectangle(10, 10, 70, 0);
            }
            Graphics2D g2 = (Graphics2D)g;
            this.br.draw(g2, this.rect, new BorderRender.BorderInfo(2), (Style)LineSupplyCtrl.this.mapLineStyle2Style.get(this.value));
            g2.drawString(this.getWidthString((LineStyle)this.value), 85, 15);
        }

        private String getWidthString(LineStyle ls) {
            this.sb.delete(0, this.sb.length());
            this.sb.append('(');
            this.sb.append(ls.getWidth());
            this.sb.append(')');
            return this.sb.toString();
        }
    }

    static class PenStyleListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        Object value;

        PenStyleListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.value = value;
            this.setPreferredSize(new Dimension(100, 20));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setOpaque(true);
            return this;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(((PenStyle)this.value).getStroke(1));
            g2.drawLine(10, 10, 100, 10);
        }
    }
}

