/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.res.tool.java.stat;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonUIMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.res.tool.java.stat.IStatListener;
import com.kingdee.cosmic.ctrl.res.tool.java.stat.JavaFileStatInfo;
import com.kingdee.cosmic.ctrl.res.tool.java.stat.JavaFileStatInfoSummary;
import com.kingdee.cosmic.ctrl.res.tool.java.stat.StatFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class StatFrame
extends JFrame
implements IStatListener {
    private static final Logger log = LogUtil.getPackageLogger(StatFrame.class);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private JButton btnScan = new JButton(CtrlCommonUIMessages.getMLS("startStatistics", "\u5f00\u59cb\u7edf\u8ba1"));
    private JTextArea txtOut = new JTextArea();
    private JTextField txtPath = new JTextField(40);
    private JTextField txtPattern = new JTextField(30);
    private JProgressBar pb = new JProgressBar();
    private FileWriter logWriter = null;
    private boolean scaning = false;

    public StatFrame() {
        this.initUI();
        this.loadConfig();
    }

    private void loadConfig() {
        Properties pros = new Properties();
        try (FileInputStream fis = new FileInputStream("pattern.properties");){
            pros.load(fis);
        }
        catch (Exception e) {
            log.error((Object)"err", (Throwable)e);
        }
        this.txtPath.setText(pros.getProperty("src", ""));
        this.txtPattern.setText(pros.getProperty("exclude", "Abstract.*, Enum.*, .*Exception, .*Info, .*Collection, .*Factory, .*Facade, .*Remote, .*RemoteHome, .*Local, .*LocalHome, I[A-Z].*"));
    }

    private void saveConfig() {
        Properties pros = new Properties();
        pros.setProperty("src", this.txtPath.getText());
        pros.setProperty("exclude", this.txtPattern.getText());
        try (FileOutputStream fos = new FileOutputStream("pattern.properties");){
            pros.save(fos, "KingdeeStat");
        }
        catch (Exception e) {
            log.error((Object)"err", (Throwable)e);
        }
    }

    private void initUI() {
        this.setSize(640, 400);
        this.center(this);
        this.setTitle(CtrlCommonUIMessages.getMLS("codeStatistics", "\u4ee3\u7801\u7edf\u8ba1"));
        this.setDefaultCloseOperation(2);
        Container p = this.getContentPane();
        p.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new FlowLayout(0, 5, 5));
        topPanel.add(new JLabel(CtrlCommonUIMessages.getMLS("sourcePath", "\u6e90\u7801\u8def\u5f84:")));
        topPanel.add(this.txtPath);
        topPanel.add(this.btnScan);
        northPanel.add((Component)topPanel, "North");
        JPanel optionPanel = new JPanel(new FlowLayout(0, 5, 5));
        optionPanel.add(new JLabel(CtrlCommonUIMessages.getMLS("fileNameNotMatched", "\u6587\u4ef6\u540d\u4e0d\u5339\u914d(\u6b63\u5219\u8868\u8fbe\u5f0f\uff0c\u591a\u4e2a\u7528\",\"\u53f7\u5206\u9694):")));
        optionPanel.add(this.txtPattern);
        northPanel.add((Component)optionPanel, "Center");
        p.add((Component)northPanel, "North");
        p.add((Component)new JScrollPane(this.txtOut), "Center");
        p.add((Component)this.pb, "South");
        this.btnScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatFrame.this.doScan();
            }
        });
        PrintStream ps = new PrintStream(new ByteArrayOutputStream(){
            int line = 0;

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                ++this.line;
                if (this.line % 100 == 0 && StatFrame.this.scaning) {
                    StatFrame.this.txtOut.setText(null);
                }
                SwingUtilities.invokeLater(new PrintMsgRunnable(new String(b, off, len)));
            }
        });
        System.setOut(ps);
        System.setErr(ps);
        this.txtOut.setEditable(false);
        this.txtOut.setText(CtrlCommonUIMessages.getMLS("outputToExcel", "\u8f93\u51fa\u7ed3\u679c\u8bf7COPY\u5230Excel\u67e5\u770b."));
    }

    private void center(Window w) {
        Dimension dd = Toolkit.getDefaultToolkit().getScreenSize();
        w.setLocation((dd.width - w.getWidth()) / 2, (dd.height - w.getHeight()) / 2);
    }

    private void doScan() {
        this.msg(CtrlCommonUIMessages.getMLS("countingPleaseWait", "\u6b63\u5728\u7edf\u8ba1\uff0c\u8bf7\u7a0d\u5019...\n"));
        this.saveConfig();
        new ScanThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outToExcel(String msg) {
        OutputStreamWriter fw = null;
        try {
            msg = msg.replace('[', '\"').replace(']', '\"').replace('\t', ',');
            File fn = File.createTempFile("stat", ".csv");
            fw = new FileWriter(fn);
            fw.write(msg);
            fw.flush();
            Runtime.getRuntime().exec("cmd /c start " + fn.getAbsolutePath());
        }
        catch (Exception e) {
            log.error((Object)"err", (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    log.info((Object)"error", (Throwable)e);
                }
            }
        }
    }

    private String outToLog(String msg) throws Exception {
        String filename = "stat" + System.currentTimeMillis() + ".txt";
        File fn = new File(filename);
        try (FileWriter fw = new FileWriter(fn);){
            fw.write(msg);
            fw.flush();
        }
        return filename;
    }

    private String toExcelString(JavaFileStatInfo[] fs) {
        StringBuilder sb = new StringBuilder();
        sb.append(JavaFileStatInfo.getExcelHeaderString());
        for (int i = 0; i < fs.length; ++i) {
            sb.append("\n").append(fs[i].toExcelBodyString());
        }
        return sb.toString();
    }

    private void msg(String msg) {
        this.msg(msg, false);
    }

    private void msg(String msg, boolean append) {
        if (append) {
            this.txtOut.append(msg);
        } else {
            this.txtOut.setText(msg);
        }
        this.txtOut.setCaretPosition(0);
    }

    public static void main(String[] args) {
        new StatFrame().setVisible(true);
    }

    @Override
    public void scanFileCount(int c) {
        this.pb.setMaximum(c);
        try {
            this.logWriter.write(CtrlCommonUIMessages.getMLS("fileCount2", "\u6587\u4ef6\u6570=") + c);
            this.logWriter.write("\n" + JavaFileStatInfo.getExcelHeaderString());
            this.logWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void scanFileIndex(int i) {
        this.pb.setValue(i + 1);
        if (i % 1000 == 0) {
            System.gc();
        }
    }

    @Override
    public void scanFileStep(JavaFileStatInfo fs, int i) {
        try {
            this.logWriter.write('\n' + fs.toExcelBodyString());
            if (i % 20 == 0) {
                this.logWriter.flush();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void scanFinished(JavaFileStatInfoSummary summary) {
        try {
            this.logWriter.write('\n' + summary.getSummaryInfo());
            this.logWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class PrintMsgRunnable
    implements Runnable {
        String msg;

        PrintMsgRunnable(String aMsg) {
            this.msg = aMsg;
        }

        @Override
        public void run() {
            if (StatFrame.this.scaning) {
                StatFrame.this.txtOut.append(this.msg);
                StatFrame.this.txtOut.setCaretPosition(StatFrame.this.txtOut.getDocument().getLength());
            }
        }
    }

    class ScanThread
    extends Thread {
        ScanThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StatFrame.this.scaning = true;
                StatFrame.this.btnScan.setEnabled(false);
                long t = System.currentTimeMillis();
                String startDate = StatFrame.this.sdf.format(new Date());
                String path = StatFrame.this.txtPath.getText().trim();
                StatFile.setExcludePattern(StatFrame.this.txtPattern.getText());
                String logfilename = "stat_" + System.currentTimeMillis() + ".txt";
                StatFrame.this.logWriter = new FileWriter(logfilename);
                int count = StatFile.scanPath(path, StatFrame.this);
                StatFrame.this.scaning = false;
                t = System.currentTimeMillis() - t;
                DecimalFormat nf = (DecimalFormat)DecimalFormat.getInstance();
                nf.applyPattern("#,##0.0");
                StringBuilder sb = new StringBuilder();
                sb.append(startDate).append(" (").append(nf.format((float)t / 1000.0f)).append("s)  ");
                if (count == 0) {
                    sb.append(CtrlCommonUIMessages.getMLS("noJavaSourceFound", "\u6ca1\u627e\u5230\u53ef\u7edf\u8ba1\u7684java\u6e90\u6587\u4ef6\u3002"));
                } else {
                    sb.append(CtrlCommonUIMessages.getMLS("sourceFileCount", "\u6e90\u6587\u4ef6\u6570=#1").replace("#1", String.valueOf(count)));
                }
                sb.append("\n");
                sb.append(CtrlCommonUIMessages.getMLS("statisticsFinishedOutputTo", "\u3010\u7edf\u8ba1\u5b8c\u6bd5\u3011\u7ed3\u679c\u8f93\u51fa\u5230\u4e86#1, \u8bf7copy\u5230excel\u67e5\u770b\u3002").replace("#1", logfilename));
                StatFrame.this.msg(sb.toString());
            }
            catch (Exception e) {
                StatFrame.this.msg(CtrlCommonUIMessages.getMLS("errorInfo", "[\u9519\u8bef\u4fe1\u606f]") + e.getMessage());
            }
            finally {
                StatFrame.this.btnScan.setEnabled(true);
                if (StatFrame.this.logWriter != null) {
                    try {
                        StatFrame.this.logWriter.flush();
                        StatFrame.this.logWriter.close();
                    }
                    catch (Exception e) {
                        log.error((Object)"err", (Throwable)e);
                    }
                }
            }
        }
    }
}

