/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.health.healthapi;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class HealthApi {
    public static final String Status_Code = "Status_Code";
    public static final String INFORMATION = "INFORMATION";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getHealthReportOriginal(String rmiIp, int rmiPort) throws IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (rmiPort <= 100) {
            rmiPort = 10029;
        }
        if (rmiIp == null || rmiIp.length() < 1) {
            rmiIp = "localhost";
        }
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + rmiIp + ":" + rmiPort + "/bos");
        JMXConnector jmxc = null;
        try {
            Map sjson;
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
            jmxc = JMXConnectorFactory.connect(url, env);
            MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
            ObjectName mbeanName = new ObjectName("jmxBean:name=HeathReport");
            Map map = sjson = (Map)mbsc.getAttribute(mbeanName, "HeathReport");
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            Map map = null;
            return map;
        }
        finally {
            if (jmxc != null) {
                jmxc.close();
            }
        }
    }

    public static Map<String, Object> getHealthReport(String rmiIp, int rmiPort) throws IOException, MalformedObjectNameException, NullPointerException, AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException {
        Map report = HealthApi.getHealthReportOriginal(rmiIp, rmiPort);
        return report;
    }
}

