/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.core;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.IObjectFactory;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.core.rmi.RMIEngine;
import com.kingdee.bos.orm.core.rmi.RMIService;
import com.kingdee.bos.orm.impl.io.ConnectionManager;
import com.kingdee.bos.orm.impl.io.ConnectionServiceManager;
import com.kingdee.bos.orm.impl.io.ConnectionSource;
import com.kingdee.bos.orm.impl.io.HttpConnectionDriver2;
import com.kingdee.bos.orm.impl.io.InternalConnectionDriver;
import com.kingdee.bos.orm.impl.io.TCPConnectionDriver;
import com.kingdee.bos.orm.impl.server.InternalServer;
import com.kingdee.bos.orm.impl.service.EchoService;
import com.kingdee.bos.orm.impl.service.ServiceManager;
import com.kingdee.bos.orm.io.IConnectionManager;
import com.kingdee.bos.orm.io.IConnectionServiceManager;
import com.kingdee.bos.orm.io.IConnectionSetting;
import com.kingdee.bos.orm.io.IConnectionSource;
import com.kingdee.bos.orm.rmi.IRMISession;
import com.kingdee.bos.orm.service.IServiceManager;
import com.kingdee.bos.util.ThreadPool;
import java.util.Vector;

public class ORMEngine {
    public static boolean debug = false;
    private static Vector objectFactories = new Vector();
    public static final IServiceManager serviceManager = new ServiceManager();
    public static IConnectionServiceManager connectionServiceManager = new ConnectionServiceManager(serviceManager);
    public static final IConnectionManager connectionManager = new ConnectionManager(connectionServiceManager);
    public static final IConnectionSource connectionSource = new ConnectionSource(connectionManager);
    public static final InternalServer internalServer = new InternalServer(connectionServiceManager);
    private static ThreadPool threadPool;
    public static final long connectionIdleTimeout = 30000L;

    public static IRMISession getCurrentRMISession() {
        return RMIEngine.getCurrentSession();
    }

    public static IRMISession getObjectRMISession(Object stub) {
        return RMIEngine.getObjectSession(stub);
    }

    public static IORMModel createObject(String objectName, Class model) throws ORMCoreException {
        return ORMEngine.createObject(objectName, model, new Class[0], new Object[0]);
    }

    public static synchronized void registerObjectFactory(IObjectFactory objectFactory) {
        objectFactories.addElement(objectFactory);
    }

    public static synchronized void unregisterObjectFactory(IObjectFactory objectFactory) {
        objectFactories.removeElement(objectFactory);
    }

    public static synchronized IObjectFactory[] getObjectFactories() {
        Object[] ofs = new IObjectFactory[objectFactories.size()];
        objectFactories.copyInto(ofs);
        return ofs;
    }

    public static IORMModel createObject(String objectName, Class model, Class[] initArgTypes, Object[] initArgs) throws ORMCoreException {
        try {
            IObjectFactory[] ofs = ORMEngine.getObjectFactories();
            for (int i = 0; i < ofs.length; ++i) {
                IORMModel obj = ofs[i].createObject(objectName, model, initArgTypes, initArgs);
                if (obj == null) continue;
                return obj;
            }
            Class<?> cls = Class.forName(objectName);
            IORMModel object = (IORMModel)cls.getConstructor(initArgTypes).newInstance(initArgs);
            return object.queryInterface(model);
        }
        catch (Exception e) {
            throw ORMCoreException.create(e);
        }
    }

    public static IORMModel createRemoteObject(String serverUrl, String objectName, Class model) throws ORMCoreException {
        return ORMEngine.createRemoteObject(serverUrl, objectName, model, new Class[0], new Object[0]);
    }

    public static IORMModel createRemoteObject(String serverUrl, String objectName, Class model, Class[] initArgTypes, Object[] initArgs) throws ORMCoreException {
        return RMIEngine.createRemoteObject(serverUrl, objectName, model, initArgTypes, initArgs);
    }

    public static final void startThread(Runnable impl) {
        threadPool.run(impl);
    }

    public static int getThreadPoolMinSize() {
        return threadPool.getMinSize();
    }

    public static int getThreadPoolMaxSize() {
        return threadPool.getMaxSize();
    }

    public static void setThreadPoolSize(int min, int max) {
        threadPool.setSize(min, max);
    }

    public static String getCurrentConnectionString() {
        IRMISession session = ORMEngine.getCurrentRMISession();
        if (session == null) {
            return null;
        }
        return session.getServiceSession().getConnection().getConnectionString();
    }

    public static String getObjectConnectionString(Object stub) {
        IRMISession session = ORMEngine.getObjectRMISession(stub);
        if (session == null) {
            return null;
        }
        return session.getServiceSession().getConnection().getConnectionString();
    }

    public static void setConnectionSetting(IConnectionSetting setting) {
        connectionServiceManager.setConnectionSetting(setting);
    }

    static {
        serviceManager.registerService(new RMIService());
        serviceManager.registerService(new EchoService());
        connectionManager.registerDriver(new TCPConnectionDriver());
        connectionManager.registerDriver(new HttpConnectionDriver2());
        connectionManager.registerDriver(new InternalConnectionDriver(internalServer));
        threadPool = new ThreadPool("ORM-PRC", 0, 10);
    }
}

