/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.core.rmi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;

public class MonitorDisableList {
    private static final String DISABLE_LIST_NAME = "/traceignore.list";
    private static MonitorDisableList _inst;
    private HashMap ignoreClassMap = new HashMap();

    private MonitorDisableList() {
        this.initIgnoreList();
    }

    private void initIgnoreList() {
        try {
            InputStream ignoreStream = MonitorDisableList.class.getResourceAsStream(DISABLE_LIST_NAME);
            if (ignoreStream == null) {
                System.out.println("not found traceignore.list");
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(ignoreStream));
            String ignoreClazName = reader.readLine();
            while (ignoreClazName != null) {
                try {
                    this.ignoreClassMap.put(ignoreClazName, Class.forName(ignoreClazName));
                }
                catch (ClassNotFoundException notFoundExp) {
                    // empty catch block
                }
                ignoreClazName = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static final MonitorDisableList getInstance() {
        if (_inst == null) {
            _inst = new MonitorDisableList();
        }
        return _inst;
    }

    public boolean isIgnore(Class claz) {
        String clazName = claz.getName();
        if (this.ignoreClassMap.containsKey(clazName)) {
            return true;
        }
        Object[] clazCollection = this.ignoreClassMap.values().toArray();
        Class ignore = null;
        for (int i = 0; i < clazCollection.length; ++i) {
            ignore = (Class)clazCollection[i];
            if (!ignore.isAssignableFrom(claz)) continue;
            return true;
        }
        return false;
    }
}

