/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.core.rmi;

import com.kingdee.bos.orm.core.rmi.RMIGenerator2;
import com.kingdee.bos.orm.util.DynamicClassLoader;
import com.kingdee.bos.orm.util.JavaGenerator;
import com.kingdee.bos.util.ObjectCreator;
import java.io.File;

public class RMIClassLoader
extends ClassLoader {
    static ObjectCreator proxys = new ObjectCreator();
    static ObjectCreator stubs = new ObjectCreator();

    public static void registerProxyClass(Class model, Class proxyClass) {
        proxys.finishCreate((Object)model, (Object)proxyClass);
    }

    public static void registerStubClass(Class model, Class stubClass) {
        stubs.finishCreate((Object)model, (Object)stubClass);
    }

    private static File getClassFile(String className) throws Exception {
        return new File(JavaGenerator.DEFAULT_CLASS_ROOT, className.replace('.', '/') + ".class");
    }

    private static File getSourceFile(String className) throws Exception {
        return new File(JavaGenerator.DEFAULT_SOURCE_ROOT, className.replace('.', '/') + ".java");
    }

    public static Class loadProxyClass(Class model) throws Exception {
        Class cls = (Class)proxys.queryLockObject((Object)model);
        if (cls != null) {
            return cls;
        }
        try {
            cls = RMIGenerator2.generateObjectProxy(model);
            proxys.finishCreate((Object)model, (Object)cls);
        }
        catch (Exception e) {
            proxys.cancelCreate((Object)model);
            throw e;
        }
        return cls;
    }

    public static synchronized Class loadStubClass(Class model) throws Exception {
        Class cls = (Class)stubs.queryLockObject((Object)model);
        if (cls != null) {
            return cls;
        }
        try {
            cls = RMIGenerator2.genObjectStub(model);
            stubs.finishCreate((Object)model, (Object)cls);
        }
        catch (Exception e) {
            stubs.cancelCreate((Object)model);
            throw e;
        }
        return cls;
    }

    private static Class compile(JavaGenerator gen, ClassLoader classLoader) throws Exception {
        File classFile = gen.compile();
        return new DynamicClassLoader(classLoader).loadClassFromFile(gen.className, classFile);
    }
}

