/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.core.rmi;

import com.kingdee.bos.orm.core.rmi.InvokeResult;
import com.kingdee.bos.orm.core.rmi.ObjectProxy;
import com.kingdee.bos.orm.core.rmi.ObjectStub;
import com.kingdee.bos.orm.core.rmi.RMIParameterSpecial;
import com.kingdee.bos.orm.core.rmi.RMISession;
import com.kingdee.bos.orm.core.rmi.RemoteReference;
import com.kingdee.bos.orm.core.rmi.StubContext;
import com.kingdee.bos.orm.impl.service.OutputBlock;
import com.kingdee.bos.orm.rmi.RMIException;
import com.kingdee.bos.orm.util.JavaGenerator;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class RMIGenerator {
    public static String getProxyClassName(Class model) {
        return "ORMRMIPROXY_" + model.getName().replace('.', '_');
    }

    public static String getStubClassName(Class model) {
        return "ORMRMISTUB_" + model.getName().replace('.', '_');
    }

    public static String getDefaultPackageName() {
        return "orm.rmi";
    }

    public static JavaGenerator generateObjectProxy(Class model) throws Exception {
        return RMIGenerator.generateObjectProxy(model, null, RMIGenerator.getDefaultPackageName());
    }

    public static JavaGenerator generateObjectProxy(Class model, String className, String packageName) throws Exception {
        int i;
        if (!model.isInterface()) {
            throw new Exception(model.getName() + " is not a interface class.");
        }
        if (className == null) {
            className = RMIGenerator.getProxyClassName(model);
        }
        Class[] argTypes = new Class[]{Class.class};
        String superClass = "ObjectProxy";
        JavaGenerator gen = new JavaGenerator(packageName, className, superClass);
        gen.registerImport(ObjectInputStream.class);
        gen.registerImport(ObjectOutputStream.class);
        gen.registerImport(StubContext.class);
        gen.registerImport(ObjectProxy.class);
        gen.registerImport(RemoteReference.class);
        gen.registerImport(InvokeResult.class);
        gen.registerImport(RMISession.class);
        String typeName = gen.getTypeName(model);
        gen.out.println("private " + typeName + " object;");
        gen.out.println("public " + className + "(RMISession _session,Object _object)");
        gen.out.println("{");
        gen.out.println("\tsuper(_session,_object," + typeName + ".class);");
        gen.out.println("\tobject = (" + typeName + ")_object;");
        gen.out.println("}");
        Method[] mds = model.getMethods();
        gen.out.println("public InvokeResult processInvoke(String method,ObjectInputStream in) throws Exception");
        gen.out.println("{");
        boolean firstif = true;
        for (i = 0; i < mds.length; ++i) {
            gen.out.print("\t");
            if (firstif) {
                firstif = false;
            } else {
                gen.out.print("else ");
            }
            gen.out.println("if(method.equals(\"" + JavaGenerator.getMethodSig(mds[i]) + "\"))");
            gen.out.println("\t\t return pi" + (i + 1) + "_" + mds[i].getName() + "(in);");
        }
        gen.out.println("\telse");
        gen.out.println("\t\treturn super.processInvoke(method,in);");
        gen.out.println("}");
        for (i = 0; i < mds.length; ++i) {
            RMIGenerator.genMethodProxy(gen, mds[i], i + 1);
        }
        gen.genModelDigest(model);
        return gen;
    }

    private static void genMethodProxy(JavaGenerator gen, Method md, int methodIndex) throws Exception {
        int i;
        PrintWriter out = gen.out;
        Class<?> type = md.getReturnType();
        String typeName = gen.getTypeName(type);
        Class<?>[] args = md.getParameterTypes();
        out.println();
        out.print("//");
        gen.genMethodDeclare(md);
        out.println();
        out.println("InvokeResult pi" + methodIndex + "_" + md.getName() + "(ObjectInputStream in)throws Exception");
        out.println("{");
        for (i = 0; i < args.length; ++i) {
            String pn = "p" + i;
            String ptype = gen.getTypeName(args[i]);
            out.print("\t" + ptype + " " + pn + "=");
            if (RMIParameterSpecial.isSerial(args[i])) {
                if (args[i].isPrimitive()) {
                    if (args[i].equals(Boolean.TYPE)) {
                        out.println("in.readBoolean();");
                        continue;
                    }
                    if (args[i].equals(Character.TYPE)) {
                        out.println("in.readChar();");
                        continue;
                    }
                    if (args[i].equals(Byte.TYPE)) {
                        out.println("in.readByte();");
                        continue;
                    }
                    if (args[i].equals(Short.TYPE)) {
                        out.println("in.readShort();");
                        continue;
                    }
                    if (args[i].equals(Integer.TYPE)) {
                        out.println("in.readInt();");
                        continue;
                    }
                    if (args[i].equals(Long.TYPE)) {
                        out.println("in.readLong();");
                        continue;
                    }
                    if (args[i].equals(Float.TYPE)) {
                        out.println("in.readFloat();");
                        continue;
                    }
                    if (!args[i].equals(Double.TYPE)) continue;
                    out.println("in.readDouble();");
                    continue;
                }
                out.println("(" + ptype + ")in.readObject();");
                continue;
            }
            String dims = JavaGenerator.getArrayDims(args[i]);
            String cTypeName = gen.getTypeName(JavaGenerator.getComponentType(args[i]));
            String cTypeClassName = RMIGenerator.getSpecialName(md, i);
            if (cTypeClassName == null) {
                cTypeClassName = cTypeName + ".class";
            }
            out.println("(" + ptype + ")createStubObject(" + cTypeClassName + ", (RemoteReference" + dims + ")in.readObject());");
        }
        out.println("\ttry");
        out.println("\t{");
        out.print("\t\t");
        if (!type.equals(Void.TYPE)) {
            out.print(typeName + " result=");
        }
        out.print("object." + md.getName() + "(");
        for (i = 0; i < args.length; ++i) {
            if (i > 0) {
                out.print(", ");
            }
            out.print("p" + i);
        }
        out.println(");");
        if (RMIParameterSpecial.isSerial(type)) {
            if (type.isPrimitive()) {
                if (type.equals(Boolean.TYPE)) {
                    out.println("\t\treturn new InvokeResult(InvokeResult.RETURNED,new Boolean(result));");
                } else if (type.equals(Character.TYPE)) {
                    out.println("\t\treturn new InvokeResult(InvokeResult.RETURNED,new Character(result));");
                } else if (type.equals(Byte.TYPE)) {
                    out.println("\t\treturn new InvokeResult(InvokeResult.RETURNED,new Byte(result));");
                } else if (type.equals(Short.TYPE)) {
                    out.println("\t\treturn new InvokeResult(InvokeResult.RETURNED,new Short(result));");
                } else if (type.equals(Integer.TYPE)) {
                    out.println("\t\treturn new InvokeResult(InvokeResult.RETURNED,new Integer(result));");
                } else if (type.equals(Long.TYPE)) {
                    out.println("\t\treturn new InvokeResult(InvokeResult.RETURNED,new Long(result));");
                } else if (type.equals(Float.TYPE)) {
                    out.println("\t\treturn new InvokeResult(InvokeResult.RETURNED,new Float(result));");
                } else if (type.equals(Double.TYPE)) {
                    out.println("\t\treturn new InvokeResult(InvokeResult.RETURNED,new Double(result));");
                } else {
                    out.println("\t\treturn new InvokeResult(InvokeResult.RETURNED,null);");
                }
            } else {
                out.println("\t\treturn new InvokeResult(InvokeResult.RETURNED,result);");
            }
        } else {
            out.println("\t\tif(result==null)");
            out.println("\t\t\t return new InvokeResult(InvokeResult.RETURNED,null);");
            String dims = JavaGenerator.getArrayDims(type);
            String cTypeName = gen.getTypeName(JavaGenerator.getComponentType(type));
            String cTypeClassName = RMIGenerator.getSpecialName(md, -1);
            if (cTypeClassName == null) {
                cTypeClassName = cTypeName + ".class";
            }
            out.println("\t\treturn new InvokeResult(InvokeResult.RETURNED, createProxyObject(" + cTypeClassName + ",result));");
        }
        out.println("\t}");
        out.println("\tcatch(Exception e)");
        out.println("\t{");
        out.println("\t\treturn new InvokeResult(InvokeResult.EXCEPTION,e);");
        out.println("\t}");
        out.println("}");
    }

    public static JavaGenerator generateObjectStub(Class model) throws Exception {
        return RMIGenerator.generateObjectStub(model, null, RMIGenerator.getDefaultPackageName());
    }

    public static JavaGenerator generateObjectStub(Class model, String className, String packageName) throws Exception {
        if (!model.isInterface()) {
            throw new Exception(model.getName() + " is not a interface class.");
        }
        if (className == null) {
            className = "ORMRMISTUB_" + model.getName().replace('.', '_');
        }
        Class[] argTypes = new Class[]{Class.class};
        String superClass = "ObjectStub";
        JavaGenerator gen = new JavaGenerator(packageName, className, superClass);
        gen.registerImport(ObjectInputStream.class);
        gen.registerImport(ObjectOutputStream.class);
        gen.registerImport(StubContext.class);
        gen.registerImport(ObjectStub.class);
        gen.registerImport(RemoteReference.class);
        gen.registerImport(InvokeResult.class);
        gen.registerImport(OutputBlock.class);
        gen.registerImport(RMIException.class);
        gen.addImplements(model);
        gen.out.println("public " + className + "(StubContext _ctx)");
        gen.out.println("{");
        gen.out.println("\tsuper(_ctx);");
        gen.out.println("}");
        Method[] mds = model.getMethods();
        for (int i = 0; i < mds.length; ++i) {
            RMIGenerator.genMethodStub(gen, mds[i], i + 1);
        }
        gen.genModelDigest(model);
        return gen;
    }

    private static void genMethodStub(JavaGenerator gen, Method md, int methodIndex) throws Exception {
        int i;
        PrintWriter out = gen.out;
        Class<?> type = md.getReturnType();
        String typeName = gen.getTypeName(type);
        out.println("//method #" + methodIndex);
        Class<?>[] args = md.getParameterTypes();
        Class<?>[] es = md.getExceptionTypes();
        gen.genMethodDeclare(md);
        out.println();
        out.println("{");
        out.println("\tInvokeResult r= null;");
        out.println("\ttry");
        out.println("\t{");
        out.println("\t\tOutputBlock ob = ctx.startInvoke(\"" + JavaGenerator.getMethodSig(md) + "\");");
        out.println("\t\tObjectOutputStream out = ob.out;");
        for (i = 0; i < args.length; ++i) {
            RMIGenerator.genParameterStub(gen, md, args[i], i);
        }
        out.println("\t\tr = ctx.finishInvoke(ob);");
        out.println("\t}");
        out.println("\tcatch(Exception e)");
        out.println("\t{");
        out.println("\t\tctx.invokeFailed();");
        out.println("\t\tthrow RMIException.createRMIException(e);");
        out.println("\t}");
        out.println("\tif (r.state == InvokeResult.EXCEPTION)");
        out.println("\t{");
        for (i = 0; i < es.length; ++i) {
            String ename = gen.getTypeName(es[i]);
            out.print("\t\t");
            if (i > 0) {
                out.print("else ");
            }
            out.println("if(r.value instanceof " + ename + ")");
            out.println("\t\t\tthrow (" + ename + ")r.value;");
        }
        if (es.length > 0) {
            out.println("\t\telse");
        }
        out.println("\t\t\tthrow RMIException.createRMIException((Exception)r.value);");
        out.println("\t}");
        if (RMIParameterSpecial.isSerial(type)) {
            if (type.isPrimitive()) {
                if (type.equals(Boolean.TYPE)) {
                    out.println("\treturn ((Boolean)r.value).booleanValue();");
                } else if (type.equals(Character.TYPE)) {
                    out.println("\treturn ((Character)r.value).charValue();");
                } else if (type.equals(Byte.TYPE)) {
                    out.println("\treturn ((Byte)r.value).byteValue();");
                } else if (type.equals(Short.TYPE)) {
                    out.println("\treturn ((Short)r.value).shortValue();");
                } else if (type.equals(Integer.TYPE)) {
                    out.println("\treturn ((Integer)r.value).intValue();");
                } else if (type.equals(Long.TYPE)) {
                    out.println("\treturn ((Long)r.value).longValue();");
                } else if (type.equals(Float.TYPE)) {
                    out.println("\treturn ((Float)r.value).floatValue();");
                } else if (type.equals(Double.TYPE)) {
                    out.println("\treturn ((Double)r.value).doubleValue();");
                }
            } else {
                out.println("\treturn (" + typeName + ")r.value;");
            }
        } else {
            out.println("\tif(r.value==null) return null;");
            String dims = JavaGenerator.getArrayDims(type);
            String cTypeName = RMIGenerator.getSpecialName(md, -1);
            if (cTypeName == null) {
                cTypeName = gen.getTypeName(JavaGenerator.getComponentType(type)) + ".class";
            }
            out.println("\treturn (" + typeName + ")ctx.createStubObject(" + cTypeName + ",(RemoteReference" + dims + ")r.value);");
        }
        out.println("}");
    }

    private static void genParameterStub(JavaGenerator gen, Method md, Class type, int index) throws Exception {
        String argName = "p" + index;
        PrintWriter out = gen.out;
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                out.println("\t\tout.writeBoolean(" + argName + ");");
            } else if (type.equals(Character.TYPE)) {
                out.println("\t\tout.writeChar(" + argName + ");");
            } else if (type.equals(Byte.TYPE)) {
                out.println("\t\tout.writeByte(" + argName + ");");
            } else if (type.equals(Short.TYPE)) {
                out.println("\t\tout.writeShort(" + argName + ");");
            } else if (type.equals(Integer.TYPE)) {
                out.println("\t\tout.writeInt(" + argName + ");");
            } else if (type.equals(Long.TYPE)) {
                out.println("\t\tout.writeLong(" + argName + ");");
            } else if (type.equals(Float.TYPE)) {
                out.println("\t\tout.writeFloat(" + argName + ");");
            } else if (type.equals(Double.TYPE)) {
                out.println("\t\tout.writeDouble(" + argName + ");");
            }
        } else if (!RMIParameterSpecial.isSerial(type)) {
            String pTypeClassName = RMIGenerator.getSpecialName(md, index);
            if (pTypeClassName == null) {
                pTypeClassName = JavaGenerator.getComponentType(type).getName() + ".class";
            }
            out.println("\t\tout.writeObject(ctx.createProxyObject(" + pTypeClassName + ", " + argName + "));");
        } else {
            out.println("\t\tout.writeObject(" + argName + ");");
        }
    }

    static String getSpecialName(Method md, int parameter) {
        Object x = RMIParameterSpecial.getSpecial(md, parameter);
        if (x == null) {
            if (parameter == -1) {
                return md.getReturnType().getName() + ".class";
            }
            return md.getParameterTypes()[parameter].getName() + ".class";
        }
        if (x instanceof Class) {
            return ((Class)x).getName() + ".class";
        }
        return "p" + (Integer)x;
    }
}

