/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.core.rmi;

import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.orm.core.rmi.InvokeResult;
import com.kingdee.bos.orm.core.rmi.ObjectProxy;
import com.kingdee.bos.orm.core.rmi.ObjectStub;
import com.kingdee.bos.orm.core.rmi.RMIEngine;
import com.kingdee.bos.orm.core.rmi.RMIGenerator;
import com.kingdee.bos.orm.core.rmi.RMIParameterSpecial;
import com.kingdee.bos.orm.core.rmi.RMISession;
import com.kingdee.bos.orm.core.rmi.RemoteReference;
import com.kingdee.bos.orm.core.rmi.SessionExt;
import com.kingdee.bos.orm.core.rmi.StubContext;
import com.kingdee.bos.orm.impl.service.OutputBlock;
import com.kingdee.bos.orm.rmi.RMIException;
import com.kingdee.bos.orm.util.JavaGenerator;
import com.tool.classfile.ClassDefinition;
import com.tool.classfile.FieldDefinition;
import com.tool.classfile.FieldRef;
import com.tool.classfile.InterfaceMethodRef;
import com.tool.classfile.MethodDefinition;
import com.tool.classfile.MethodRef;
import com.tool.classfile.sc;
import com.tool.simplecode.Assign;
import com.tool.simplecode.BuildEnv;
import com.tool.simplecode.CheckCast;
import com.tool.simplecode.Cmp;
import com.tool.simplecode.GetField;
import com.tool.simplecode.If;
import com.tool.simplecode.InvokeInterface;
import com.tool.simplecode.InvokeSpecial;
import com.tool.simplecode.InvokeStatic;
import com.tool.simplecode.InvokeVirtual;
import com.tool.simplecode.IsNull;
import com.tool.simplecode.MethodCodes;
import com.tool.simplecode.New;
import com.tool.simplecode.Return;
import com.tool.simplecode.SetField;
import com.tool.simplecode.Throw;
import com.tool.simplecode.Try;
import com.tool.simplecode.Unit;
import com.tool.simplecode.Value;
import com.tool.simplecode.Variable;
import com.tool.simplecode.ch;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;

class RMIGenerator2 {
    public static final String SOURCE_DIR = "./temporary/src/orm/rmi/";
    public static final String CLASS_DIR = "./temporary/classes/orm/rmi/";
    public static final String class_ObjectProxy = sc.className(ObjectProxy.class);
    public static final String init_desc = sc.descriptor(Void.TYPE, RMISession.class, Object.class);
    public static final MethodRef super_init = new MethodRef(class_ObjectProxy, "<init>", sc.descriptor(Void.TYPE, RMISession.class, Object.class, Class.class));
    public static final String class_InvokeResult = sc.className(InvokeResult.class);
    public static final String type_InvokeResult = sc.classDescriptor(InvokeResult.class);
    public static final String class_ObjectInputStream = sc.className(ObjectInputStream.class);
    public static final String type_ObjectInputStream = sc.classDescriptor(ObjectInputStream.class);
    public static final String class_ObjectOutputStream = sc.className(ObjectOutputStream.class);
    public static final String type_ObjectOutputStream = sc.classDescriptor(ObjectOutputStream.class);
    public static final String PI_METHODDESC = sc.descriptor(InvokeResult.class, ObjectInputStream.class);
    public static final MethodRef md_processInvoke = sc.method(ObjectProxy.class, (String)"processInvoke", String.class, ObjectInputStream.class);
    public static final String class_SessionExt = sc.classDescriptor(SessionExt.class);
    public static final String class_RemoteReference = sc.className(RemoteReference.class);
    public static final String type_RemoteReference = sc.classDescriptor(RemoteReference.class);
    private static final MethodRef md_readBoolean = sc.method(ObjectInputStream.class, (String)"readBoolean");
    private static final MethodRef md_readChar = sc.method(ObjectInputStream.class, (String)"readChar");
    private static final MethodRef md_readByte = sc.method(ObjectInputStream.class, (String)"readByte");
    private static final MethodRef md_readShort = sc.method(ObjectInputStream.class, (String)"readShort");
    private static final MethodRef md_readInt = sc.method(ObjectInputStream.class, (String)"readInt");
    private static final MethodRef md_readLong = sc.method(ObjectInputStream.class, (String)"readLong");
    private static final MethodRef md_readFloat = sc.method(ObjectInputStream.class, (String)"readFloat");
    private static final MethodRef md_readDouble = sc.method(ObjectInputStream.class, (String)"readDouble");
    private static final MethodRef md_readObject = sc.method(ObjectInputStream.class, (String)"readObject");
    private static final MethodRef md_writeBoolean = sc.method(ObjectOutputStream.class, (String)"writeBoolean", Boolean.TYPE);
    private static final MethodRef md_writeChar = sc.method(ObjectOutputStream.class, (String)"writeChar", Integer.TYPE);
    private static final MethodRef md_writeByte = sc.method(ObjectOutputStream.class, (String)"writeByte", Integer.TYPE);
    private static final MethodRef md_writeShort = sc.method(ObjectOutputStream.class, (String)"writeShort", Integer.TYPE);
    private static final MethodRef md_writeInt = sc.method(ObjectOutputStream.class, (String)"writeInt", Integer.TYPE);
    private static final MethodRef md_writeLong = sc.method(ObjectOutputStream.class, (String)"writeLong", Long.TYPE);
    private static final MethodRef md_writeFloat = sc.method(ObjectOutputStream.class, (String)"writeFloat", Float.TYPE);
    private static final MethodRef md_writeDouble = sc.method(ObjectOutputStream.class, (String)"writeDouble", Double.TYPE);
    private static final MethodRef md_writeObject = sc.method(ObjectOutputStream.class, (String)"writeObject", Object.class);
    private static final MethodRef md_booleanValue = sc.method(Boolean.class, (String)"booleanValue");
    private static final MethodRef md_charValue = sc.method(Character.class, (String)"charValue");
    private static final MethodRef md_byteValue = sc.method(Number.class, (String)"byteValue");
    private static final MethodRef md_shortValue = sc.method(Number.class, (String)"shortValue");
    private static final MethodRef md_intValue = sc.method(Number.class, (String)"intValue");
    private static final MethodRef md_longValue = sc.method(Number.class, (String)"longValue");
    private static final MethodRef md_floatValue = sc.method(Number.class, (String)"floatValue");
    private static final MethodRef md_doubleValue = sc.method(Number.class, (String)"doubleValue");
    public static final String class_ObjectStub = sc.className(ObjectStub.class);
    public static final String class_StubContext = sc.className(StubContext.class);
    public static final String type_StubContext = sc.classDescriptor(StubContext.class);
    private static final String type_OutputBlock = sc.classDescriptor(OutputBlock.class);
    private static final String class_OutputBlock = sc.className(OutputBlock.class);
    private static final MethodRef md_startInvoke = sc.method(StubContext.class, (String)"startInvoke", String.class);
    private static final MethodRef md_finishInvoke = sc.method(StubContext.class, (String)"finishInvoke", OutputBlock.class);
    private static final MethodRef md_invokeFailed = sc.method(StubContext.class, (String)"invokeFailed");
    private static final FieldRef fd_ctx = sc.field(ObjectStub.class, (String)"ctx");
    private static final FieldRef fd_ob_out = sc.field(OutputBlock.class, (String)"out");
    private static final MethodRef md_createRMIException = sc.method(RMIException.class, (String)"createRMIException", Throwable.class);
    private static final FieldRef field_state = sc.field(InvokeResult.class, (String)"state");
    private static final FieldRef field_value = sc.field(InvokeResult.class, (String)"value");
    private static final MethodRef ivr_init = sc.constructor(InvokeResult.class, Integer.TYPE, Object.class);

    RMIGenerator2() {
    }

    static Class generateObjectProxy(Class model) throws Exception {
        Vector<MethodCodes> mdcs = new Vector<MethodCodes>();
        String className = RMIGenerator.getProxyClassName(model);
        String packageName = RMIGenerator.getDefaultPackageName();
        ClassDefinition def = new ClassDefinition(packageName.replace('.', '/') + "/" + className, class_ObjectProxy, 1, new String[0]);
        FieldDefinition fd_object = def.declareField("object", model, 2);
        MethodDefinition md_init = def.declareMethod("<init>", init_desc, 1, new String[0]);
        md_init.args[0].name = "_session";
        md_init.args[1].name = "_object";
        MethodCodes mc_init = new MethodCodes(md_init);
        Unit[] init_args = new Unit[]{mc_init.args[0], mc_init.args[1], ch.class_forName((Class)model)};
        mc_init.append((Unit)new InvokeSpecial((Unit)mc_init._this, super_init, init_args));
        CheckCast cc = new CheckCast((Unit)mc_init.args[1], sc.className((Class)model));
        mc_init.append((Unit)new SetField((Unit)mc_init._this, fd_object.newReference(), (Unit)cc));
        mc_init.append((Unit)new Return());
        mdcs.addElement(mc_init);
        String[] md_pi_exceptions = new String[]{"java/lang/Exception"};
        MethodDefinition md_pi = def.declareMethod(RMIGenerator2.md_processInvoke.name, RMIGenerator2.md_processInvoke.descriptor, 1, md_pi_exceptions);
        md_pi.args[0].name = "method";
        md_pi.args[1].name = "in";
        MethodCodes mc_pi = new MethodCodes(md_pi);
        Method[] mds = model.getMethods();
        If block = null;
        for (int i = 0; i < mds.length; ++i) {
            Value sig = new Value(JavaGenerator.getMethodSig(mds[i]));
            Unit cond = ch.object_equals((Unit)mc_pi.args[0], (Unit)sig);
            Unit[] pi_args = new Unit[]{mc_pi.args[1]};
            Return ret = new Return((Unit)new InvokeSpecial((Unit)mc_pi._this, new MethodRef(def.className, "pi" + (i + 1), PI_METHODDESC), pi_args));
            if (block == null) {
                block = new If(cond);
                mc_pi.append((Unit)block);
                block.append((Unit)ret);
                continue;
            }
            block._else_if(cond).append((Unit)ret);
        }
        Return super_ret = new Return((Unit)new InvokeSpecial((Unit)mc_pi._this, md_processInvoke, (Unit[])mc_pi.args));
        mc_pi.append((Unit)super_ret);
        mdcs.addElement(mc_pi);
        for (int i = 0; i < mds.length; ++i) {
            mdcs.addElement(RMIGenerator2.genMethodProxy(model, mds[i], def, fd_object, i + 1));
        }
        MethodCodes[] mcs = (MethodCodes[])sc.toArray(MethodCodes.class, mdcs);
        if (ORMEngine.debug) {
            File sourceFile = new File(SOURCE_DIR + className + ".java");
            sourceFile.getParentFile().mkdirs();
            BuildEnv.buildSource((ClassDefinition)def, (File)sourceFile, (MethodCodes[])mcs);
        }
        for (int i = 0; i < mcs.length; ++i) {
            mcs[i].buildCodes();
        }
        return def.toClass(model.getClassLoader(), RMIEngine.class.getClassLoader());
    }

    private static String getReferenceType(Class argType) {
        if (argType.isArray()) {
            return "[" + RMIGenerator2.getReferenceType(argType.getComponentType());
        }
        return type_RemoteReference;
    }

    private static String getObjectType(Class argType) {
        if (argType.isArray()) {
            return "[" + RMIGenerator2.getObjectType(argType.getComponentType());
        }
        return "Ljava/lang/Object;";
    }

    private static MethodCodes genMethodProxy(Class model, Method md, ClassDefinition def, FieldDefinition fd_object, int index) throws Exception {
        Class<?> type = md.getReturnType();
        Class<?>[] args = md.getParameterTypes();
        String[] md_pi_exs = new String[]{"java/lang/Exception"};
        MethodDefinition md_pi = def.declareMethod("pi" + index, PI_METHODDESC, 2, md_pi_exs);
        md_pi.args[0].name = "in";
        MethodCodes mc_pi = new MethodCodes(md_pi);
        Variable[] ps = new Variable[args.length];
        for (int i = 0; i < args.length; ++i) {
            ps[i] = mc_pi.declareVariable("p" + i, sc.classDescriptor(args[i]));
            InvokeVirtual value = null;
            if (RMIParameterSpecial.isSerial(args[i])) {
                if (args[i].isPrimitive()) {
                    if (args[i].equals(Boolean.TYPE)) {
                        value = new InvokeVirtual((Unit)mc_pi.args[0], md_readBoolean, new Unit[0]);
                    } else if (args[i].equals(Character.TYPE)) {
                        value = new InvokeVirtual((Unit)mc_pi.args[0], md_readChar, new Unit[0]);
                    } else if (args[i].equals(Byte.TYPE)) {
                        value = new InvokeVirtual((Unit)mc_pi.args[0], md_readByte, new Unit[0]);
                    } else if (args[i].equals(Short.TYPE)) {
                        value = new InvokeVirtual((Unit)mc_pi.args[0], md_readShort, new Unit[0]);
                    } else if (args[i].equals(Integer.TYPE)) {
                        value = new InvokeVirtual((Unit)mc_pi.args[0], md_readInt, new Unit[0]);
                    } else if (args[i].equals(Long.TYPE)) {
                        value = new InvokeVirtual((Unit)mc_pi.args[0], md_readLong, new Unit[0]);
                    } else if (args[i].equals(Float.TYPE)) {
                        value = new InvokeVirtual((Unit)mc_pi.args[0], md_readFloat, new Unit[0]);
                    } else if (args[i].equals(Double.TYPE)) {
                        value = new InvokeVirtual((Unit)mc_pi.args[0], md_readDouble, new Unit[0]);
                    }
                } else {
                    value = new CheckCast((Unit)new InvokeVirtual((Unit)mc_pi.args[0], md_readObject, new Unit[0]), sc.className(args[i]));
                }
            } else {
                Object clsType = null;
                Object spec = RMIParameterSpecial.getSpecial(md, i);
                clsType = spec == null ? ch.class_forName((Class)RMIGenerator2.getComponentType(args[i])) : (spec instanceof Class ? ch.class_forName((Class)((Class)spec)) : ps[(Integer)spec]);
                String refType = sc.classType((String)RMIGenerator2.getReferenceType(args[i]));
                CheckCast ref = new CheckCast((Unit)new InvokeVirtual((Unit)mc_pi.args[0], md_readObject, new Unit[0]), refType);
                MethodRef md_createStubObject = new MethodRef(class_SessionExt, "createStubObject", "(Ljava/lang/Class;" + refType + ")" + RMIGenerator2.getObjectType(args[i]));
                Unit[] cs_args = new Unit[]{clsType, ref};
                value = new CheckCast((Unit)new InvokeVirtual((Unit)mc_pi._this, md_createStubObject, cs_args), sc.className(args[i]));
            }
            mc_pi.append((Unit)new Assign(ps[i], (Unit)value));
        }
        Try _try = new Try();
        Variable result = null;
        if (!type.equals(Void.TYPE)) {
            result = _try.declareVariable("result", sc.classDescriptor(type));
        }
        GetField object = new GetField((Unit)mc_pi._this, fd_object.newReference());
        InvokeInterface r = new InvokeInterface((Unit)object, new InterfaceMethodRef(md), (Unit[])ps);
        if (result != null) {
            _try.append((Unit)new Assign(result, (Unit)r));
        } else {
            _try.append((Unit)r);
        }
        Unit[] ivr_args = new Unit[2];
        ivr_args[0] = new Value(0);
        if (RMIParameterSpecial.isSerial(type)) {
            ivr_args[1] = type.isPrimitive() ? (type.equals(Boolean.TYPE) ? ch.new_Boolean((Unit)result) : (type.equals(Character.TYPE) ? ch.new_Char((Unit)result) : (type.equals(Byte.TYPE) ? ch.new_Byte((Unit)result) : (type.equals(Short.TYPE) ? ch.new_Short((Unit)result) : (type.equals(Integer.TYPE) ? ch.new_Integer((Unit)result) : (type.equals(Long.TYPE) ? ch.new_Long((Unit)result) : (type.equals(Float.TYPE) ? ch.new_Float((Unit)result) : (type.equals(Double.TYPE) ? ch.new_Double((Unit)result) : Value.NULL)))))))) : result;
            _try.append((Unit)new Return((Unit)new New(ivr_init, ivr_args)));
        } else {
            If _if = new If((Unit)new IsNull((Unit)result));
            ivr_args[1] = Value.NULL;
            _if.append((Unit)new Return((Unit)new New(ivr_init, ivr_args)));
            Object clsType = null;
            Object spec = RMIParameterSpecial.getSpecial(md, -1);
            clsType = spec == null ? ch.class_forName((Class)RMIGenerator2.getComponentType(type)) : (spec instanceof Class ? ch.class_forName((Class)((Class)spec)) : ps[(Integer)spec]);
            MethodRef md_cp = new MethodRef(class_SessionExt, "createProxyObject", "(Ljava/lang/Class;" + RMIGenerator2.getObjectType(type) + ")" + RMIGenerator2.getReferenceType(type));
            Unit[] cp_args = new Unit[]{clsType, result};
            ivr_args[1] = new InvokeVirtual((Unit)mc_pi._this, md_cp, cp_args);
            _if._else().append((Unit)new Return((Unit)new New(ivr_init, ivr_args)));
            _try.append((Unit)_if);
        }
        Try.CatchBlock cb = _try._catch("java/lang/Exception", "e");
        ivr_args[0] = new Value(1);
        ivr_args[1] = cb.e;
        cb.append((Unit)new Return((Unit)new New(ivr_init, ivr_args)));
        mc_pi.append((Unit)_try);
        mc_pi.append((Unit)new Return((Unit)Value.NULL));
        return mc_pi;
    }

    static Class genObjectStub(Class model) throws Exception {
        if (!model.isInterface()) {
            throw new Exception(model.getName() + " is not a interface class.");
        }
        Vector<MethodCodes> mdcs = new Vector<MethodCodes>();
        String className = RMIGenerator.getStubClassName(model);
        String packageName = RMIGenerator.getDefaultPackageName();
        String[] interfaces = new String[]{sc.className((Class)model)};
        ClassDefinition def = new ClassDefinition(packageName.replace('.', '/') + "/" + className, class_ObjectStub, 1, interfaces);
        MethodDefinition md_init = def.declareMethod("<init>", "(" + type_StubContext + ")V", 1, new String[0]);
        md_init.args[0].name = "_ctx";
        MethodCodes mc_init = new MethodCodes(md_init);
        MethodRef super_init = new MethodRef(class_ObjectStub, "<init>", md_init.descriptor);
        mc_init.append((Unit)new InvokeSpecial((Unit)mc_init._this, super_init, (Unit[])mc_init.args));
        mc_init.append((Unit)new Return());
        mdcs.addElement(mc_init);
        Method[] mds = model.getMethods();
        Hashtable<String, Method> mds_dict = new Hashtable<String, Method>();
        for (int i = 0; i < mds.length; ++i) {
            String mk = mds[i].getName() + sc.methodDescriptor((Method)mds[i]);
            if (mds_dict.containsKey(mk)) continue;
            mds_dict.put(mk, mds[i]);
            mdcs.addElement(RMIGenerator2.genMethodStub(def, mds[i]));
        }
        MethodCodes[] mcs = (MethodCodes[])sc.toArray(MethodCodes.class, mdcs);
        if (ORMEngine.debug) {
            File sourceFile = new File(SOURCE_DIR + className + ".java").getAbsoluteFile();
            sourceFile.getParentFile().mkdirs();
            BuildEnv.buildSource((ClassDefinition)def, (File)sourceFile, (MethodCodes[])mcs);
        }
        for (int i = 0; i < mcs.length; ++i) {
            mcs[i].buildCodes();
        }
        return def.toClass(model.getClassLoader(), RMIEngine.class.getClassLoader());
    }

    private static Unit field_ctx(MethodCodes mc) {
        return new GetField((Unit)mc._this, fd_ctx);
    }

    private static MethodCodes genMethodStub(ClassDefinition def, Method md) throws Exception {
        Class<?> type = md.getReturnType();
        Class<?>[] args = md.getParameterTypes();
        MethodDefinition md_def = def.declareMethod(md);
        MethodCodes mc = new MethodCodes(md_def);
        Variable r = mc.declareVariable("r", type_InvokeResult);
        mc.append((Unit)new Assign(r, (Unit)Value.NULL));
        Try _try = new Try();
        mc.append((Unit)_try);
        Variable ob = _try.declareVariable("ob", type_OutputBlock);
        String sig = JavaGenerator.getMethodSig(md);
        Unit[] si_args = new Unit[]{new Value(sig)};
        _try.append((Unit)new Assign(ob, (Unit)new InvokeVirtual(RMIGenerator2.field_ctx(mc), md_startInvoke, si_args)));
        if (args.length > 0) {
            Variable out = _try.declareVariable("out", type_ObjectOutputStream);
            _try.append((Unit)new Assign(out, (Unit)new GetField((Unit)ob, fd_ob_out)));
            for (int i = 0; i < args.length; ++i) {
                Unit[] write_args = new Unit[]{mc.args[i]};
                Class<?> ptype = args[i];
                if (ptype.isPrimitive()) {
                    if (ptype.equals(Boolean.TYPE)) {
                        _try.append((Unit)new InvokeVirtual((Unit)out, md_writeBoolean, write_args));
                        continue;
                    }
                    if (ptype.equals(Character.TYPE)) {
                        _try.append((Unit)new InvokeVirtual((Unit)out, md_writeChar, write_args));
                        continue;
                    }
                    if (ptype.equals(Byte.TYPE)) {
                        _try.append((Unit)new InvokeVirtual((Unit)out, md_writeByte, write_args));
                        continue;
                    }
                    if (ptype.equals(Short.TYPE)) {
                        _try.append((Unit)new InvokeVirtual((Unit)out, md_writeShort, write_args));
                        continue;
                    }
                    if (ptype.equals(Integer.TYPE)) {
                        _try.append((Unit)new InvokeVirtual((Unit)out, md_writeInt, write_args));
                        continue;
                    }
                    if (ptype.equals(Long.TYPE)) {
                        _try.append((Unit)new InvokeVirtual((Unit)out, md_writeLong, write_args));
                        continue;
                    }
                    if (ptype.equals(Float.TYPE)) {
                        _try.append((Unit)new InvokeVirtual((Unit)out, md_writeFloat, write_args));
                        continue;
                    }
                    if (!ptype.equals(Double.TYPE)) continue;
                    _try.append((Unit)new InvokeVirtual((Unit)out, md_writeDouble, write_args));
                    continue;
                }
                if (!RMIParameterSpecial.isSerial(ptype)) {
                    Object spec = RMIParameterSpecial.getSpecial(md, i);
                    Object clsType = spec == null ? ch.class_forName((Class)RMIGenerator2.getComponentType(ptype)) : (spec instanceof Class ? ch.class_forName((Class)((Class)spec)) : mc.args[(Integer)spec]);
                    MethodRef md_cp = new MethodRef(class_SessionExt, "createProxyObject", "(Ljava/lang/Class;" + RMIGenerator2.getObjectType(ptype) + ")" + RMIGenerator2.getReferenceType(ptype));
                    Unit[] cp_args = new Unit[]{clsType, mc.args[i]};
                    InvokeVirtual ref = new InvokeVirtual(RMIGenerator2.field_ctx(mc), md_cp, cp_args);
                    write_args[0] = ref;
                    _try.append((Unit)new InvokeVirtual((Unit)out, md_writeObject, write_args));
                    continue;
                }
                _try.append((Unit)new InvokeVirtual((Unit)out, md_writeObject, write_args));
            }
        }
        Unit[] fi_args = new Unit[]{ob};
        _try.append((Unit)new Assign(r, (Unit)new InvokeVirtual(RMIGenerator2.field_ctx(mc), md_finishInvoke, fi_args)));
        Try.CatchBlock cb = _try._catch("java/lang/Exception", "e");
        cb.append((Unit)new InvokeVirtual(RMIGenerator2.field_ctx(mc), md_invokeFailed, new Unit[0]));
        Unit[] cre_args = new Unit[]{cb.e};
        cb.append((Unit)new Throw((Unit)new InvokeStatic(md_createRMIException, cre_args)));
        If _if = new If((Unit)new Cmp((Unit)new GetField((Unit)r, field_state), "==", (Unit)new Value(1)));
        mc.append((Unit)_if);
        _if.append((Unit)new Throw((Unit)new CheckCast((Unit)new GetField((Unit)r, field_value), "java/lang/Throwable")));
        CheckCast retValue = null;
        GetField r_value = new GetField((Unit)r, field_value);
        if (RMIParameterSpecial.isSerial(type)) {
            if (type.isPrimitive()) {
                if (type.equals(Boolean.TYPE)) {
                    retValue = new InvokeVirtual((Unit)new CheckCast((Unit)r_value, "java/lang/Boolean"), md_booleanValue, new Unit[0]);
                } else if (type.equals(Character.TYPE)) {
                    retValue = new InvokeVirtual((Unit)new CheckCast((Unit)r_value, "java/lang/Character"), md_charValue, new Unit[0]);
                } else if (type.equals(Byte.TYPE)) {
                    retValue = new InvokeVirtual((Unit)new CheckCast((Unit)r_value, "java/lang/Number"), md_byteValue, new Unit[0]);
                } else if (type.equals(Short.TYPE)) {
                    retValue = new InvokeVirtual((Unit)new CheckCast((Unit)r_value, "java/lang/Number"), md_shortValue, new Unit[0]);
                } else if (type.equals(Integer.TYPE)) {
                    retValue = new InvokeVirtual((Unit)new CheckCast((Unit)r_value, "java/lang/Number"), md_intValue, new Unit[0]);
                } else if (type.equals(Long.TYPE)) {
                    retValue = new InvokeVirtual((Unit)new CheckCast((Unit)r_value, "java/lang/Number"), md_longValue, new Unit[0]);
                } else if (type.equals(Float.TYPE)) {
                    retValue = new InvokeVirtual((Unit)new CheckCast((Unit)r_value, "java/lang/Number"), md_floatValue, new Unit[0]);
                } else if (type.equals(Double.TYPE)) {
                    retValue = new InvokeVirtual((Unit)new CheckCast((Unit)r_value, "java/lang/Number"), md_doubleValue, new Unit[0]);
                }
            } else {
                retValue = new CheckCast((Unit)r_value, sc.className(type));
            }
            mc.append((Unit)new Return((Unit)retValue));
        } else {
            IsNull cond = new IsNull((Unit)new GetField((Unit)r, field_value));
            If _ifnull = new If((Unit)cond);
            mc.append((Unit)_ifnull);
            _ifnull.append((Unit)new Return((Unit)Value.NULL));
            Object spec = RMIParameterSpecial.getSpecial(md, -1);
            Object clsType = spec == null ? ch.class_forName((Class)RMIGenerator2.getComponentType(type)) : (spec instanceof Class ? ch.class_forName((Class)((Class)spec)) : mc.args[(Integer)spec]);
            String refType = RMIGenerator2.getReferenceType(type);
            String objType = RMIGenerator2.getObjectType(type);
            MethodRef md_cs = new MethodRef(class_SessionExt, "createStubObject", "(Ljava/lang/Class;" + refType + ")" + objType);
            Unit[] cs_args = new Unit[]{clsType, new CheckCast((Unit)r_value, sc.className((String)refType))};
            retValue = new CheckCast((Unit)new InvokeVirtual(RMIGenerator2.field_ctx(mc), md_cs, cs_args), sc.className(type));
            mc.append((Unit)new Return((Unit)retValue));
        }
        return mc;
    }

    private static Class getComponentType(Class type) {
        if (type.isArray()) {
            return RMIGenerator2.getComponentType(type.getComponentType());
        }
        return type;
    }
}

