/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.core.rmi;

import com.kingdee.bos.orm.IEventContainer;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.IObjectFactory;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.orm.core.rmi.InvokeResult;
import com.kingdee.bos.orm.core.rmi.LocalReference;
import com.kingdee.bos.orm.core.rmi.ObjectProxy;
import com.kingdee.bos.orm.core.rmi.ObjectStub;
import com.kingdee.bos.orm.core.rmi.RMIEngine;
import com.kingdee.bos.orm.core.rmi.ReferenceCounter;
import com.kingdee.bos.orm.core.rmi.RemoteReference;
import com.kingdee.bos.orm.core.rmi.StubContext;
import com.kingdee.bos.orm.impl.service.OutputBlock;
import com.kingdee.bos.orm.io.IConnection;
import com.kingdee.bos.orm.rmi.IRMISession;
import com.kingdee.bos.orm.rmi.RMIException;
import com.kingdee.bos.orm.service.IServiceSession;
import com.kingdee.bos.orm.service.IServiceSessionEvent;
import com.kingdee.bos.orm.template.ObjectContext;
import com.kingdee.bos.util.EasyTool;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Map;

public class RMISession
extends ObjectContext
implements IRMISession,
IServiceSessionEvent {
    private final IServiceSession session;
    private final IConnection cn;
    private static final String RMISESSION = "RMISession";
    private IObjectFactory objectFactory = null;
    private final RMISessionProxy sessionProxy = new RMISessionProxy(this);
    private final Hashtable proxys = new Hashtable();
    private final Hashtable proxyRefs = new Hashtable();
    private final Hashtable stubs = new Hashtable();
    protected boolean closed = false;
    private static final String METHOD_SIG_SEND = "_rmi_method_sig_send";
    private static final String METHOD_SIG_RECV = "_rim_method_sig_recv";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RMISession getRMISession(IServiceSession session) {
        IServiceSession iServiceSession = session;
        synchronized (iServiceSession) {
            RMISession x = (RMISession)session.get(RMISESSION);
            if (x == null) {
                x = new RMISession(session);
            }
            return x;
        }
    }

    public RMISession(IServiceSession _session) {
        this(_session, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMISession(IServiceSession _session, IORMModel owner) {
        super(owner);
        super.registerInterface(IObjectFactory.class, this);
        super.registerInterface(IServiceSessionEvent.class, this);
        this.session = _session;
        this.session.put(RMISESSION, this);
        IEventContainer ec = (IEventContainer)this.session.queryInterface(IEventContainer.class);
        ec.addEventListener(IServiceSessionEvent.class, this);
        IConnection iConnection = this.cn = this.session.getConnection();
        synchronized (iConnection) {
            if (this.cn.get(METHOD_SIG_SEND) == null) {
                this.cn.put(METHOD_SIG_SEND, new method_sig_send());
                this.cn.put(METHOD_SIG_RECV, new method_sig_recv());
            }
        }
    }

    public byte[] invoke(byte[] requestData) throws ORMCoreException {
        return this.session.invoke("ORM_RMI_CALL", requestData);
    }

    @Override
    public IORMModel createObject(String objectName, Class model) throws ORMCoreException {
        return this.createRemoteObject(null, objectName, model);
    }

    @Override
    public IORMModel createRemoteObject(String serverUrl, String objectName, Class model) throws ORMCoreException {
        return this.createRemoteObject(serverUrl, objectName, model, new Class[0], new Object[0]);
    }

    @Override
    public IORMModel createObject(String objectName, Class model, Class[] initArgTypes, Object[] initArgs) throws ORMCoreException {
        return this.createRemoteObject(null, objectName, model, initArgTypes, initArgs);
    }

    @Override
    public IORMModel createRemoteObject(String serverUrl, String objectName, Class model, Class[] initArgTypes, Object[] initArgs) throws ORMCoreException {
        InvokeResult r = null;
        StubContext ctx = new StubContext(this, model, new RemoteReference(0L));
        try {
            OutputBlock ob = ctx.startInvoke("createRemoteObject(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Lcom/kingdee/bos/orm/IORMModel;");
            ob.out.writeObject(serverUrl);
            ob.out.writeObject(objectName);
            ob.out.writeObject(model);
            ob.out.writeObject(initArgTypes);
            ob.out.writeObject(initArgs);
            r = ctx.finishInvoke(ob);
        }
        catch (Exception e) {
            throw RMIException.createRMIException(e);
        }
        if (r.state == 0) {
            return (IORMModel)ctx.createStubObject(model, (RemoteReference)r.value);
        }
        if (r.value instanceof Error) {
            throw (Error)r.value;
        }
        if (r.value instanceof ORMCoreException) {
            throw (ORMCoreException)r.value;
        }
        throw RMIException.createRMIException((Throwable)r.value);
    }

    @Override
    public IServiceSession getServiceSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectProxy getObjectProxy(RemoteReference ref) {
        if (ref.id == 0L) {
            return this.sessionProxy;
        }
        Hashtable hashtable = this.proxys;
        synchronized (hashtable) {
            return (ObjectProxy)this.proxys.get(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseObjectStub(StubContext ctx) {
        ReferenceCounter counter = this.getStubCounter(ctx.ref, false);
        boolean bf = false;
        Hashtable hashtable = this.stubs;
        synchronized (hashtable) {
            boolean bl = bf = counter != null && counter.release() == 0;
            if (bf) {
                this.stubs.remove(ctx.ref);
            }
        }
        if (bf) {
            try {
                OutputBlock ob = ctx.startInvoke("finalize()V");
                ctx.finishInvoke(ob);
            }
            catch (Exception _) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseObjectProxy(RemoteReference ref) {
        Hashtable hashtable = this.proxys;
        synchronized (hashtable) {
            ObjectProxy proxy;
            if (ref != null && ref.id != 0L && (proxy = (ObjectProxy)this.proxys.remove(ref)) != null) {
                this.proxyRefs.remove(new RefKey(proxy.source, proxy.model));
            }
        }
    }

    protected RemoteReference createObjectProxy(Object object, Class model) throws RMIException {
        if (object instanceof ObjectStub) {
            ObjectStub stub = (ObjectStub)object;
            if (stub.ctx.session == this) {
                return new LocalReference(stub.ctx.ref);
            }
        }
        return this.createObjectProxy0(object, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteReference createObjectProxy0(Object object, Class model) throws RMIException {
        if (object == null) {
            return null;
        }
        RefKey refKey = new RefKey(object, model);
        Hashtable hashtable = this.proxys;
        synchronized (hashtable) {
            RemoteReference ref = (RemoteReference)this.proxyRefs.get(refKey);
            if (ref != null) {
                return ref;
            }
            ObjectProxy proxy = RMIEngine.createObjectProxy(this, object, model);
            ref = new RemoteReference();
            this.proxys.put(ref, proxy);
            this.proxyRefs.put(refKey, ref);
            return ref;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createStubContext(RemoteReference ref, Class model) throws RMIException {
        if (ref instanceof LocalReference) {
            Hashtable hashtable = this.proxys;
            synchronized (hashtable) {
                ObjectProxy proxy = (ObjectProxy)this.proxys.get(ref);
                if (proxy != null) {
                    return proxy.source;
                }
            }
        }
        return this.createStubContext0(ref, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCounter getStubCounter(RemoteReference ref, boolean create) {
        Hashtable hashtable = this.stubs;
        synchronized (hashtable) {
            ReferenceCounter counter = (ReferenceCounter)this.stubs.get(ref);
            if (counter == null && create) {
                counter = new ReferenceCounter(ref);
                this.stubs.put(ref, counter);
            }
            return counter;
        }
    }

    Object createStubContext0(RemoteReference ref, Class model) throws RMIException {
        if (ref == null) {
            return null;
        }
        Object stub = RMIEngine.createObjectStub(new StubContext(this, model, ref), model);
        this.getStubCounter(ref, true).addRef();
        return stub;
    }

    @Override
    public void sessionClosed(IServiceSession session) {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                IEventContainer ec = (IEventContainer)this.session.queryInterface(IEventContainer.class);
                ec.removeEventListener(IServiceSessionEvent.class, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.session.close();
            Hashtable hashtable = this.proxys;
            synchronized (hashtable) {
                this.proxys.clear();
                this.proxyRefs.clear();
                this.stubs.clear();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeMethodSig(ObjectOutputStream out, String methodsig) throws IOException {
        int index;
        boolean isnew;
        method_sig_send ms;
        method_sig_send method_sig_send2 = ms = (method_sig_send)this.cn.get(METHOD_SIG_SEND);
        synchronized (method_sig_send2) {
            Integer idx = (Integer)ms.names.get(methodsig);
            if (idx != null) {
                isnew = false;
                index = idx;
            } else {
                isnew = true;
                index = ms.index++;
                ms.names.put(methodsig, index);
            }
        }
        out.writeInt(index);
        if (isnew) {
            EasyTool.writeString((ObjectOutputStream)out, (String)methodsig);
        } else {
            EasyTool.writeString((ObjectOutputStream)out, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readMethodSig(ObjectInputStream in) throws IOException, InterruptedException {
        method_sig_recv ms;
        int index = in.readInt();
        String methodsig = EasyTool.readString((ObjectInputStream)in);
        method_sig_recv method_sig_recv2 = ms = (method_sig_recv)this.cn.get(METHOD_SIG_RECV);
        synchronized (method_sig_recv2) {
            if (methodsig == null) {
                methodsig = (String)ms.indexs.get(index);
                if (methodsig == null) {
                    ms.wait();
                    methodsig = (String)ms.indexs.get(index);
                }
            } else {
                ms.indexs.put(index, methodsig);
                ms.notifyAll();
            }
        }
        if (methodsig == null) {
            throw new RMIException("methodsig#" + index + " not found.");
        }
        return methodsig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String readClientMethodSig(ObjectInputStream in) throws IOException {
        method_sig_send ms;
        int index = in.readInt();
        method_sig_send method_sig_send2 = ms = (method_sig_send)this.cn.get(METHOD_SIG_SEND);
        synchronized (method_sig_send2) {
            for (Map.Entry entry : ms.names.entrySet()) {
                if (!entry.getValue().equals(index)) continue;
                return (String)entry.getKey();
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private static class method_sig_recv {
        Hashtable indexs = new Hashtable();

        private method_sig_recv() {
        }
    }

    private static class method_sig_send {
        Hashtable names = new Hashtable();
        int index = 1;

        private method_sig_send() {
        }
    }

    class RefKey {
        Object obj;
        Class model;

        RefKey(Object _obj, Class _model) {
            this.obj = _obj;
            this.model = _model;
        }

        public int hashCode() {
            return this.obj.hashCode() ^ this.model.hashCode();
        }

        public boolean equals(Object x) {
            if (x == null) {
                return false;
            }
            if (this == x) {
                return true;
            }
            if (!(x instanceof RefKey)) {
                return false;
            }
            RefKey r = (RefKey)x;
            return r.obj == this.obj && r.model.equals(this.model);
        }
    }

    class RMISessionProxy
    extends ObjectProxy {
        RMISessionProxy(RMISession _session) {
            super(_session, null, null);
        }

        @Override
        public InvokeResult processInvoke(String method, ObjectInputStream in) throws Exception {
            if (method.equals("createRemoteObject(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)Lcom/kingdee/bos/orm/IORMModel;")) {
                String serverUrl = (String)in.readObject();
                String objectName = (String)in.readObject();
                Class model = (Class)in.readObject();
                Class[] initArgTypes = (Class[])in.readObject();
                Object[] initArgs = (Object[])in.readObject();
                try {
                    IORMModel object = serverUrl == null ? ORMEngine.createObject(objectName, model, initArgTypes, initArgs) : ORMEngine.createRemoteObject(serverUrl, objectName, model, initArgTypes, initArgs);
                    return new InvokeResult(0, RMISession.this.createObjectProxy(object, model));
                }
                catch (Exception e) {
                    return new InvokeResult(1, ORMCoreException.create(e));
                }
            }
            return super.processInvoke(method, in);
        }
    }
}

