/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.core.rmi;

import com.kingdee.bos.orm.core.rmi.InvokeResult;
import com.kingdee.bos.orm.core.rmi.MonitorDisableList;
import com.kingdee.bos.orm.core.rmi.RMIMonitorFactory;
import com.kingdee.bos.orm.core.rmi.RMISession;
import com.kingdee.bos.orm.core.rmi.RemoteReference;
import com.kingdee.bos.orm.core.rmi.SessionExt;
import com.kingdee.bos.orm.impl.service.InputBlock;
import com.kingdee.bos.orm.impl.service.OutputBlock;
import com.kingdee.bos.orm.rmi.RMIException;
import org.apache.log4j.Logger;

public class StubContext
extends SessionExt {
    public final RemoteReference ref;
    private long interval = 0L;
    public final Class model;
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.orm.core.rmi.StubContext");
    private String method = null;

    public StubContext(RMISession _session, Class _model, RemoteReference _ref) {
        super(_session);
        this.ref = _ref;
        this.model = _model;
    }

    public OutputBlock startInvoke(String method) throws Exception {
        this.method = method;
        this.interval = System.currentTimeMillis();
        OutputBlock ob = new OutputBlock();
        ob.out.writeLong(this.ref.id);
        this.session.writeMethodSig(ob.out, method);
        return ob;
    }

    public InvokeResult finishInvoke(OutputBlock ob) throws Exception {
        byte[] outData = ob.getData();
        byte[] rtv = this.session.invoke(outData);
        int invokelen = rtv.length;
        InputBlock ib = new InputBlock(this.model, rtv);
        InvokeResult r = InvokeResult.read(ib.in);
        if (!MonitorDisableList.getInstance().isIgnore(this.model)) {
            RMIMonitorFactory.getRMIMonitor().trace(this.session, outData, r);
        }
        if (r.state == 1) {
            Throwable e = (Throwable)r.value;
            try {
                Throwable cause = (Throwable)e.getClass().getMethod("getCause", new Class[0]).invoke((Object)e, new Object[0]);
                Class[] pt = new Class[]{Throwable.class};
                Object[] pv = new Object[]{new RMIException(cause)};
                e.getClass().getMethod("initCause", pt).invoke((Object)e, pv);
            }
            catch (Exception _) {
                e.fillInStackTrace();
            }
            r = new InvokeResult(r.state, e);
        }
        if (RMIMonitorFactory.getRMIMonitor().getTimerState() == 1 && this.interval != 0L) {
            RMIMonitorFactory.getRMIMonitor().addInterval(System.currentTimeMillis() - this.interval);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("InvokeMonitor: Class[" + this.model.getName() + "] - method[" + this.method + "] Datalength[" + invokelen + "] used[" + (System.currentTimeMillis() - this.interval) + "]ms"));
        }
        this.method = null;
        this.interval = 0L;
        return r;
    }

    public void invokeFailed() {
    }
}

