/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.server;

import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.orm.impl.server.ORMRPConfig1;
import com.kingdee.bos.orm.impl.service.SessionServer;
import com.kingdee.bos.orm.loadbalance.BalanceConfig;
import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.RPCEngine;
import com.kingdee.bos.rpc.healthdegree.HealthDegree;
import com.kingdee.bos.rpc.healthdegree.IHealthDegree;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.rpcwrapper.RPCObjectMarshaller;
import com.kingdee.util.IPUtils;
import com.kingdee.util.StringUtils;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ORMRPConfig {
    private static final Logger logger = Logger.getLogger(ORMRPConfig.class);
    public static final String ORMRPC_CONFIG = "ormrpc.config";
    public static final String ORMRPC_PROPERTIES = "ormrpc.properties";
    public static final String COMPRESS_SIZE = "compressSize";
    public static final String MAX_THREAD_COUNT = "maxThreadCount";
    public static final String CONNECTION_THREAD_IN_POOL = "connectionThreadInPool";
    public static final String TCP_CONNECTION_PORT = "tcpConnectionPort";
    public static final String SSL_CONNECTION_PORT = "sslConnectionPort";
    public static final String MAX_POOLED_THREAD_COUNT = "maxPooledThread";
    public static final String MIN_POOLED_THREAD_COUNT = "minPooledThread";
    public static final String HTTP_IDLE_TIMEOUT = "httpIdleTimeout";
    public static final String IS_LOAD_BALANCE_MODE = "loadbalance";
    public static final String BALANCE_SERVER_PREFIX = "loadbalance.";
    public static final String SUPPORT_SSL = "supportSSL";
    public static final String USE_OLDRPC = "oldrpc";
    public static final String ENABLE_SERVER_FINDER = "enableServerFinder";
    public static final String NORMALRESPONSETIME = "normalResponseTime";
    private static boolean isUseOldRPC = false;
    private static boolean enableServerFinder = false;
    public static final String MAX_INVOKE_DATASIZE = "maxInvokeDataSize";
    public static final String NIO = "nio";
    public static final String netty = "netty";
    public static final int COMPRESS_DEFAULT = 1024;
    private static int compressSize = 1024;
    private static int maxThreadCount = 50;
    public static final String SOCKETPOOLSIZE = "socketPoolSize";
    public static final String EXCEEDPOOLSOCKETTIMEOUT = "exceedPoolSocketTimeout";
    public static final String DEFAULTSOCKETTIMEOUT = "defaultSocketTimeout";
    private static boolean connectionThreadInPool = false;
    private static int maxPooledThreadCount = 30;
    private static int minPooledThreadCount = 0;
    private static int httpIdleTimeout = 3000;
    private static int maxInvokeDataSize = 0x3200000;
    private static boolean banlanceMode = false;
    private static BalanceConfig[] balanceServers;
    private static BalanceConfig[] cclServers;
    private static boolean isLoaded;
    private static boolean isNIO;
    private static boolean isSocketKeepAlive;
    private static boolean isTestSocketBeforeUse;
    private static long normalResponseTime;
    private static boolean isNetty;
    public static final String DEFAULT_SERVER_FINDER_CLASS = "com.kingdee.bos.rpc_availability.urllist.UrlListServerFinder";

    public static boolean isLoaded() {
        return isLoaded;
    }

    public static void loadConfig() {
        if (ORMRPConfig.isLoaded()) {
            return;
        }
        ORMRPConfig.loadConfig("default");
        isLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadConfig(String serverName) {
        String config = null;
        config = System.getProperty(ORMRPC_CONFIG);
        if (StringUtils.isEmpty((String)config)) {
            config = ORMRPC_PROPERTIES;
        }
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(config);
            Properties props = new Properties();
            props.load(fs);
            ORMRPConfig.loadConfig(props, serverName);
            logger.info((Object)("ORM load config file from [" + config + "]  for server [" + serverName + "]"));
        }
        catch (Exception ignore) {
            logger.error((Object)("ORMRPC cannot load config file from [" + config + "]"), (Throwable)ignore);
            RPCConfig conf = new RPCConfig();
            ServerManager.setConfig(serverName, conf);
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (Exception ignore) {}
        }
        RPCConfig conf = ServerManager.getConfig(serverName).copy();
        conf.objectMarshaler = new RPCObjectMarshaller();
        ServerManager.setConfig(serverName, conf);
        if ("default".equalsIgnoreCase(serverName)) {
            isLoaded = true;
        }
    }

    private static void loadConfig(Properties prop, String serverName) {
        String temp;
        String isEnableServerFinderStr;
        String nty;
        String isNioStr;
        String isTestSocketBeforeUseStr;
        String isSocketKeepAliveStr;
        String isOldRPCStr = ORMRPConfig.getProperty(prop, USE_OLDRPC, serverName);
        if (ORMRPConfig.isTrue(isOldRPCStr)) {
            isUseOldRPC = true;
        }
        if (ORMRPConfig.isTrue(isSocketKeepAliveStr = ORMRPConfig.getProperty(prop, "socketKeepAlive", serverName))) {
            isSocketKeepAlive = true;
        }
        if (ORMRPConfig.isTrue(isTestSocketBeforeUseStr = ORMRPConfig.getProperty(prop, "testSocketBeforeUse", serverName))) {
            isTestSocketBeforeUse = true;
        }
        if (ORMRPConfig.isTrue(isNioStr = ORMRPConfig.getProperty(prop, NIO, serverName))) {
            isNIO = true;
        }
        if (ORMRPConfig.isTrue(nty = ORMRPConfig.getProperty(prop, netty, serverName, "true"))) {
            isNetty = true;
        }
        if (ORMRPConfig.isTrue(isEnableServerFinderStr = ORMRPConfig.getProperty(prop, ENABLE_SERVER_FINDER, serverName))) {
            enableServerFinder = true;
        }
        compressSize = ORMRPConfig.getIntProperty(prop, COMPRESS_SIZE, serverName, 1024);
        maxThreadCount = ORMRPConfig.getIntProperty(prop, MAX_THREAD_COUNT, serverName, 50);
        SessionServer.setMaxServiceCount(maxThreadCount);
        String booleanStr = ORMRPConfig.getProperty(prop, CONNECTION_THREAD_IN_POOL, serverName, "false");
        if (ORMRPConfig.isTrue(booleanStr)) {
            SessionServer.connectionThreadInPool = connectionThreadInPool = true;
        }
        maxPooledThreadCount = ORMRPConfig.getIntProperty(prop, MAX_POOLED_THREAD_COUNT, serverName, 30);
        minPooledThreadCount = ORMRPConfig.getIntProperty(prop, MIN_POOLED_THREAD_COUNT, serverName, 0);
        ORMEngine.setThreadPoolSize(minPooledThreadCount, maxPooledThreadCount);
        httpIdleTimeout = ORMRPConfig.getIntProperty(prop, HTTP_IDLE_TIMEOUT, serverName, 3000);
        String normalResponeTimeStr = ORMRPConfig.getProperty(prop, NORMALRESPONSETIME, serverName, "100");
        normalResponseTime = Long.valueOf(normalResponeTimeStr);
        if (balanceServers == null && ORMRPConfig.isTrue(temp = prop.getProperty(IS_LOAD_BALANCE_MODE, "false"))) {
            banlanceMode = true;
            balanceServers = ORMRPConfig.loadBalanceConfig(prop, BALANCE_SERVER_PREFIX);
        }
        maxInvokeDataSize = ORMRPConfig.getSizeProperty(prop, MAX_INVOKE_DATASIZE, serverName, maxInvokeDataSize);
        RPCConfig rpcconfig = new RPCConfig();
        rpcconfig.socketKeepAlive = isSocketKeepAlive;
        rpcconfig.testSocketBeforeUse = isTestSocketBeforeUse;
        rpcconfig.maxServiceThreadCount = maxThreadCount;
        rpcconfig.threadPoolMaxSize = maxPooledThreadCount;
        rpcconfig.threadPoolMinSize = minPooledThreadCount;
        rpcconfig.normalResponseTime = normalResponseTime;
        if (compressSize <= maxInvokeDataSize) {
            rpcconfig.minCompressSize = compressSize;
        }
        rpcconfig.maxInvokeDataSize = maxInvokeDataSize;
        rpcconfig.maxCompressedDataSize = ORMRPConfig.getSizeProperty(prop, "maxCompressedDataSize", serverName, rpcconfig.maxCompressedDataSize);
        rpcconfig.socketPoolSize = ORMRPConfig.getIntProperty(prop, SOCKETPOOLSIZE, serverName, rpcconfig.socketPoolSize);
        rpcconfig.exceedPoolSocketTimeout = ORMRPConfig.getIntProperty(prop, EXCEEDPOOLSOCKETTIMEOUT, serverName, rpcconfig.exceedPoolSocketTimeout);
        rpcconfig.defaultSocketTimeout = ORMRPConfig.getIntProperty(prop, DEFAULTSOCKETTIMEOUT, serverName, rpcconfig.defaultSocketTimeout);
        ORMRPConfig1.loadNewRPCConfig(prop, rpcconfig, serverName);
        ORMRPConfig.loadHealthDegreeConfig(rpcconfig, prop);
        if (serverName.startsWith("ccl")) {
            cclServers = ORMRPConfig.loadBalanceConfig(prop, serverName + ".");
        }
        ServerManager.setConfig(serverName, rpcconfig);
    }

    public static String getProperty(Properties prop, String key, String serverName) {
        String value = prop.getProperty(serverName + "." + key);
        if (value != null) {
            return value;
        }
        return prop.getProperty(key);
    }

    public static String getProperty(Properties prop, String key, String serverName, String defaultValue) {
        String value = prop.getProperty(serverName + "." + key);
        if (value != null) {
            return value;
        }
        return prop.getProperty(key, defaultValue);
    }

    public static boolean isTrue(String s) {
        if (s == null) {
            return false;
        }
        return "Yes".equalsIgnoreCase(s) || "Y".equalsIgnoreCase(s) || "True".equalsIgnoreCase(s) || "1".equalsIgnoreCase(s);
    }

    private static BalanceConfig[] loadBalanceConfig(Properties prop, String prefix) {
        ArrayList<BalanceConfig> sers = new ArrayList<BalanceConfig>();
        int i = 0;
        while (prop.containsKey(prefix + i)) {
            String url = prop.getProperty(prefix + i);
            BalanceConfig server = new BalanceConfig(url);
            sers.add(server);
            Enumeration<Object> e = prop.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(prefix + i + ".")) continue;
                String value = prop.getProperty(key);
                server.getServerProperties().put(key.substring((prefix + i + ".").length()), value);
            }
            ++i;
        }
        return sers.toArray(new BalanceConfig[0]);
    }

    private static int getIntProperty(Properties props, String name, String serverName, int defalut) {
        if (props.containsKey(serverName + "." + name)) {
            return Integer.parseInt(props.getProperty(serverName + "." + name));
        }
        if (props.containsKey(name)) {
            return Integer.parseInt(props.getProperty(name));
        }
        return defalut;
    }

    public static int getSizeProperty(Properties props, String name, String serverName, int defalut) {
        String sSize = props.getProperty(serverName + "." + name, props.getProperty(name));
        if (sSize == null) {
            return defalut;
        }
        sSize = sSize.toLowerCase().trim();
        int factor = 1;
        if (sSize.endsWith("k")) {
            sSize = sSize.substring(0, sSize.length() - 1);
            factor = 1024;
        } else if (sSize.endsWith("m")) {
            sSize = sSize.substring(0, sSize.length() - 1);
            factor = 0x100000;
        } else if (sSize.endsWith("g")) {
            sSize = sSize.substring(0, sSize.length() - 1);
            factor = 0x40000000;
        }
        try {
            int size = Integer.parseInt(sSize);
            return size * factor;
        }
        catch (NumberFormatException e) {
            return defalut;
        }
    }

    public static int getHttpIdleTimeout() {
        return httpIdleTimeout;
    }

    public static int getCompressSize() {
        return compressSize;
    }

    public static void setCompressSize(int compressSize) {
        ORMRPConfig.compressSize = compressSize;
    }

    public static boolean isUseOldRpc() {
        return isUseOldRPC;
    }

    public static boolean isSocketKeepAlive() {
        return isSocketKeepAlive;
    }

    public static boolean isTestSocketBeforeUse() {
        return isTestSocketBeforeUse;
    }

    public static int getMaxPooledThreadCount() {
        return maxPooledThreadCount;
    }

    public static int getMaxThreadCount() {
        return maxThreadCount;
    }

    public static int getMinPooledThreadCount() {
        return minPooledThreadCount;
    }

    public static int getTcpConnectionPort() {
        return ServerManager.getConfig((String)"default").tcpConnectionPort;
    }

    public static String getRPCListeningURL(boolean getCanonicalHostName) {
        if (getCanonicalHostName) {
            try {
                String hostName = InetAddress.getLocalHost().getCanonicalHostName();
                return "tcp://" + hostName + ":" + ServerManager.getConfig().tcpConnectionPort;
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        String hostAddress = null;
        try {
            if (RPCEngine.getCurrentServerSession() != null) {
                hostAddress = RPCEngine.getCurrentServerSession().getServerIp();
            }
        }
        catch (Exception ex) {
            logger.warn((Object)ex, (Throwable)ex);
        }
        try {
            if (hostAddress == null) {
                hostAddress = IPUtils.getLocleAddress().getHostAddress();
            }
            return "tcp://" + hostAddress + ":" + ServerManager.getConfig().tcpConnectionPort;
        }
        catch (Exception e) {
            logger.warn((Object)e, (Throwable)e);
            return null;
        }
    }

    public static String getRpcClientIP() {
        String hostAddress = null;
        try {
            if (RPCEngine.getCurrentServerSession() != null) {
                hostAddress = RPCEngine.getCurrentServerSession().getClientIp();
            }
        }
        catch (Exception ex) {
            logger.warn((Object)ex, (Throwable)ex);
        }
        return hostAddress;
    }

    public static boolean isNIO() {
        return isNIO;
    }

    public static boolean isNetty() {
        return isNetty;
    }

    public static boolean isBalanceMode() {
        return banlanceMode;
    }

    public static boolean supportSSL() {
        return ServerManager.getDefaultConfig().supportSSL;
    }

    public static BalanceConfig[] getBalanceServers() {
        if (balanceServers == null) {
            return new BalanceConfig[0];
        }
        return balanceServers;
    }

    public static BalanceConfig[] getCclServers() {
        if (cclServers == null) {
            return new BalanceConfig[0];
        }
        return cclServers;
    }

    public static String getServerFinderClass() {
        return DEFAULT_SERVER_FINDER_CLASS;
    }

    public static boolean isEnableServerFinder() {
        return enableServerFinder;
    }

    public static int getSSLConnectionPort() {
        return ServerManager.getDefaultConfig().sslConnectionPort;
    }

    private static void loadHealthDegreeConfig(RPCConfig config, Properties prop) {
        if (!prop.containsKey("hd.0")) {
            return;
        }
        HealthDegree hd = new HealthDegree();
        if (prop.containsKey("hd.expression")) {
            hd.setExpression(prop.getProperty("hd.expression"));
        }
        try {
            int i = 0;
            while (prop.containsKey("hd." + i)) {
                String className = prop.getProperty("hd." + i);
                Class<?> c = Class.forName(className.trim());
                IHealthDegree de = (IHealthDegree)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                hd.addHealthDegreeItem(de);
                Enumeration<Object> e = prop.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (!key.startsWith("hd." + i + ".")) continue;
                    String value = prop.getProperty(key);
                    String tmp = key.substring(key.lastIndexOf(".") + 1);
                    String m = "set" + StringUtils.headCharUpperCase((String)tmp);
                    Class[] type = new Class[]{Integer.TYPE};
                    try {
                        Method method = c.getMethod(m, type);
                        Object[] args = new Object[]{Integer.valueOf(value.trim())};
                        method.invoke((Object)de, args);
                    }
                    catch (NoSuchMethodException ex) {
                        Class[] type2 = new Class[]{Float.TYPE};
                        try {
                            Method method = c.getMethod(m, type2);
                            Object[] args = new Object[]{Float.valueOf(value.trim())};
                            method.invoke((Object)de, args);
                        }
                        catch (NoSuchMethodException ex2) {}
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        config.healthDegree = hd;
    }

    static {
        isLoaded = false;
        isNIO = false;
        isSocketKeepAlive = false;
        isTestSocketBeforeUse = false;
        normalResponseTime = 1L;
        isNetty = false;
    }
}

