/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.server;

import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.rpc.RPCConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ORMRPConfig1 {
    private static final Logger logger = Logger.getLogger(ORMRPConfig1.class);

    private static boolean getBooleanProperty(Properties props, String name, String serverName, boolean defalut) {
        String booleanStr = props.getProperty(serverName + "." + name, props.getProperty(name));
        if (booleanStr == null) {
            return defalut;
        }
        if (!defalut) {
            if (ORMRPConfig.isTrue(booleanStr)) {
                return true;
            }
        } else if (ORMRPConfig1.isFalse(booleanStr)) {
            return false;
        }
        return defalut;
    }

    public static void loadNewRPCConfig(Properties props, RPCConfig config, String serverName) {
        Field[] fields = RPCConfig.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Boolean bl;
            Class<?> type = fields[i].getType();
            int mod = fields[i].getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isStatic(mod) || props.getProperty(fields[i].getName()) == null && props.getProperty(serverName + "." + fields[i].getName()) == null) continue;
            if (type.equals(String.class)) {
                try {
                    fields[i].set(config, ORMRPConfig.getProperty(props, fields[i].getName(), serverName));
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            if (type.equals(Integer.TYPE)) {
                try {
                    int defaultSize = fields[i].getInt(config);
                    fields[i].setInt(config, ORMRPConfig.getSizeProperty(props, fields[i].getName(), serverName, defaultSize));
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            if (type.equals(Long.TYPE)) {
                try {
                    long defaultSize = fields[i].getLong(config);
                    fields[i].setLong(config, ORMRPConfig1.getLongProperty(props, fields[i].getName(), serverName, defaultSize));
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            if (type.equals(Boolean.TYPE)) {
                try {
                    boolean defaultValue = fields[i].getBoolean(config);
                    fields[i].setBoolean(config, ORMRPConfig1.getBooleanProperty(props, fields[i].getName(), serverName, defaultValue));
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            if (!type.equals(Boolean.class) || (bl = ORMRPConfig1.getBooleanProperty(props, fields[i].getName(), serverName)) == null) continue;
            try {
                fields[i].set(config, bl);
                continue;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    private static long getLongProperty(Properties props, String name, String serverName, long defaultSize) {
        String sSize = props.getProperty(serverName + "." + name, props.getProperty(name));
        if (sSize == null) {
            return defaultSize;
        }
        sSize = sSize.toLowerCase().trim();
        int factor = 1;
        if (sSize.endsWith("k")) {
            sSize = sSize.substring(0, sSize.length() - 1);
            factor = 1024;
        } else if (sSize.endsWith("m")) {
            sSize = sSize.substring(0, sSize.length() - 1);
            factor = 0x100000;
        } else if (sSize.endsWith("g")) {
            sSize = sSize.substring(0, sSize.length() - 2);
            factor = 0x40000000;
        }
        try {
            long size = Long.parseLong(sSize);
            return size * (long)factor;
        }
        catch (NumberFormatException e) {
            return defaultSize;
        }
    }

    private static Boolean getBooleanProperty(Properties props, String name, String serverName) {
        String booleanStr = props.getProperty(serverName + "." + name, props.getProperty(name));
        if (booleanStr == null) {
            return null;
        }
        if (ORMRPConfig.isTrue(booleanStr)) {
            return Boolean.TRUE;
        }
        if (ORMRPConfig1.isFalse(booleanStr)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static boolean isFalse(String s) {
        if (s == null) {
            return false;
        }
        return "No".equalsIgnoreCase(s) || "N".equalsIgnoreCase(s) || "False".equalsIgnoreCase(s) || "0".equalsIgnoreCase(s);
    }
}

