/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.impl.server;

import com.kingdee.bos.orm.impl.server.HttpServerImpl;
import com.kingdee.bos.rpc.io.server.ServerManager;
import com.kingdee.bos.util.EasyTool;
import com.kingdee.bos.util.ThreadPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class SimpleHttpServer
extends Thread {
    public static final String RPC_PATH = "/ormrpc";
    public String redirectServer = null;
    public static final String SERVER_NAME = "Kingdee BOS ORMRPC Http Server";
    public static final String HTTP_GET = "GET";
    public static final String HTTP_POST = "POST";
    public static final String HTTP_VER = "HTTP/1.1";
    ThreadPool threadPool;
    HttpServerImpl impl = new HttpServerImpl();
    ServerSocket svr;

    public SimpleHttpServer(ServerSocket _svr) throws IOException {
        this.svr = _svr;
        this.threadPool = new ThreadPool("SimpleHttpServer(port=" + this.svr.getLocalPort(), 3, 10);
    }

    public SimpleHttpServer(int port) throws IOException {
        this(new ServerSocket(port));
    }

    public SimpleHttpServer() throws IOException {
        this(80);
    }

    @Override
    public void run() {
        try {
            while (true) {
                Socket sock = this.svr.accept();
                this.threadPool.run((Runnable)new Connection(sock));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
        try {
            int port = 80;
            if (args.length > 0) {
                port = Integer.parseInt(args[0]);
            }
            SimpleHttpServer server = new SimpleHttpServer(port);
            if (args.length > 1) {
                server.redirectServer = args[1];
            }
            server.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Connection
    implements Runnable {
        Socket sock;
        InputStream in;
        OutputStream out;

        Connection(Socket _sock) {
            this.sock = _sock;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.sock.setTcpNoDelay(true);
                    this.in = new BufferedInputStream(this.sock.getInputStream());
                    this.out = new BufferedOutputStream(this.sock.getOutputStream(), ServerManager.getConfig().bufferedOutSize);
                    this.service();
                }
                catch (Throwable e) {
                    if (e instanceof IOException) break block2;
                    e.printStackTrace();
                }
            }
            EasyTool.closeAny((Object)this.sock);
        }

        private void service() throws Throwable {
            while (true) {
                HttpRequest req = new HttpRequest(this.in);
                if (!req.path.equalsIgnoreCase(SimpleHttpServer.RPC_PATH)) {
                    if (SimpleHttpServer.this.redirectServer == null) {
                        this.serviceNotifyMessage(req);
                        break;
                    }
                    this.serviceRedirect(req);
                    break;
                }
                if (!req.method.equalsIgnoreCase(SimpleHttpServer.HTTP_POST)) {
                    this.serviceNotifyMessage(req);
                    break;
                }
                this.serviceOrmRpc(req);
            }
        }

        private void writeLine(String line) throws IOException {
            EasyTool.writeLine((OutputStream)this.out, (String)line);
        }

        private void writeLine() throws IOException {
            EasyTool.writeLine((OutputStream)this.out);
        }

        private void writeResponseHeader() throws Throwable {
            this.writeResponseHeader(SimpleHttpServer.HTTP_VER);
        }

        private void writeResponseHeader(String httpver) throws Throwable {
            this.writeLine(httpver + " 200 OK");
            this.writeLine("Server: Kingdee BOS ORMRPC Http Server");
        }

        private void serviceNotifyMessage(HttpRequest req) throws Throwable {
            this.writeResponseHeader(req.httpver);
            this.writeLine("Content-Type: text/html");
            this.writeLine();
            this.writeLine("<HTML>");
            this.writeLine("<TITLE>Kingdee BOS ORMRPC Http Server</TITLE>");
            this.writeLine("<BODY>");
            this.writeLine("<H1>Kingdee BOS ORMRPC Http Server</H1>");
            this.writeLine("</BODY></HTML>");
            this.out.flush();
        }

        private void serviceRedirect(HttpRequest req) throws Throwable {
            Socket sock2 = null;
            try {
                int index = SimpleHttpServer.this.redirectServer.indexOf(58);
                int port = 80;
                String server = SimpleHttpServer.this.redirectServer;
                if (index >= 0) {
                    server = SimpleHttpServer.this.redirectServer.substring(0, index);
                    port = Integer.parseInt(SimpleHttpServer.this.redirectServer.substring(index + 1));
                }
                sock2 = new Socket(server, port);
            }
            catch (Exception e) {
                if (sock2 != null) {
                    EasyTool.closeAny(sock2);
                }
                this.writeLine(req.httpver + " 404 File Not Found");
                this.writeLine("Server: Kingdee BOS ORMRPC Http Server");
                this.writeLine("Content-Type: text/html");
                this.writeLine();
                this.writeLine("<HTML>");
                this.writeLine("<TITLE>HTTP 404 File Not Found</TITLE>");
                this.writeLine("<BODY>");
                this.writeLine("<H1>HTTP 404 File Not Found</H1>");
                this.writeLine("Kingdee BOS ORMRPC Http Server<BR>");
                this.writeLine("</BODY></HTML>");
                this.out.flush();
                return;
            }
            sock2.setTcpNoDelay(true);
            InputStream in2 = sock2.getInputStream();
            OutputStream out2 = sock2.getOutputStream();
            req.write(out2);
            SimpleHttpServer.this.threadPool.run((Runnable)new StreamPipe(sock2, this.in, out2));
            new StreamPipe(sock2, in2, this.out).run();
        }

        private void serviceOrmRpc(HttpRequest req) throws Throwable {
            ChunkedOutputStream co = new ChunkedOutputStream(this.out, req.httpver);
            FixedInputStream fi = new FixedInputStream(this.in, req.contentLength);
            SimpleHttpServer.this.impl.doPost(new DataInputStream(fi), new DataOutputStream(co));
            co.close();
        }
    }

    private class ChunkedOutputStream
    extends OutputStream {
        String httpver;
        OutputStream out;
        ByteArrayOutputStream data = new ByteArrayOutputStream();

        ChunkedOutputStream(OutputStream _out, String _httpver) throws IOException {
            this.out = _out;
            this.httpver = _httpver;
            EasyTool.writeLine((OutputStream)this.out, (String)(this.httpver + " 200 OK"));
            EasyTool.writeLine((OutputStream)this.out, (String)"Server: Kingdee BOS ORMRPC Http Server");
            EasyTool.writeLine((OutputStream)this.out, (String)"Transfer-Encoding: chunked");
            EasyTool.writeLine((OutputStream)this.out);
        }

        @Override
        public void write(int b) throws IOException {
            this.data.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.data.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.data.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.flush(false);
        }

        private void flush(boolean force) throws IOException {
            byte[] b = this.data.toByteArray();
            if (b.length == 0 && !force) {
                return;
            }
            EasyTool.writeLine((OutputStream)this.out, (String)Integer.toHexString(b.length));
            if (b.length > 0) {
                this.out.write(b);
            }
            EasyTool.writeLine((OutputStream)this.out);
            this.out.flush();
            this.data.reset();
        }

        @Override
        public void close() throws IOException {
            this.flush(false);
            this.flush(true);
        }
    }

    private class FixedInputStream
    extends InputStream {
        int length;
        InputStream in;

        FixedInputStream(InputStream _in, int _length) {
            this.in = _in;
            this.length = _length;
        }

        @Override
        public int read() throws IOException {
            if (this.length <= 0) {
                return -1;
            }
            --this.length;
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.length <= 0) {
                return -1;
            }
            if (len > this.length) {
                len = this.length;
            }
            if ((len = this.in.read(b, off, len)) > 0) {
                this.length -= len;
            }
            return len;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }

    private class StreamPipe
    implements Runnable {
        InputStream in;
        OutputStream out;
        Object owner;

        StreamPipe(Object _owner, InputStream _in, OutputStream _out) {
            this.in = _in;
            this.out = _out;
            this.owner = _owner;
        }

        @Override
        public void run() {
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = this.in.read(buf)) > 0) {
                    this.out.write(buf, 0, len);
                    this.out.flush();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            EasyTool.closeAny((Object)this.owner);
        }
    }

    private class HttpRequest {
        public String method;
        public String httpver;
        public String path;
        public String headers;
        public int contentLength = 0;

        public HttpRequest(InputStream in) throws IOException {
            StringBuffer sb = new StringBuffer();
            String line = EasyTool.readLine((InputStream)in);
            int index = line.indexOf(32);
            int index2 = line.lastIndexOf(32);
            this.method = line.substring(0, index).trim();
            this.path = line.substring(index + 1, index2).trim();
            this.httpver = line.substring(index2 + 1).trim();
            sb.append(line);
            sb.append("\r\n");
            while ((line = EasyTool.readLine((InputStream)in)) != null && line.length() != 0) {
                index = line.indexOf(58);
                if (index > 0) {
                    String name = line.substring(0, index).trim();
                    String value = line.substring(index + 1).trim();
                    if (name.equalsIgnoreCase("Content-Length")) {
                        this.contentLength = Integer.parseInt(value);
                    }
                }
                sb.append(line);
                sb.append("\r\n");
            }
            sb.append("\r\n");
            this.headers = sb.toString();
        }

        public void write(OutputStream out) throws IOException {
            out.write(this.headers.getBytes());
        }
    }
}

