/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.io;

import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import java.io.Serializable;
import java.util.Properties;

public class ConnectionConfigure
extends Properties
implements Serializable {
    public static final String COMPRESS_SIZE = "Compress Size";
    public static final int COMPRESS_NONE = Integer.MAX_VALUE;
    public static final int COMPRESS_MIN = 512;
    public static final int COMPRESS_DEFAULT = Integer.MAX_VALUE;

    public ConnectionConfigure() {
        if (ORMRPConfig.isLoaded()) {
            this.setCompressSize(ORMRPConfig.getCompressSize());
        } else {
            this.setCompressSize(Integer.MAX_VALUE);
        }
    }

    public int getPropertyInt(String name, int defaultValue) {
        if (super.containsKey(name)) {
            return Integer.parseInt(super.getProperty(name));
        }
        return defaultValue;
    }

    public void setCompressSize(int size) {
        this.setProperty(COMPRESS_SIZE, String.valueOf(size));
    }

    public int getCompressSize() {
        return this.getPropertyInt(COMPRESS_SIZE, Integer.MAX_VALUE);
    }
}

