/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.loadbalance;

import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.orm.core.ORMEngine;
import com.kingdee.bos.orm.io.IConnectionDriver;
import com.kingdee.bos.orm.io.IConnectionHelper;
import com.kingdee.bos.orm.loadbalance.BalanceConfig;
import com.kingdee.bos.orm.loadbalance.DispatchPolicy;
import com.kingdee.bos.orm.loadbalance.RpcServer;
import com.kingdee.bos.orm.loadbalance.SimplePolicy;
import com.kingdee.bos.orm.template.ORMObject;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LoadBalanceConnectionDriver
extends ORMObject
implements IConnectionDriver {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.bos.orm.loadbalance.LoadBalanceConnectionDriver");
    public static final String PROTO_LOADBALANCE = "loadbalance";
    public RpcServer[] servers;
    public DispatchPolicy policy;

    public LoadBalanceConnectionDriver(RpcServer[] _servers, DispatchPolicy _policy) {
        super.registerInterface(IConnectionDriver.class, this);
        this.servers = _servers;
        this.policy = _policy;
        this.policy.initRpcServers(this.servers);
    }

    public static LoadBalanceConnectionDriver newDriver(BalanceConfig[] servers) {
        SimplePolicy policy = new SimplePolicy();
        RpcServer[] rpcs = new RpcServer[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            RpcServer s;
            rpcs[i] = s = new RpcServer(servers[i].getUrl(), servers[i].getServerProperties());
        }
        if (rpcs.length > 0) {
            return new LoadBalanceConnectionDriver(rpcs, policy);
        }
        return null;
    }

    @Override
    public boolean accept(String url) {
        return url.equalsIgnoreCase(PROTO_LOADBALANCE);
    }

    @Override
    public IConnectionHelper connect(String url, Properties props) throws IOException {
        RpcServer[] servers = this.policy.getRpcServers();
        for (int i = 0; i < servers.length; ++i) {
            RpcServer server = servers[i];
            server.setState(1);
            try {
                IConnectionHelper helper = ORMEngine.connectionManager.directConnect(server.getConnectionUrl(), server.getConnectionProperties());
                server.setState(0);
                return new _ConnectionHelper(server, helper);
            }
            catch (Throwable e) {
                logger.debug((Object)server, e);
                server.setState(2);
                continue;
            }
        }
        throw new IOException("no ormrpc server available.");
    }

    private class _ConnectionHelper
    implements IConnectionHelper {
        IConnectionHelper helper;
        RpcServer server;
        private boolean deleted = false;

        private _ConnectionHelper(RpcServer _server, IConnectionHelper _helper) {
            this.server = _server;
            this.helper = _helper;
            this.server.perf.notifyNewConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendBlock(byte[] data, int off, int len) throws IOException {
            boolean succeeded = false;
            try {
                this.helper.sendBlock(data, off, len);
                this.server.perf.notifyData(len, 0);
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    this.deleteConnection();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] recvBlock() throws IOException {
            boolean succeeded = false;
            try {
                byte[] b = this.helper.recvBlock();
                if (b != null) {
                    this.server.perf.notifyData(0, b.length);
                } else {
                    this.deleteConnection();
                }
                succeeded = true;
                byte[] byArray = b;
                return byArray;
            }
            finally {
                if (!succeeded) {
                    this.deleteConnection();
                }
            }
        }

        @Override
        public void close() {
            this.deleteConnection();
            this.helper.close();
        }

        private synchronized void deleteConnection() {
            if (!this.deleted) {
                this.deleted = true;
                this.server.perf.notifyDeleteConnection();
            }
        }

        @Override
        public void put(Object key, Object value) {
            this.helper.put(key, value);
        }

        @Override
        public Object get(Object key, Object defaultValue) {
            return this.helper.get(key, defaultValue);
        }

        @Override
        public Object get(Object key) {
            return this.helper.get(key);
        }

        @Override
        public IORMModel queryInterface(Class type) throws ORMCoreException {
            return this;
        }
    }
}

