/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.orm.loadbalance;

import java.util.LinkedList;

public class ServerPerformance {
    private int connectionCount = 0;
    private static final long STEP_TIME = 1000L;
    private LinkedList blocks = new LinkedList();

    synchronized void notifyNewConnection() {
        ++this.connectionCount;
    }

    synchronized void notifyDeleteConnection() {
        --this.connectionCount;
    }

    public synchronized int getConnectionCount() {
        return this.connectionCount;
    }

    synchronized void notifyData(int send, int recv) {
        long tm = System.currentTimeMillis();
        while (this.blocks.size() > 0 && tm - ((_Block)this.blocks.get((int)0)).tm > 1000L) {
            this.blocks.removeFirst();
        }
        if (send > 0 || recv > 0) {
            this.blocks.add(new _Block(tm, send, recv));
        }
    }

    private synchronized int getSpeed(int flag) {
        this.notifyData(0, 0);
        int bytes = 0;
        for (int i = 0; i < this.blocks.size(); ++i) {
            _Block bk = (_Block)this.blocks.get(i);
            if ((flag & 1) != 0) {
                bytes += bk.send;
            }
            if ((flag & 2) == 0) continue;
            bytes += bk.recv;
        }
        return (int)((long)bytes * 1000L / 1000L);
    }

    public synchronized int getSendBytesPerSecond() {
        return this.getSpeed(1);
    }

    public synchronized int getRecvBytesPerSecond() {
        return this.getSpeed(2);
    }

    public synchronized int getBytesPerSecond() {
        return this.getSpeed(3);
    }

    private class _Block {
        long tm;
        int send;
        int recv;

        _Block(long _tm, int _send, int _recv) {
            this.tm = _tm;
            this.send = _send;
            this.recv = _recv;
        }
    }
}

